/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.game.Actor;

public class ActorPool {
    private Actor firstFree;
    private Actor lastFree;
    private Actor firstUsed;
    private Actor oldestUsed;
    private Actor lastUsed;

    public ActorPool(Actor[] initObjects) {
        if (initObjects == null || initObjects.length < 2) {
            return;
        }
        this.firstFree = initObjects[0];
        this.lastFree = initObjects[initObjects.length - 1];
        for (int i = 0; i < initObjects.length; ++i) {
            if (i < initObjects.length - 1) {
                initObjects[i].setNextLinked(initObjects[i + 1]);
            } else {
                initObjects[i].setNextLinked(null);
            }
            if (i > 0) {
                initObjects[i].setPrevLinked(initObjects[i - 1]);
                continue;
            }
            initObjects[i].setPrevLinked(null);
        }
    }

    public Actor getNextFree() {
        if (this.firstFree != null) {
            if (this.firstFree.getNextLinked() != null) {
                this.firstFree.getNextLinked().setPrevLinked(null);
            }
            Actor newFirstFree = this.firstFree.getNextLinked();
            this.firstFree.setNextLinked(null);
            if (this.lastUsed != null) {
                this.firstFree.setPrevLinked(this.lastUsed);
                this.lastUsed.setNextLinked(this.firstFree);
            }
            this.lastUsed = this.firstFree;
            if (this.oldestUsed == null) {
                this.oldestUsed = this.firstFree;
            }
            if (this.firstUsed == null) {
                this.firstUsed = this.firstFree;
            }
            if (this.lastFree == this.firstFree) {
                this.lastFree = null;
            }
            Actor actorToReturn = this.firstFree;
            this.firstFree = newFirstFree;
            return actorToReturn;
        }
        Actor actorToReturn = this.oldestUsed;
        if (this.oldestUsed == null) {
            actorToReturn = this.oldestUsed = this.firstUsed;
        }
        this.oldestUsed = this.oldestUsed.getNextLinked();
        return actorToReturn;
    }

    public int getTotalFree() {
        int free = 0;
        for (Actor a2 = this.firstFree; a2 != null; a2 = a2.getNextLinked()) {
            ++free;
        }
        return free;
    }

    public Actor getFreeAt(int index) {
        if (this.firstFree != null) {
            Actor a2 = this.firstFree;
            for (int i = 0; i < index; ++i) {
                if (a2 == null) continue;
                a2 = a2.getNextLinked();
            }
            if (a2 != null && a2 == this.firstFree) {
                this.firstFree = a2.getNextLinked();
            } else if (a2 != null && a2 != this.lastFree) {
                a2.getPrevLinked().setNextLinked(a2.getNextLinked());
                a2.getNextLinked().setPrevLinked(a2.getPrevLinked());
            } else {
                this.lastFree = a2.getPrevLinked();
            }
            a2.setPrevLinked(null);
            a2.setNextLinked(null);
            if (this.lastUsed != null) {
                a2.setPrevLinked(this.lastUsed);
                this.lastUsed.setNextLinked(a2);
            }
            this.lastUsed = a2;
            if (this.oldestUsed == null) {
                this.oldestUsed = a2;
            }
            if (this.firstUsed == null) {
                this.firstUsed = a2;
            }
            if (this.lastFree == a2) {
                this.lastFree = null;
            }
            return a2;
        }
        Actor actorToReturn = this.oldestUsed;
        if (this.oldestUsed == null) {
            actorToReturn = this.oldestUsed = this.firstUsed;
        }
        this.oldestUsed = this.oldestUsed.getNextLinked();
        return actorToReturn;
    }

    public Actor getFree(Actor newActor) {
        int index = 0;
        for (Actor a2 = this.firstFree; a2 != null; a2 = a2.getNextLinked()) {
            ++index;
            if (newActor == a2) break;
        }
        if (index == this.getTotalFree()) {
            --index;
        }
        return this.getFreeAt(index);
    }

    public void dump() {
        Actor a2;
        System.out.print("FREE LIST: ");
        for (a2 = this.firstFree; a2 != null; a2 = a2.getNextLinked()) {
            System.out.print("{" + a2 + "} ");
        }
        System.out.println("");
        System.out.print("USED LIST: ");
        for (a2 = this.firstUsed; a2 != null; a2 = a2.getNextLinked()) {
            System.out.print("{" + a2 + "} ");
        }
        System.out.println("");
        System.out.println("LastUsed: {" + this.lastUsed + "} OldestUsed: {" + this.oldestUsed + "} firstUsed: {" + this.firstUsed + "} LastFree: {" + this.lastFree + "} firstFree: {" + this.firstFree + "}");
    }

    public void release(Actor actorToRelease) {
        if (actorToRelease.getPrevLinked() != null) {
            actorToRelease.getPrevLinked().setNextLinked(actorToRelease.getNextLinked());
        }
        if (actorToRelease.getNextLinked() != null) {
            actorToRelease.getNextLinked().setPrevLinked(actorToRelease.getPrevLinked());
        }
        if (this.oldestUsed == actorToRelease) {
            this.oldestUsed = actorToRelease.getNextLinked();
        }
        if (this.firstUsed == actorToRelease) {
            this.firstUsed = actorToRelease.getNextLinked();
        }
        if (this.lastUsed == actorToRelease) {
            this.lastUsed = actorToRelease.getPrevLinked();
        }
        actorToRelease.setNextLinked(null);
        if (this.firstFree == null) {
            this.firstFree = actorToRelease;
            actorToRelease.setPrevLinked(null);
        }
        if (this.lastFree != null) {
            actorToRelease.setPrevLinked(this.lastFree);
            this.lastFree.setNextLinked(actorToRelease);
        } else {
            actorToRelease.setPrevLinked(null);
        }
        this.lastFree = actorToRelease;
    }

    public Actor getFirstFree() {
        return this.firstFree;
    }

    public Actor getFirstUsed() {
        return this.firstUsed;
    }

    public Actor getLastUsed() {
        return this.lastUsed;
    }

    public void free() {
        Actor old;
        Actor a2;
        for (a2 = this.firstFree; a2 != null; a2 = a2.getNextLinked()) {
            old = a2;
            old = null;
        }
        for (a2 = this.firstUsed; a2 != null; a2 = a2.getNextLinked()) {
            old = a2;
            old = null;
        }
    }
}

