/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.tools;

public abstract class MathFP {
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = -2147483647;
    public static final int E = 11134;
    public static final int PI = 12868;
    private static final int[] SIN_TABLE = new int[]{0, 71, 142, 214, 285, 357, 428, 499, 570, 641, 711, 781, 851, 921, 990, 1060, 1128, 1197, 1265, 1333, 1400, 1468, 1534, 1600, 1665, 1730, 1795, 1859, 1922, 1985, 2048, 2109, 2170, 2230, 2290, 2349, 2407, 2464, 2521, 2577, 2632, 2686, 2740, 2793, 2845, 2896, 2946, 2995, 3043, 3091, 3137, 3183, 3227, 3271, 3313, 3355, 3395, 3434, 3473, 3510, 3547, 3582, 3616, 3649, 3681, 3712, 3741, 3770, 3797, 3823, 3849, 3872, 3895, 3917, 3937, 3956, 3974, 3991, 4006, 4020, 4033, 4045, 4056, 4065, 4073, 4080, 4086, 4090, 4093, 4095, 4096};

    private MathFP() {
    }

    public static int toFP(int i) {
        return i << 12;
    }

    public static int toFP(String s) {
        int i = 0;
        if (s.charAt(0) == '-') {
            i = 1;
        }
        String s1 = "-1";
        int j = s.indexOf(46);
        if (j >= 0) {
            s1 = s.substring(j + 1, s.length());
            while (s1.length() < 4) {
                s1 = s1 + "0";
            }
            if (s1.length() > 4) {
                s1 = s1.substring(0, 4);
            }
        } else {
            j = s.length();
        }
        int k = Integer.parseInt(s.substring(i, j));
        int l = Integer.parseInt(s1) + 1;
        int i1 = (k << 12) + (l << 12) / 10000;
        if (i == 1) {
            i1 = -i1;
        }
        return i1;
    }

    public static String toString(int i) {
        boolean flag = false;
        if (i < 0) {
            flag = true;
            i = -i;
        }
        int j = i >> 12;
        int k = 10000 * (i & 0xFFF) >> 12;
        String s = Integer.toString(k);
        while (s.length() < 4) {
            s = "0" + s;
        }
        return (flag ? "-" : "") + Integer.toString(j) + "." + s;
    }

    public static String toString(int i, int j) {
        String s = MathFP.toString(MathFP.round(i, j));
        return s.substring(0, s.length() - 4 + j);
    }

    public static int round(int i, int j) {
        int k = 0;
        if (j < 0 || j > 4) {
            j = 4;
        }
        if (j == 0) {
            k = 2048;
            j = -1;
        }
        if (j == 1) {
            k = 205;
        }
        if (j == 2) {
            k = 20;
        }
        if (j == 3) {
            k = 2;
        }
        if (i < 0) {
            k = -k;
        }
        return i + k;
    }

    public static int toInt(int i) {
        i = i >= 0 ? (i += 2048) : (i -= 2048);
        return i >> 12;
    }

    public static int div(int i, int j) {
        boolean flag = false;
        if (j == 4096) {
            return i;
        }
        if ((j & 0xFFF) == 0) {
            return i / (j >> 12);
        }
        if (i < 0) {
            i = -i;
            flag = true;
        }
        if (j < 0) {
            j = -j;
            flag = !flag;
        }
        int byte0 = 0;
        if (i > 413695) {
            byte0 = 3;
        }
        if (i > 4100095) {
            byte0 = 4;
        }
        if (i > 0x7DFFFF) {
            byte0 = 6;
        }
        if (i > 0x1F4FFFF) {
            byte0 = 8;
        }
        if (i > 0x7DFFFFF) {
            byte0 = 10;
        }
        if (byte0 > 0) {
            int k = 2 << byte0 - 1;
            i += k;
            j += k;
        }
        int l = (i << 12 - byte0) / (j >> byte0);
        return flag ? -l : l;
    }

    public static int mul(int i, int j) {
        boolean flag = false;
        if ((i & 0xFFF) == 0) {
            return (i >> 12) * j;
        }
        if ((j & 0xFFF) == 0) {
            return i * (j >> 12);
        }
        if (i < 0 && j > 0 || i > 0 && j < 0) {
            flag = true;
        }
        if (i < 0) {
            i = -i;
        }
        if (j < 0) {
            j = -j;
        }
        int byte0 = 0;
        if (i > 413695 || j > 413695) {
            byte0 = 2;
        }
        if (i > 4100095 || j > 4100095) {
            byte0 = 4;
        }
        if (i > 41025535 || j > 41025535) {
            byte0 = 6;
        }
        if (byte0 > 0) {
            int k = 2 << byte0 - 1;
            i += k;
            j += k;
        }
        int l = (i >> 12) * (j >> 12) << 12;
        int i1 = (i & 0xFFF) * (j & 0xFFF) >> 12;
        if ((l = l + (i1 += ((i & 0xFFFFF000) >> byte0) * ((j & 0xFFF) >> byte0) >> 12 - (byte0 << 1)) + (((i & 0xFFF) >> byte0) * ((j & 0xFFFFF000) >> byte0) >> 12 - (byte0 << 1))) < 0) {
            throw new ArithmeticException("Overflow");
        }
        return flag ? -l : l;
    }

    public static int add(int i, int j) {
        return i + j;
    }

    public static int sub(int i, int j) {
        return i - j;
    }

    public static int abs(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public static int sqrt(int i, int j) {
        if (i < 0) {
            throw new ArithmeticException("Input Error");
        }
        if (i == 0) {
            return 0;
        }
        int k = i + 4096 >> 1;
        for (int l = 0; l < j; ++l) {
            k = k + MathFP.div(i, k) >> 1;
        }
        if (k < 0) {
            throw new ArithmeticException("Overflow");
        }
        return k;
    }

    public static int sqrt(int i) {
        int byte0 = 8;
        if (i > 409600) {
            byte0 = 12;
        }
        if (i > 4096000) {
            byte0 = 16;
        }
        return MathFP.sqrt(i, byte0);
    }

    public static int sin(int i) {
        int j = 0;
        while (i < 0) {
            i += 25736;
        }
        if (i > 25736) {
            i %= 25736;
        }
        int k = i * 10 / 714;
        if (i != 0 && i != 6434 && i != 12868 && i != 19302 && i != 25736) {
            j = i * 100 / 714 - k * 10;
        }
        if (k <= 90) {
            return MathFP.sin_lookup(k, j);
        }
        if (k <= 180) {
            return MathFP.sin_lookup(180 - k, j);
        }
        if (k <= 270) {
            return -MathFP.sin_lookup(k - 180, j);
        }
        return -MathFP.sin_lookup(360 - k, j);
    }

    private static int sin_lookup(int i, int j) {
        if (j > 0 && j < 10 && i < 90) {
            return SIN_TABLE[i] + (SIN_TABLE[i + 1] - SIN_TABLE[i]) / 10 * j;
        }
        return SIN_TABLE[i];
    }

    public static int cos(int i) {
        return MathFP.sin(i + 6435);
    }

    public static int tan(int i) {
        int j = MathFP.div(MathFP.sin(i), MathFP.cos(i));
        return j;
    }

    public static int cot(int i) {
        int j = MathFP.div(MathFP.toFP(1), MathFP.tan(i));
        return j;
    }

    public static int min(int i, int j) {
        return j >= i ? i : j;
    }

    public static int max(int i, int j) {
        return i >= j ? i : j;
    }

    public static int asin(int i) {
        boolean flag = false;
        if (i < 0) {
            flag = true;
        }
        if (MathFP.abs(i) > 4096) {
            throw new ArithmeticException("Input error");
        }
        i = MathFP.abs(i);
        int j = 0;
        int k = SIN_TABLE.length;
        for (int l = 0; l < SIN_TABLE.length; ++l) {
            int i1 = MathFP.abs(i - SIN_TABLE[l]);
            if (i1 >= k) continue;
            k = i1;
            j = l;
        }
        if (flag) {
            return -(j * 72);
        }
        return j * 72;
    }

    public static int acos(int i) {
        return 6434 - MathFP.asin(i);
    }

    public static int atan(int i) {
        return MathFP.asin(MathFP.div(i, MathFP.sqrt(4096 + MathFP.mul(i, i))));
    }

    public static int exp(int i) {
        int j = MathFP.abs(i) >> 12;
        if (j > 13) {
            throw new ArithmeticException("Overflow");
        }
        int[] ai = new int[]{4096, 11134, 30266, 82270, 223634, 607900, 1652444, 4491809, 12210004, 33190232, 90220404, 245244484, 666643625, 1812125254};
        int k = ai[j];
        int l = MathFP.abs(i) & 0xFFF;
        if (l > 0) {
            int i1 = 0;
            int j1 = 4096;
            int k1 = 1;
            for (int l1 = 0; l1 < 6; ++l1) {
                i1 += j1 / k1;
                j1 = MathFP.mul(j1, l);
                k1 *= l1 + 1;
            }
            k = MathFP.mul(k, i1);
        }
        if (i < 0) {
            return MathFP.div(4096, k);
        }
        return k;
    }

    public static int log(int i) {
        int k;
        if (i <= 0) {
            throw new ArithmeticException("Input error");
        }
        int j = 0;
        int l = 0;
        while (i > 8192) {
            i >>= 1;
            ++l;
        }
        int i1 = l * 2839;
        int j1 = 0;
        i -= 4096;
        for (int k1 = 1; k1 < 11 && (k = j == 0 ? i : MathFP.mul(j, i)) != 0; ++k1) {
            j1 += (k1 % 2 != 0 ? 1 : -1) * k / k1;
            j = k;
        }
        return i1 + j1;
    }

    public static int pow(int i, int j) {
        boolean flag = false;
        int k = 1;
        if (j < 0) {
            flag = true;
            j = -j;
        }
        if (MathFP.abs(i) < 4096 && j > 12288) {
            k = MathFP.exp(MathFP.mul(MathFP.log(i), j));
        } else {
            k = MathFP.pow_int(i, j >> 12);
            if ((j & 0xFFF) != 0) {
                k = MathFP.mul(k, MathFP.exp(MathFP.mul(MathFP.log(i), j & 0xFFF)));
            }
        }
        if (flag) {
            return MathFP.div(4096, k);
        }
        return k;
    }

    private static int pow_int(int i, int j) {
        int k = 4096;
        if (i == 0) {
            return 0;
        }
        for (int l = 0; l < j; ++l) {
            k = MathFP.mul(k, i);
        }
        if (k < 0) {
            throw new ArithmeticException("Overflow");
        }
        return k;
    }
}

