/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.tools;

import com.manthanstudio.tools.UIFont;
import java.util.Vector;

public class StringUtils {
    private static char widestChar = (char)87;

    private static int indexOf(char[] t, char c, int offset, int length) {
        for (int iter = offset; iter < t.length && iter < offset + length; ++iter) {
            if (t[iter] != c) continue;
            return iter;
        }
        return -1;
    }

    private static boolean fastCharWidthCheck(char[] chrs, int off, int length, int width, int charWidth, byte uiFont) {
        if (length * charWidth < width) {
            return true;
        }
        return UIFont.stringWidth(new String(chrs), uiFont) < width;
    }

    public static Vector initRowString(String strText, byte uiFont, int width) {
        String unsupportedChars = "\t\r";
        String textString = strText;
        boolean rows = true;
        int widthForRowCalculations = -1;
        Vector<String> rowStrings = new Vector<String>();
        widthForRowCalculations = width;
        char[] text = textString.toCharArray();
        int charWidth = UIFont.charWidth(widestChar, uiFont);
        int textAreaWidth = width;
        int minCharactersInRow = Math.max(1, textAreaWidth / charWidth);
        int rowIndex = 0;
        int from = 0;
        int to = from + minCharactersInRow;
        int textLength = text.length;
        to = Math.max(Math.min(textLength - 1, to), 0);
        while (to < textLength) {
            int i;
            if (to > textLength) {
                to = textLength;
            }
            int spaceIndex = -1;
            String rowText = "";
            int maxLength = to;
            for (i = to; i < textLength && StringUtils.fastCharWidthCheck(text, from, i - from, textAreaWidth, charWidth, uiFont); ++i) {
                int c = text[i];
                if (unsupportedChars.indexOf(c) > -1) {
                    text[i] = 32;
                    c = 32;
                }
                if (c == 32 || c == 124) {
                    spaceIndex = i;
                    if (c == 124) break;
                }
                ++maxLength;
            }
            if (i == textLength || text[i] == ' ' || text[i] == '|') {
                spaceIndex = i;
            }
            if (spaceIndex != -1) {
                int newLine = StringUtils.indexOf(text, '|', from, spaceIndex - from);
                if (newLine > -1 && newLine < spaceIndex) {
                    spaceIndex = newLine;
                }
                rowText = new String(text, from, spaceIndex - from);
                from = spaceIndex + 1;
            } else {
                for (i = to; spaceIndex == -1 && i >= from; --i) {
                    char chr = text[i];
                    if (chr != ' ' && chr != '|' && chr != '\t') continue;
                    spaceIndex = i;
                    int newLine = StringUtils.indexOf(text, '|', from, i - from);
                    if (newLine > -1 && newLine < spaceIndex) {
                        spaceIndex = newLine;
                    }
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex + 1;
                }
                if (spaceIndex == -1) {
                    if (maxLength <= 0) {
                        maxLength = 1;
                    }
                    spaceIndex = maxLength;
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex;
                }
            }
            rowStrings.addElement(rowText);
            to = from;
            ++rowIndex;
        }
        return rowStrings;
    }
}

