/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class SensorCanvas
implements DataListener,
Runnable {
    private int width;
    private int height;
    private int d = 2 * this.r;
    private int r = 5;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    private int xcoord = this.width / 2 - this.r;
    private int ycoord = this.height / 2 - this.r;
    private static SensorConnection sensor = null;
    private SensorInfo[] infos;
    private static boolean isStopped = false;
    private static boolean sensor_found = false;
    private static final int BUFFER_SIZE = 3;
    private Thread thread = null;

    public SensorCanvas() {
        this.start();
    }

    private synchronized void initSensor() {
        sensor = this.openSensor();
        if (sensor == null) {
            return;
        }
        try {
            sensor.setDataListener((DataListener)this, 3);
            while (!isStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {}
            }
            sensor.removeDataListener();
        }
        catch (IllegalMonitorStateException imse) {
            imse.printStackTrace();
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        try {
            sensor.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (isStopped) {
            sensor = null;
        }
    }

    private SensorConnection openSensor() {
        this.infos = SensorManager.findSensors((String)"acceleration", null);
        if (this.infos.length == 0) {
            return null;
        }
        int[] datatypes = new int[this.infos.length];
        int i = 0;
        String sensor_url = "";
        while (!sensor_found) {
            datatypes[i] = this.infos[i].getChannelInfos()[0].getDataType();
            if (datatypes[i] == 1) {
                sensor_url = this.infos[i].getUrl();
                sensor_found = true;
                continue;
            }
            ++i;
        }
        try {
            return (SensorConnection)Connector.open((String)sensor_url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public void dataReceived(SensorConnection sensor, Data[] data, boolean isDataLost) {
        double[] directions = SensorCanvas.getDirections(data);
        this.x = directions[0];
        this.y = directions[1];
        this.z = directions[2];
    }

    private static double[] getDirections(Data[] data) {
        double[][] doubleValues = new double[3][3];
        double[] directions = new double[3];
        for (int i = 0; i < 3; ++i) {
            doubleValues[i] = data[i].getDoubleValues();
            double temp = 0.0;
            for (int j = 0; j < 3; ++j) {
                temp += doubleValues[i][j];
            }
            directions[i] = temp / 3.0;
        }
        return directions;
    }

    private synchronized void setStopped(boolean stopped) {
        isStopped = stopped;
        this.notify();
        if (this.thread != null) {
            this.thread = null;
        }
    }

    synchronized void start() {
        this.setStopped(false);
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    synchronized void stop() {
        this.setStopped(true);
        this.thread = null;
    }

    public void run() {
        this.initSensor();
    }
}

