/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Event {
    public static final int TYPE_BODY_POSITION = 0;
    public static final int TYPE_BODY_VELOCITY = 1;
    public static final int TYPE_BODY_ROTATION = 2;
    public static final int TYPE_BODY_ANGULARVELOCITY = 3;
    public static final int TYPE_BODY_COLLISION = 4;
    public static final int TYPE_BODY_COLLISION_RELATIVE = 6;
    public static final int TYPE_BODY_SENSOR = 5;
    public static final int TYPE_CONSTRAINT_FORCE = 10;
    private int b;
    int a;
    private boolean a;
    private int c;
    private int d;
    private int e;
    private int f;
    private Object a;
    private Body a;
    private Shape a;
    private Constraint a;
    private Script a;
    private Vector a;
    private UserData a = null;
    private static FXMatrix a = new FXMatrix();
    private static FXVector a = new FXVector();
    private static FXVector b = new FXVector();

    public static Event createBodyEvent(Body body, Shape shape, int n2, int n3, int n4, int n5, int n6) {
        return new Event(body, shape, null, n2, n3, n4, n5, n6, null);
    }

    public static Event createCollisionRelativeEvent(Body body, Shape shape, int n2, int n3) {
        long l2 = (long)n2 * 52707178L / 180L;
        n2 = FXUtil.wrapAngleFX((int)((long)n3 * 52707178L / 180L - l2) / 2);
        n2 = FXUtil.wrapAngleFX((int)(l2 + (long)n2));
        a.setRotationMatrix(n2);
        a.mult(FXVector.M_UNITY, a);
        a.setRotationMatrix((int)l2);
        a.mult(FXVector.M_UNITY, b);
        n3 = (int)((long)Event.a.xFX * (long)Event.b.xFX + (long)Event.a.yFX * (long)Event.b.yFX >> 12);
        return new Event(body, shape, null, 6, n2, n3, 0, 0, null);
    }

    public static Event createBodySensorEvent(Body body, Shape shape, Body body2) {
        body2.a(0);
        return new Event(body, shape, null, 5, 0, 0, 0, 0, body2);
    }

    public static Event createConstraintEvent(Constraint constraint, int n2, int n3, int n4) {
        return new Event(null, null, constraint, n2, n3, n4, 0, 0, null);
    }

    private Event(Body body, Shape shape, Constraint constraint, int n2, int n3, int n4, int n5, int n6, Object object) {
        this.a = -1;
        this.b = n2;
        this.a = object;
        switch (n2) {
            case 2: 
            case 3: {
                this.c = n3 * 52707178 / 180;
                this.d = n4 * 52707178 / 180;
                break;
            }
            case 1: {
                this.c = n3 * n3 << 12;
                this.d = n4 * n4 << 12;
                break;
            }
            case 6: {
                this.c = n3;
                this.d = n4;
                break;
            }
            default: {
                this.c = n3 << 12;
                this.d = n4 << 12;
                this.e = n5 << 12;
                this.f = n6 << 12;
            }
        }
        this.a = body;
        this.a = shape;
        this.a = constraint;
    }

    private Event(Event event, Body[] bodyArray) {
        this(bodyArray != null && event.a != null ? bodyArray[event.a.i] : event.a, event.a, event.a, event.b, 0, 0, 0, 0, event.a != null && event.a instanceof Body && bodyArray != null && ((Body)event.a).i >= 0 ? bodyArray[((Body)event.a).i] : event.a);
        this.c = event.c;
        this.d = event.d;
        this.e = event.e;
        this.f = event.f;
        if (event.a != null) {
            this.a = event.a.copy();
        }
        this.setTriggerOnce(event.a);
    }

    private Event(int n2) {
        this.b = n2;
    }

    public Event copy(Body[] bodyArray) {
        return new Event(this, bodyArray);
    }

    public static Event loadEvent(PhysicsFileReader physicsFileReader, World world, UserData userData) {
        int n2;
        int n3 = physicsFileReader.next();
        int n4 = physicsFileReader.getVersion();
        if ((n4 & 0xFF00) < 1024) {
            physicsFileReader.next();
        }
        Event event = new Event(n3);
        if ((n4 & 0xFF00) >= 1024) {
            event.setTriggerOnce(physicsFileReader.next() > 0);
        }
        if ((n2 = physicsFileReader.next()) >= 0 && n2 != 255) {
            event.a = world.getBodies()[n2];
        }
        if ((n2 = physicsFileReader.next()) >= 0 && n2 != 255) {
            event.a = (Shape)world.getShapeSet().getShapes().elementAt(n2);
        }
        if ((n4 & 0xFF00) >= 1024 && (n4 = physicsFileReader.next()) >= 0 && n4 != 255) {
            event.a = world.getConstraints()[n4];
        }
        event.c = physicsFileReader.nextIntFX();
        event.d = physicsFileReader.nextIntFX();
        event.e = physicsFileReader.nextIntFX();
        event.f = physicsFileReader.nextIntFX();
        if (event.b == 5) {
            Body body = Body.loadBody(physicsFileReader, world.a.getShapes(), userData);
            event.a = body;
        }
        if (physicsFileReader.getVersion() > 1792) {
            String string = physicsFileReader.nextString();
            if (userData != null) {
                event.a = userData.createNewUserData(string, 3);
            }
        }
        return event;
    }

    public int getIdentifier() {
        return this.a;
    }

    public int type() {
        return this.b;
    }

    public void setScript(Script script) {
        this.a = script;
    }

    public void setBodyFilter(Body body) {
        this.a = body;
    }

    public Body getBodyFilter() {
        return this.a;
    }

    public void setShapeFilter(Shape shape) {
        this.a = shape;
    }

    public Shape getShapeFilter() {
        return this.a;
    }

    public Object getTargetObject() {
        return this.a;
    }

    public Constraint getConstraintFilter() {
        return this.a;
    }

    public void setTriggerOnce(boolean bl) {
        this.a = bl;
        if (bl) {
            this.a = new Vector();
            return;
        }
        this.a = null;
    }

    public boolean getTriggerOnce() {
        return this.a;
    }

    public boolean checkEvent(World world, PhysicsEventListener physicsEventListener) {
        if (physicsEventListener == null) {
            return false;
        }
        boolean bl = false;
        switch (this.b) {
            case 10: {
                if (this.a != null) {
                    bl = this.a(this.a, physicsEventListener);
                    break;
                }
                for (int i2 = 0; i2 < world.d; ++i2) {
                    bl |= this.a(world.a[i2], physicsEventListener);
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (this.a != null) {
                    bl = this.a(world, this.a, physicsEventListener);
                    break;
                }
                for (int i3 = 0; i3 < world.a; ++i3) {
                    bl |= this.a(world, world.a[i3], physicsEventListener);
                }
                break;
            }
            case 5: {
                if (this.a != null) {
                    bl = this.a(world, this.a, physicsEventListener);
                    break;
                }
                Body[] bodyArray = world.a;
                Body body = (Body)this.a;
                for (int i4 = 0; i4 < world.a; ++i4) {
                    if (!bodyArray[i4].a || bodyArray[i4].f > body.g || body.f > bodyArray[i4].g || bodyArray[i4].d > body.e || body.d > bodyArray[i4].e) continue;
                    bl |= this.a(world, bodyArray[i4], physicsEventListener);
                }
                break;
            }
        }
        return bl;
    }

    private final boolean a(World world, Body body, PhysicsEventListener physicsEventListener) {
        if (this.a != null && body.a != this.a) {
            return false;
        }
        Object object = null;
        boolean bl = false;
        block0 : switch (this.b) {
            case 0: {
                if (this.c > body.a.xFX || body.a.xFX > this.e || this.d > body.a.yFX || body.a.yFX > this.f) break;
                bl = true;
                object = body;
                break;
            }
            case 1: {
                int n2 = body.b.lengthSquareFX();
                if (this.c > n2 || n2 > this.d) break;
                bl = true;
                object = body;
                break;
            }
            case 2: {
                if (this.c > body.a || body.a > this.d) break;
                bl = true;
                object = body;
                break;
            }
            case 3: {
                if (this.c > body.b || body.b > this.d) break;
                bl = true;
                object = body;
                break;
            }
            case 4: {
                Contact[] contactArray = body.getContacts();
                for (int i2 = 0; i2 < contactArray.length && contactArray[i2] != null; ++i2) {
                    if (!(this.c > 0 && contactArray[i2].a.yFX < body.a.yFX || this.d > 0 && contactArray[i2].a.xFX > body.a.xFX || this.e > 0 && contactArray[i2].a.yFX > body.a.yFX) && (this.f <= 0 || contactArray[i2].a.xFX >= body.a.xFX)) continue;
                    bl = true;
                    object = contactArray[i2];
                    break block0;
                }
                break;
            }
            case 6: {
                int n3 = FXUtil.wrapAngleFX(this.c + body.rotation2FX());
                a.setRotationMatrix(n3);
                a.mult(FXVector.M_UNITY, a);
                Contact[] contactArray = body.getContacts();
                for (n3 = 0; n3 < contactArray.length && contactArray[n3] != null; ++n3) {
                    b.assignDiff(body.a, contactArray[n3].a);
                    b.normalize();
                    if ((long)Event.a.xFX * (long)Event.b.xFX + (long)Event.a.yFX * (long)Event.b.yFX >> 12 >= (long)this.d) {
                        bl = true;
                        object = contactArray[n3];
                        break block0;
                    }
                    if (contactArray[n3].isSingle()) continue;
                    b.assignDiff(body.a, contactArray[n3].b);
                    b.normalize();
                    if ((long)Event.a.xFX * (long)Event.b.xFX + (long)Event.a.yFX * (long)Event.b.yFX >> 12 < (long)this.d) continue;
                    bl = true;
                    object = contactArray[n3];
                    break block0;
                }
                break;
            }
            case 5: {
                if (Collision.detectCollision(body, (Body)this.a) == null) break;
                bl = true;
                object = body;
            }
        }
        if (bl) {
            if (!this.a || this.a(object)) {
                if (this.a == null) {
                    physicsEventListener.eventTriggered(this, object);
                } else {
                    this.a.applyToBody(body, world);
                }
            }
        } else if (this.a) {
            this.a(object);
        }
        return bl;
    }

    private final boolean a(Constraint constraint, PhysicsEventListener physicsEventListener) {
        switch (this.b) {
            case 10: {
                int n2 = constraint.getImpulseFX();
                if (this.c <= n2 && n2 <= this.d) {
                    if (!this.a || this.a(constraint)) {
                        physicsEventListener.eventTriggered(this, constraint);
                    }
                    return true;
                }
                if (!this.a) break;
                this.a(constraint);
            }
        }
        return false;
    }

    private boolean a(Object object) {
        if (this.a.contains(object)) {
            return false;
        }
        this.a.addElement(object);
        return true;
    }

    private void a(Object object) {
        this.a.removeElement(object);
    }

    public UserData getUserData() {
        return this.a;
    }

    public void setUserData(UserData userData) {
        this.a = userData;
    }
}

