/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.Event;
import at.emini.physics2D.EventSet;
import at.emini.physics2D.ExternalForce;
import at.emini.physics2D.Joint;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.Motor;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.ShapeSet;
import at.emini.physics2D.Spring;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class World {
    private PhysicsEventListener a;
    private FXVector a;
    private int h = 0;
    private int i = 0;
    private int j = 204;
    private long a;
    private int k = 10;
    private int l = 5;
    private boolean a;
    public static final int M_SHAPE_MAX_VERTICES = 12;
    protected ShapeSet a;
    private EventSet a;
    private Body[] c;
    private int m;
    private int n;
    int a;
    Body[] a;
    private int o = 0;
    private int p = 0;
    private int q;
    private Landscape a;
    int b;
    Contact[] a;
    static int c = 0;
    static Contact[] b = new Contact[32];
    int d = 0;
    Constraint[] a;
    private Vector b;
    protected Vector a;
    Script[] a;
    int e = 0;
    Body[] b;
    int[] a;
    int[] b = 0;
    int[] c;
    int f = 0;
    static int g = 0;
    private UserData a = null;

    public World() {
        this.c = new Body[128];
        this.m = Integer.MIN_VALUE;
        this.n = Integer.MAX_VALUE;
        this.a = new Body[128];
        this.q = this.a;
        this.a = new Landscape();
        this.a = new Contact[128];
        this.a = new Constraint[32];
        this.b = new Vector();
        this.a = new Vector();
        this.a = new Script[32];
        this.b = new Body[32];
        this.a = new int[32];
        this.b = new int[32];
        this.c = new int[32];
    }

    public World(World world) {
        this.c = new Body[128];
        this.m = Integer.MIN_VALUE;
        this.n = Integer.MAX_VALUE;
        this.a = new Body[128];
        this.q = this.a;
        this.a = new Landscape();
        this.a = new Contact[128];
        this.a = new Constraint[32];
        this.b = new Vector();
        this.a = new Vector();
        this.a = new Script[32];
        this.b = new Body[32];
        this.a = new int[32];
        this.b = new int[32];
        this.c = new int[32];
        if (world == null) {
            return;
        }
        this.a = world.a.copy();
        this.a.assign(world.a);
        this.h = world.h;
        this.i = world.i;
        this.m = world.m;
        this.n = world.n;
        this.j = world.j;
        this.a = world.a;
        this.k = world.k;
        this.l = world.l;
        this.addWorld(world);
        this.a = world.a.copy();
        if (world.a != null) {
            this.setLandscape(world.a.copy());
        }
        if (world.a != null) {
            this.a = world.a.copy();
        }
    }

    public UserData getUserData() {
        return this.a;
    }

    public void setUserData(UserData userData) {
        this.a = userData;
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader) {
        return World.loadWorld(physicsFileReader, null);
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader, UserData userData) {
        int n2 = physicsFileReader.getVersion();
        if ((n2 & 0xFF00) < 256 || (n2 & 0xFF00) > 2560) {
            return null;
        }
        World world = new World();
        Vector<Shape> vector = new Vector<Shape>();
        Vector<Body> vector2 = new Vector<Body>();
        int n3 = 0;
        while (n3 != -1) {
            switch (n3) {
                case 1: {
                    int n4;
                    int n5;
                    int n6 = physicsFileReader.next();
                    for (n5 = 0; n5 < n6; ++n5) {
                        vector.addElement(Shape.loadShape(physicsFileReader, userData));
                    }
                    if (n2 > 2048) {
                        n5 = physicsFileReader.next();
                        for (n4 = 0; n4 < n5; ++n4) {
                            vector.addElement(MultiShape.loadShape(physicsFileReader, userData, vector));
                        }
                    }
                    world.a.registerShapes(vector);
                    break;
                }
                case 2: {
                    int n5;
                    int n7 = physicsFileReader.next();
                    for (n5 = 0; n5 < n7; ++n5) {
                        Body body = Body.loadBody(physicsFileReader, vector, userData);
                        vector2.addElement(body);
                        world.addBody(body);
                    }
                    break;
                }
                case 6: {
                    world.setLandscape(Landscape.loadLandscape(physicsFileReader));
                    break;
                }
                case 3: {
                    int n5;
                    int n8 = physicsFileReader.next();
                    for (n5 = 0; n5 < n8; ++n5) {
                        world.addConstraint(World.loadConstraint(physicsFileReader, vector2, userData));
                    }
                    break;
                }
                case 4: {
                    int n4;
                    int n5;
                    int n9 = physicsFileReader.next();
                    for (n5 = 0; n5 < n9; ++n5) {
                        world.addScript(Script.loadScript(physicsFileReader));
                    }
                    world.f = physicsFileReader.next();
                    for (n5 = 0; n5 < world.f; ++n5) {
                        n4 = physicsFileReader.next();
                        int n10 = physicsFileReader.next();
                        if (n10 < 0 || n10 >= vector2.size() || n4 >= n9) continue;
                        world.a[n5] = physicsFileReader.next();
                        world.b[n5] = (Body)vector2.elementAt(physicsFileReader.next());
                    }
                    break;
                }
                case 5: {
                    int n5;
                    int n11 = physicsFileReader.next();
                    for (n5 = 0; n5 < n11; ++n5) {
                        world.addEvent(Event.loadEvent(physicsFileReader, world, userData));
                    }
                    break;
                }
                case 7: {
                    world.setGravity(physicsFileReader.nextVector());
                    if (physicsFileReader.getVersion() > 2304) {
                        world.setDampingLateralFX(physicsFileReader.nextInt());
                        world.setDampingRotationalFX(physicsFileReader.nextInt());
                    } else {
                        int n12 = 4096 - physicsFileReader.nextInt();
                        world.setDampingLateralFX(n12);
                        world.setDampingRotationalFX(n12);
                    }
                    if (physicsFileReader.getVersion() <= 1792) break;
                    String string = physicsFileReader.nextString();
                    if (userData == null) break;
                    world.a = userData.createNewUserData(string, 6);
                    break;
                }
                case 8: {
                    int n5;
                    int n13 = physicsFileReader.next();
                    for (n5 = 0; n5 < n13; ++n5) {
                        world.addParticleEmitter(ParticleEmitter.loadParticleEmitter(physicsFileReader, world, userData));
                    }
                    break;
                }
            }
            if ((n2 & 0xFF00) == 256) {
                if (++n3 == 4) {
                    ++n3;
                }
                if (n3 <= 5) continue;
                break;
            }
            n3 = physicsFileReader.next();
        }
        physicsFileReader.close();
        return world;
    }

    public int getTimestepFX() {
        return this.j;
    }

    public long getInverseTimestepFX() {
        return this.a;
    }

    public void setTimestepFX(int n2) {
        this.j = n2;
        this.a = 0x1000000 / this.j;
    }

    public void setConstraintIterations(int n2) {
        this.k = n2;
    }

    public void setPositionConstraintIterations(int n2) {
        this.l = n2;
    }

    public int getConstraintIterations() {
        return this.k;
    }

    public int getPositionConstraintIterations() {
        return this.l;
    }

    public void setConstraintIterationDynamic(boolean bl) {
        this.a = bl;
    }

    public void setPhysicsEventListener(PhysicsEventListener physicsEventListener) {
        this.a = physicsEventListener;
    }

    public void setSimulationArea(int n2, int n3) {
        this.m = n2 << 12;
        this.n = n3 << 12;
    }

    public ShapeSet getShapeSet() {
        return this.a;
    }

    public Body[] addWorld(World world) {
        Body body;
        int n2;
        Body[] bodyArray = new Body[world.o];
        for (n2 = 0; n2 < world.a; ++n2) {
            body = world.a[n2].copy();
            this.addBody(body);
            body.a(0);
            bodyArray[world.a[n2].i] = body;
        }
        for (n2 = 0; n2 < world.d; ++n2) {
            this.addConstraint(world.a[n2].copy(bodyArray));
        }
        for (n2 = 0; n2 < world.e; ++n2) {
            this.addScript(world.a[n2].copy());
        }
        for (n2 = 0; n2 < world.f; ++n2) {
            body = bodyArray[world.b[n2].i];
            this.a[world.a[n2]].applyToBody(body, this);
            this.b[n2] = world.b[n2];
            this.c[n2] = world.c[n2];
        }
        for (n2 = 0; n2 < world.b.size(); ++n2) {
            this.addParticleEmitter(((ParticleEmitter)world.b.elementAt(n2)).copy(bodyArray));
        }
        for (n2 = 0; n2 < world.a.size(); ++n2) {
            this.addExternalForce(((ExternalForce)world.a.elementAt(n2)).copy(bodyArray));
        }
        Vector vector = world.a.getEvents();
        int n3 = vector.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.addEvent(((Event)vector.elementAt(i2)).copy(bodyArray));
        }
        Landscape landscape = world.getLandscape();
        for (int i3 = 0; i3 < landscape.a; ++i3) {
            this.a.addSegment(new FXVector(landscape.a[i3]), new FXVector(landscape.b[i3]), landscape.a[i3]);
        }
        return bodyArray;
    }

    public void addBody(Body body) {
        if (body != null) {
            body.i = this.o++;
            this.a = World.a(this.a, this.a);
            this.a[this.a++] = body;
            this.a.registerShape(body.a);
            this.a();
            body.forceUpdate(this.j);
        }
    }

    public void setLandscape(Landscape landscape) {
        this.a = landscape;
    }

    public Landscape getLandscape() {
        return this.a;
    }

    public void addParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.b.addElement(particleEmitter);
        }
    }

    public void addExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.a.addElement(externalForce);
        }
    }

    public void removeBody(Body body) {
        int n2;
        int n3;
        if (body.i < 0) {
            return;
        }
        for (n3 = 0; n3 < this.a; ++n3) {
            if (this.a[n3] != body) continue;
            this.a[n3] = null;
            break;
        }
        this.a = World.a((Object[])this.a, this.a);
        this.a();
        for (n3 = 0; n3 < this.f; ++n3) {
            if (this.b[n3] != body) continue;
            this.b[n3] = -1;
            this.c[n3] = -1;
            this.a[n3] = -1;
            this.b[n3] = null;
            World.a(this.b, this.f);
            World.a(this.c, this.f);
            World.a(this.a, this.f);
            this.f = World.a((Object[])this.b, this.f);
        }
        n3 = this.d;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.a[n2].concernsBody(body)) continue;
            this.a[n2] = null;
        }
        this.d = World.a(this.a, this.d);
        for (n3 = this.b.size() - 1; n3 >= 0; --n3) {
            if (((ParticleEmitter)this.b.elementAt(n3)).getEmitter() != body) continue;
            this.b.removeElementAt(n3);
        }
        n3 = this.b;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.a[n2].concernsBody(body)) continue;
            this.a[n2] = null;
        }
        this.b = World.a((Object[])this.a, this.b);
    }

    public void removeConstraint(Constraint constraint) {
        int n2 = this.d;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.a[i2] != constraint) continue;
            this.a[i2] = null;
        }
        this.d = World.a(this.a, this.d);
    }

    public void removeScript(Script script) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < this.e; ++n2) {
            if (this.a[n2] != script) continue;
            this.a[n2] = null;
            n3 = n2;
            --this.e;
            for (int i2 = n2; i2 < this.e; ++i2) {
                this.a[i2] = this.a[i2 + 1];
            }
            break;
        }
        for (n2 = 0; n2 < this.f; ++n2) {
            if (this.b[n2] != n3) continue;
            this.b[n2] = -1;
            this.c[n2] = -1;
            this.a[n2] = -1;
            this.b[n2] = null;
            World.a(this.b, this.f);
            World.a(this.c, this.f);
            World.a(this.a, this.f);
            this.f = World.a((Object[])this.b, this.f);
            return;
        }
    }

    public void removeEvent(Event event) {
        this.a.removeEvent(event);
    }

    public void removeParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.b.removeElement(particleEmitter);
        }
    }

    public void removeExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.a.removeElement(externalForce);
        }
    }

    static final int[] a(int[] nArray, int n2) {
        if (nArray.length <= n2) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    static final short[] a(short[] sArray, int n2) {
        if (sArray.length <= n2) {
            short[] sArray2 = new short[sArray.length + 32];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    private static Body[] a(Body[] bodyArray, int n2) {
        if (bodyArray.length <= n2) {
            Body[] bodyArray2 = new Body[bodyArray.length + 32];
            System.arraycopy(bodyArray, 0, bodyArray2, 0, bodyArray.length);
            return bodyArray2;
        }
        return bodyArray;
    }

    static final Contact[] a(Contact[] contactArray, int n2) {
        if (contactArray.length <= n2) {
            Contact[] contactArray2 = new Contact[contactArray.length + 32];
            System.arraycopy(contactArray, 0, contactArray2, 0, contactArray.length);
            return contactArray2;
        }
        return contactArray;
    }

    static final FXVector[] a(FXVector[] fXVectorArray, int n2) {
        if (fXVectorArray.length <= n2) {
            FXVector[] fXVectorArray2 = new FXVector[fXVectorArray.length + 32];
            System.arraycopy(fXVectorArray, 0, fXVectorArray2, 0, fXVectorArray.length);
            return fXVectorArray2;
        }
        return fXVectorArray;
    }

    public Body findBodyById(int n2) {
        if ((n2 = this.bodyIndexOf(n2)) < 0) {
            return null;
        }
        return this.a[n2];
    }

    public Body findBodyAt(int n2, int n3) {
        Body[] bodyArray = this.getBodies();
        FXVector fXVector = new FXVector();
        for (int i2 = 0; i2 < this.getBodyCount(); ++i2) {
            Body body = bodyArray[i2];
            fXVector.assignFX(n2, n3);
            if (n2 < body.getAABBMinXFX() || n2 > body.getAABBMaxXFX() || n3 < body.getAABBMinYFX() || n3 > body.getAABBMaxYFX()) continue;
            FXVector[] fXVectorArray = body.getAxes();
            FXVector[] fXVectorArray2 = body.getVertices();
            boolean bl = true;
            for (int i3 = 0; i3 < fXVectorArray.length; ++i3) {
                long l2;
                long l3 = (long)fXVector.xFX * (long)fXVectorArray[i3].xFX + (long)fXVector.yFX * (long)fXVectorArray[i3].yFX >> 12;
                long l4 = l2 = (long)fXVectorArray2[0].xFX * (long)fXVectorArray[i3].xFX + (long)fXVectorArray2[0].yFX * (long)fXVectorArray[i3].yFX >> 12;
                for (int i4 = 1; i4 < fXVectorArray2.length; ++i4) {
                    long l5 = (long)fXVectorArray2[i4].xFX * (long)fXVectorArray[i3].xFX + (long)fXVectorArray2[i4].yFX * (long)fXVectorArray[i3].yFX >> 12;
                    if (l2 > l5) {
                        l2 = l5;
                    }
                    if (l4 >= l5) continue;
                    l4 = l5;
                }
                if (l2 <= l3 && l4 >= l3) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return body;
        }
        return null;
    }

    public int bodyIndexOf(int n2) {
        for (int i2 = 0; i2 < this.a; ++i2) {
            if (this.a[i2].i != n2) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(Constraint constraint) {
        if (constraint == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.d; ++i2) {
            if (!this.a[i2].equals(constraint)) continue;
            return i2;
        }
        return -1;
    }

    public void addConstraint(Constraint constraint) {
        if (constraint != null) {
            Constraint[] constraintArray;
            int n2 = this.d;
            Constraint[] constraintArray2 = this.a;
            if (this.a.length <= n2) {
                Constraint[] constraintArray3 = new Constraint[constraintArray2.length + 32];
                System.arraycopy(constraintArray2, 0, constraintArray3, 0, constraintArray2.length);
                constraintArray = constraintArray3;
            } else {
                constraintArray = constraintArray2;
            }
            this.a = constraintArray;
            this.a[this.d++] = constraint;
        }
    }

    public void addScript(Script script) {
        if (script != null) {
            Script[] scriptArray;
            int n2 = this.e;
            Script[] scriptArray2 = this.a;
            if (this.a.length <= n2) {
                Script[] scriptArray3 = new Script[scriptArray2.length + 32];
                System.arraycopy(scriptArray2, 0, scriptArray3, 0, scriptArray2.length);
                scriptArray = scriptArray3;
            } else {
                scriptArray = scriptArray2;
            }
            this.a = scriptArray;
            this.a[this.e++] = script;
        }
    }

    public void addEvent(Event event) {
        this.a.registerEvent(event);
    }

    public void setGravity(int n2) {
        this.a = new FXVector(0, n2 << 12);
    }

    public void setGravity(FXVector fXVector) {
        this.a = fXVector;
    }

    public void setDampingLateralFX(int n2) {
        this.h = n2;
    }

    public void setDampingRotationalFX(int n2) {
        this.i = n2;
    }

    public void tick() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Body[] bodyArray = this.a;
        Constraint[] constraintArray = this.a;
        for (n7 = 0; n7 < this.f; ++n7) {
            if (this.b[n7] == null) continue;
            this.a[this.a[n7]].a(n7, this);
        }
        for (n7 = 0; n7 < this.a.size(); ++n7) {
            ((ExternalForce)this.a.elementAt(n7)).applyForce(bodyArray, this.a, this.j);
        }
        for (n7 = this.p; n7 < this.q; ++n7) {
            Body body = bodyArray[n7];
            if (body.a && body.c) {
                body.applyAcceleration(this.a, this.j);
            }
            body.a(this.j);
        }
        World world = this;
        for (n6 = 0; n6 < world.b; ++n6) {
            world.a[n6] = null;
        }
        n6 = world.b = 0;
        world.a.a();
        world.a();
        int n8 = 0;
        int n9 = 0;
        for (n5 = world.p; n5 < world.q; ++n5) {
            n4 = world.a[n5].d;
            world.a.a(world, world.a[n5]);
            for (int i2 = 0; i2 < n9; ++i2) {
                if (world.c[i2] == null) continue;
                if (world.c[i2].e < n4) {
                    --n8;
                    world.c[i2] = null;
                    continue;
                }
                if (world.a[n5].f > world.c[i2].g || world.c[i2].f > world.a[n5].g) continue;
                Body body = world.c[i2];
                Body body2 = world.a[n5];
                World world2 = world;
                if (!body2.a && !body.a || (body2.h & body.h) != 0 || !body2.b || !body.b) continue;
                if (body2.a instanceof MultiShape || body.a instanceof MultiShape) {
                    int n10 = 1;
                    int n11 = 1;
                    if (body2.a instanceof MultiShape) {
                        n10 = ((MultiShape)body2.a).getShapeCount();
                    }
                    if (body.a instanceof MultiShape) {
                        n11 = ((MultiShape)body.a).getShapeCount();
                    }
                    for (int i3 = 0; i3 < n10; ++i3) {
                        for (int i4 = 0; i4 < n11; ++i4) {
                            Contact contact = Collision.detectCollision(body2, i3, body, i4);
                            if (contact == null) continue;
                            world2.a = World.a(world2.a, world2.b);
                            world2.a[world2.b] = contact;
                            ++world2.b;
                        }
                    }
                    continue;
                }
                Contact contact = Collision.detectCollision(body2, body);
                if (contact == null) continue;
                world2.a = World.a(world2.a, world2.b);
                world2.a[world2.b] = contact;
                ++world2.b;
            }
            world.c = World.a(world.c, n9);
            world.c[n9++] = world.a[n5];
            if (n9 <= ++n8 << 1) continue;
            n9 = World.a((Object[])world.c, n9);
        }
        world.a.b();
        for (n5 = world.p; n5 < world.q; ++n5) {
            world.a[n5].a();
        }
        world.a.getBody();
        for (n4 = n6; n4 < world.b; ++n4) {
            Contact contact = world.a[n4];
            world.a[n4].a = false;
            contact.a.a(contact);
            contact.b.a(contact);
        }
        Contact.a(this.a, this.b);
        Contact.a(this.a, this.b, this.a);
        for (int i5 = 0; i5 < this.b.size(); ++i5) {
            ((ParticleEmitter)this.b.elementAt(i5)).applyAcceleration(this.a, this.j);
        }
        World world3 = this;
        for (n3 = 0; n3 < world3.b.size(); ++n3) {
            ParticleEmitter particleEmitter = (ParticleEmitter)world3.b.elementAt(n3);
            if (!particleEmitter.a) continue;
            n9 = 0;
            n5 = 0;
            for (n4 = world3.p; n4 < world3.q; ++n4) {
                while (n9 < particleEmitter.a && (particleEmitter.a[n9] <= 0 || world3.a[n4].d > particleEmitter.a[n9])) {
                    ++n9;
                }
                for (n5 = n9; n5 < particleEmitter.a && (particleEmitter.a[n5] <= 0 || world3.a[n4].e > particleEmitter.a[n5]); ++n5) {
                    FXVector fXVector;
                    if (particleEmitter.a[n5] <= 0 || world3.a[n4].f >= particleEmitter.b[n5] || world3.a[n4].g <= particleEmitter.b[n5] || !world3.a[n4].b || (fXVector = Collision.a(world3.a[n4], particleEmitter.a[n5], particleEmitter.b[n5])) == null) continue;
                    particleEmitter.a(fXVector, n5);
                }
            }
            world3.a.collideParticles(particleEmitter);
        }
        for (n2 = 0; n2 < this.b; ++n2) {
            this.a[n2].a(this.a);
        }
        for (n2 = 0; n2 < this.d; ++n2) {
            constraintArray[n2].precalculate(this.a);
        }
        n2 = 0;
        for (g = 0; !(g >= this.k || n2 != 0 && this.a); ++g) {
            n2 = 1;
            for (n3 = 0; n3 < this.d; ++n3) {
                n2 &= constraintArray[n3].applyMomentum(this.a);
            }
            for (n3 = 0; n3 < this.b; ++n3) {
                n2 &= this.a[n3].a();
            }
        }
        for (n3 = 0; n3 < this.d; ++n3) {
            constraintArray[n3].postStep();
        }
        n3 = 4096 - this.h;
        int n12 = 4096 - this.i;
        for (n8 = this.p; n8 < this.q; ++n8) {
            bodyArray[n8].integrateVelocity(this.j);
            bodyArray[n8].a(n3, n12);
        }
        for (n8 = 0; n8 < this.b; ++n8) {
            this.a[n8].a(this.j, this.a);
        }
        long l2 = 0L;
        long l3 = 0L;
        for (g = 0; g < this.l; ++g) {
            for (n12 = 0; n12 < this.b; ++n12) {
                l3 = this.a[n12].a();
                l2 = l2 < l3 ? l3 : l2;
            }
            if (l2 < 32L) break;
        }
        for (n12 = this.p; n12 < this.q; ++n12) {
            bodyArray[n12].integrateVirtualVelocity(this.j, this.a);
        }
        for (n12 = 0; n12 < this.b.size(); ++n12) {
            ((ParticleEmitter)this.b.elementAt(n12)).integrateParticles(this.j);
        }
        if (this.a != null) {
            this.a.checkEvents(this, this.a);
        }
    }

    private static int a(Object[] objectArray, int n2) {
        int n3 = n2--;
        int n4 = 0;
        while (n4 < n2) {
            while (objectArray[n4] != null && n4 < n2) {
                ++n4;
            }
            while (objectArray[n2] == null && n4 < n2) {
                --n2;
            }
            if (n4 < n2) {
                objectArray[n4] = objectArray[n2];
                objectArray[n2] = null;
            }
            if (objectArray[n2] == null) {
                n3 = n2;
            }
            --n2;
        }
        while (n3 > 0 && objectArray[n3 - 1] == null) {
            --n3;
        }
        return n3;
    }

    static final int a(int[] nArray, int n2) {
        int n3 = n2--;
        int n4 = 0;
        while (n4 < n2) {
            while (nArray[n4] != -1 && n4 < n2) {
                ++n4;
            }
            while (nArray[n2] == -1 && n4 < n2) {
                --n2;
            }
            if (n4 < n2) {
                nArray[n4] = nArray[n2];
                nArray[n2] = -1;
                n3 = n2;
            }
            --n2;
        }
        return n3;
    }

    private final void a() {
        int n2;
        int n3 = 0;
        for (n2 = 1; n2 < this.a; ++n2) {
            Body body = this.a[n2];
            for (n3 = n2 - 1; n3 >= 0 && this.a[n3].d > body.d; --n3) {
                this.a[n3 + 1] = this.a[n3];
            }
            this.a[n3 + 1] = body;
        }
        this.p = -1;
        this.q = this.a;
        for (n2 = 0; n2 < this.a; ++n2) {
            if (this.p < 0 && this.a[n2].e > this.m) {
                this.p = n2;
            }
            if (this.a[n2].d >= this.n) continue;
            this.q = n2 + 1;
        }
        if (this.p < 0) {
            this.p = 0;
        }
    }

    public FXVector getGravity() {
        return this.a;
    }

    public int getDampingLateralFX() {
        return this.h;
    }

    public int getDampingRotationalFX() {
        return this.i;
    }

    public static Constraint loadConstraint(PhysicsFileReader physicsFileReader, Vector vector, UserData userData) {
        switch (physicsFileReader.next()) {
            case 0: {
                return Joint.loadJoint(physicsFileReader, vector, userData);
            }
            case 1: {
                return Spring.loadSpring(physicsFileReader, vector, userData);
            }
            case 3: {
                return Motor.loadMotor(physicsFileReader, vector, userData);
            }
        }
        return null;
    }

    public Vector getEvents() {
        return this.a.getEvents();
    }

    public Vector getParticleEmitters() {
        return this.b;
    }

    public int getBodyCount() {
        return this.a;
    }

    public Body[] getBodies() {
        return this.a;
    }

    public int getBodyStartIndex() {
        return this.p;
    }

    public int getBodyEndIndex() {
        return this.q;
    }

    public int getConstraintCount() {
        return this.d;
    }

    public Constraint[] getConstraints() {
        return this.a;
    }

    public int getContactCount() {
        return this.b;
    }

    public Contact[] getContacts() {
        return this.a;
    }

    public int getScriptCount() {
        return this.e;
    }

    public Script[] getScripts() {
        return this.a;
    }

    public Script getScript(int n2) {
        return this.a[n2];
    }

    public Contact[] getContactsForBody(Body contactArray) {
        Contact[] contactArray2 = new Contact[8];
        int n2 = 0;
        contactArray = contactArray.getContacts();
        for (int i2 = 0; i2 < contactArray.length && contactArray[i2] != null; ++i2) {
            contactArray2[n2++] = contactArray[i2];
        }
        return contactArray2;
    }

    public void translate(FXVector fXVector) {
        int n2 = this.getBodyCount();
        Body[] bodyArray = this.getBodies();
        for (int i2 = 0; i2 < n2; ++i2) {
            bodyArray[i2].positionFX().xFX += fXVector.xFX;
            bodyArray[i2].positionFX().yFX += fXVector.yFX;
            bodyArray[i2].a(0);
        }
    }

    public long getBodyTotalEnergyFX(Body body) {
        long l2 = body.velocityFX().lengthSquareFX() / 2;
        long l3 = (long)(-((int)((long)body.positionFX().yFX * (long)this.a.yFX) >> 12)) + (long)(-((int)((long)body.positionFX().xFX * (long)this.a.xFX) >> 12));
        return l2 + l3;
    }
}

