/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.CCDirector;
import cocos2d.actions.CCAction;
import cocos2d.cocos2d;
import cocos2d.nodes.CCScene;
import cocos2d.nodes.CCSprite;
import cocos2d.nodes.a;
import cocos2d.types.CCPoint;
import cocos2d.types.CCTouch;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CCNode {
    public Vector children = new Vector(1, 5);
    public int _alphaRaw = -16777216;
    private Stack a;
    private boolean a;
    boolean b;
    final CCPoint b = false;
    public int tag = -1;
    public int width;
    public int height;
    public boolean isRelativeParentAnchorPoint = false;
    public boolean isRelativeAnchorPoint = true;
    public int zOrder = -1;
    int a;
    public CCPoint scale;
    public CCPoint position;
    public boolean visible = true;
    public boolean isTouchEnabled = true;
    public CCPoint anchorPoint;
    public CCNode parent = null;
    private Vector a = 0;

    public static final CCNode node() {
        return new CCNode();
    }

    public CCNode() {
        this.b = CCPoint.zero();
        this.scale = CCPoint.ccp(1, 1);
        this.position = CCPoint.zero();
        this.anchorPoint = CCPoint.ccp(50, 50);
        this.a = new Vector(2, 1);
    }

    public static void printNodeStructure(CCNode cCNode) {
        System.out.println("------------------------------------------");
        CCNode.a(cCNode, "-");
        System.out.println("------------------------------------------");
    }

    private static void a(CCNode cCNode, String string) {
        String string2 = string + "-";
        String string3 = string;
        if (cCNode.children.size() > 0) {
            string3 = string3.substring(0, string3.length() - 1) + "o";
            string2 = string2.substring(string.length());
            for (int i2 = 0; i2 < string.length(); ++i2) {
                string2 = "|" + string2;
            }
        }
        try {
            CCSprite cCSprite = (CCSprite)cCNode;
            System.out.println(string3 + " " + cCNode.getClass().getName() + " tag: " + cCNode.tag + " filename: " + cCSprite.spriteFrame.name + " zOrder:" + cCNode.zOrder);
        }
        catch (Exception exception) {
            System.out.println(string3 + " " + cCNode.getClass().getName() + " tag: " + cCNode.tag + " zOrder:" + cCNode.zOrder);
        }
        for (int i3 = 0; i3 < cCNode.children.size(); ++i3) {
            CCNode.a((CCNode)cCNode.children.elementAt(i3), string2);
        }
    }

    public void pauseAllActions(boolean bl) {
        this.b = true;
        int n2 = this.a.size();
        while (n2-- != 0) {
            ((CCAction)this.a.elementAt(n2)).pause();
        }
        if (bl) {
            n2 = this.children.size();
            while (n2-- != 0) {
                ((CCNode)this.children.elementAt(n2)).pauseAllActions(bl);
            }
        }
    }

    public void resumeAllActions(boolean bl) {
        this.b = false;
        int n2 = this.a.size();
        while (n2-- != 0) {
            ((CCAction)this.a.elementAt(n2)).resume();
        }
        if (bl) {
            n2 = this.children.size();
            while (n2-- != 0) {
                ((CCNode)this.children.elementAt(n2)).resumeAllActions(bl);
            }
        }
    }

    public boolean actionsPaused() {
        return this.b;
    }

    public final void addChild(CCNode cCNode) {
        if (cCNode != null && cCNode != this) {
            if (cCNode.parent == null) {
                cCNode.a = false;
                this.a.removeElement(cCNode);
                if (!this.children.contains(cCNode)) {
                    this.children.addElement(cCNode);
                }
                CCNode cCNode2 = cCNode.parent = this;
                while (cCNode2 != null) {
                    if (CCDirector.sharedDirector().runningScene.equals(cCNode2)) {
                        cCNode.onEnter();
                        break;
                    }
                    cCNode2 = cCNode2.parent;
                }
                this.sortChildrenByZOrder();
                return;
            }
            cocos2d.CCLog("addChild: the CCNode already has a parent");
            return;
        }
        if (cCNode == null) {
            cocos2d.CCLog("addChild: the CCNode is null");
            return;
        }
        cocos2d.CCLog("addChild: cannot add a node to itself");
    }

    public final void addChild(CCNode cCNode, int n2) {
        if (cCNode != null) {
            cCNode.zOrder = n2;
            this.addChild(cCNode);
            return;
        }
        cocos2d.CCLog("addChild: the CCNode is null");
    }

    public final void addChild(CCNode cCNode, int n2, int n3) {
        if (cCNode != null) {
            cCNode.tag = n3;
            this.addChild(cCNode, n2);
            return;
        }
        cocos2d.CCLog("addChild: the CCNode is null");
    }

    public final void reorderChild(CCNode cCNode, int n2) {
        if (this.children.contains(cCNode)) {
            cCNode.zOrder = n2;
            this.sortChildrenByZOrder();
            return;
        }
        cocos2d.CCLog("The parameter CCNode is not a child of this CCNode.");
    }

    public final void removeFromParent(boolean bl) {
        if (this.parent != null) {
            this.parent.removeChild(this, bl);
            return;
        }
        if (bl) {
            CCNode cCNode = this;
            cCNode.a.removeAllElements();
        }
    }

    public final void removeChild(CCNode cCNode, boolean bl) {
        if (cCNode != null && cCNode.parent == this && !cCNode.a) {
            cCNode.onExit();
            if (bl) {
                CCNode cCNode2 = cCNode;
                cCNode2.a.removeAllElements();
            }
            this.a.push(cCNode);
            cCNode.parent = null;
            cCNode.a = true;
        }
    }

    public final void removeChildByTag(int n2, boolean bl) {
        this.removeChild(this.getChildByTag(n2), bl);
    }

    public final CCNode getChildByTag(int n2) {
        int n3 = this.children.size();
        while (n3-- != 0) {
            CCNode cCNode = (CCNode)this.children.elementAt(n3);
            if (cCNode.tag != n2) continue;
            return cCNode;
        }
        cocos2d.CCLog("getChildByTag cannot find a child with tag " + n2);
        return null;
    }

    public final void removeAllChildren(boolean bl) {
        int n2 = this.children.size();
        while (n2-- != 0) {
            this.removeChild((CCNode)this.children.elementAt(n2), bl);
            ((CCNode)this.children.elementAt((int)n2)).a = false;
        }
        this.children.removeAllElements();
        this.a.removeAllElements();
    }

    public void setAnchorPoint(CCPoint cCPoint) {
        this.setAnchorPoint(cCPoint.x, cCPoint.y);
    }

    public void setAnchorPoint(int n2, int n3) {
        this.anchorPoint.x = n2;
        this.anchorPoint.y = n3;
    }

    public void setScale(int n2) {
        this.setScale(n2, n2);
    }

    public void setScale(CCPoint cCPoint) {
        this.setScale(cCPoint.x, cCPoint.y);
    }

    public void setScale(int n2, int n3) {
        this.scale.x = n2;
        this.scale.y = n3;
    }

    public void setAlpha(int n2) {
        this._alphaRaw = n2 << 24;
    }

    public int getAlpha() {
        return this._alphaRaw >>> 24;
    }

    public void setPosition(CCPoint cCPoint) {
        this.setPosition(cCPoint.x, cCPoint.y);
    }

    public void setPosition(int n2, int n3) {
        this.position.x = n2;
        this.position.y = n3;
    }

    public void setRotation(int n2) {
        this.a = n2;
    }

    public int getRotation() {
        return this.a;
    }

    public final int numberOfRunningActions() {
        return this.a.size();
    }

    public final void runAction(CCAction cCAction) {
        cCAction.isFinished = false;
        if (this.b) {
            cCAction.pause();
        }
        this.a.addElement(cCAction);
    }

    public final void stopAllActions() {
        this.a.removeAllElements();
    }

    public final void stopActionByTag(int n2) {
        int n3 = this.a.size();
        while (n3-- != 0) {
            if (((CCAction)this.a.elementAt((int)n3)).tag != n2) continue;
            this.a.removeElementAt(n3);
            break;
        }
    }

    public final CCAction getActionByTag(int n2) {
        int n3 = this.a.size();
        while (n3-- != 0) {
            if (((CCAction)this.a.elementAt((int)n3)).tag != n2) continue;
            return (CCAction)this.a.elementAt(n3);
        }
        return null;
    }

    public void draw(Graphics graphics) {
    }

    public void visit(Graphics graphics, long l2, boolean bl, boolean bl2) {
        int n2;
        int n3;
        if (!this.b) {
            for (n3 = 0; n3 < this.a.size(); n3 += 1) {
                CCAction cCAction = null;
                try {
                    cCAction = (CCAction)this.a.elementAt(n3);
                    if (cCAction.isPaused) continue;
                    cCAction.update(this, l2);
                    if (!cCAction.isFinished) continue;
                    this.a.removeElement(cCAction);
                    continue;
                }
                catch (Exception exception) {
                    if (cCAction != null) {
                        cocos2d.CCLog("CCNode: Action update failed " + cCAction.toString() + "(" + exception.toString() + ")");
                    }
                    this.a.removeElement(cCAction);
                    continue;
                }
                catch (Error error) {
                    if (cCAction != null) {
                        cocos2d.CCLog("CCNode: Action update failed " + cCAction.toString() + "(" + error.toString() + ")");
                        this.a.removeElement(cCAction);
                    }
                    System.gc();
                }
            }
        }
        if ((n3 = this.visible && this._alphaRaw != 0 && bl && !this.a ? 1 : 0) && bl2) {
            try {
                this.draw(graphics);
            }
            catch (Exception exception) {
                cocos2d.CCLog("CCNode: Draw self (" + this.toString() + ") failed: " + exception.toString());
            }
        }
        if ((n2 = this.children.size()) > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                CCNode cCNode = null;
                try {
                    cCNode = (CCNode)this.children.elementAt(i2);
                    cCNode.visit(graphics, l2, n3 != 0, true);
                    continue;
                }
                catch (Exception exception) {
                    if (cCNode == null) break;
                    cocos2d.CCLog("CCNode: Drawing child(" + cCNode.toString() + ") failed: " + exception.toString());
                    break;
                }
            }
            while (!this.a.empty()) {
                Object e2 = this.a.pop();
                this.children.removeElement(e2);
                ((CCNode)e2).a = false;
            }
        }
    }

    public void getScreenPosition(CCPoint cCPoint) {
        if (this.isRelativeParentAnchorPoint) {
            this.getScreenPositionWithAP(cCPoint);
            return;
        }
        cCPoint.x = this.position.x;
        cCPoint.y = this.position.y;
        CCNode cCNode = this;
        CCScene cCScene = CCDirector.sharedDirector().runningScene;
        while (cCNode.parent != null && cCNode.parent != cCScene) {
            cCPoint.x += cCNode.parent.position.x;
            cCPoint.y += cCNode.parent.position.y;
            cCNode = cCNode.parent;
        }
    }

    static final void a(CCPoint cCPoint) {
        if ((cocos2d.settings & 0x20L) != 0L) {
            ++cCPoint.y;
        }
    }

    public void getScreenPositionWithAP(CCPoint cCPoint) {
        cCPoint.x = this.position.x;
        cCPoint.y = this.position.y;
        CCNode cCNode = this;
        CCScene cCScene = CCDirector.sharedDirector().runningScene;
        while (cCNode.parent != null && cCNode.parent != cCScene) {
            cCPoint.x += cCNode.parent.position.x;
            cCPoint.y += cCNode.parent.position.y;
            if (cCNode.parent.anchorPoint.x != 0 || cCNode.parent.anchorPoint.y != 0) {
                if (cCNode.parent.width > 0) {
                    cCPoint.x = cCPoint.x - (cCNode.parent.anchorPoint.x == 0 ? 0 : cCNode.parent.width / (100 / cCNode.parent.anchorPoint.x));
                }
                if (cCNode.parent.height > 0) {
                    cCPoint.y = cCPoint.y - (cCNode.parent.anchorPoint.y == 0 ? 0 : cCNode.parent.height / (100 / cCNode.parent.anchorPoint.y));
                }
            }
            cCNode = cCNode.parent;
        }
    }

    public boolean ccTouchBegan(CCTouch cCTouch) {
        return false;
    }

    public void ccTouchMoved(CCTouch cCTouch) {
    }

    public void ccTouchEnded(CCTouch cCTouch) {
    }

    public boolean ccKeyDown(int n2) {
        return false;
    }

    public boolean ccKeyUp(int n2) {
        return false;
    }

    public void onEnter() {
        Object[] objectArray = new CCNode[this.children.size()];
        this.children.copyInto(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((CCNode)objectArray[i2]).onEnter();
        }
    }

    public void onExit() {
        Object[] objectArray = new CCNode[this.children.size()];
        this.children.copyInto(objectArray);
        int n2 = objectArray.length;
        while (n2-- != 0) {
            ((CCNode)objectArray[n2]).onExit();
        }
    }

    public void itemClicked(CCNode cCNode) {
    }

    public final void sortChildrenByZOrder() {
        Object object;
        Object[] objectArray = this.children;
        if (this.children.size() < 2) {
            object = objectArray;
        } else {
            Object object2 = new CCNode[objectArray.size()];
            objectArray.copyInto((Object[])object2);
            objectArray = object2;
            object2 = new CCNode[((Object[])object2).length];
            System.arraycopy(objectArray, 0, object2, 0, ((Object[])object2).length);
            CCNode.a((CCNode[])object2, (CCNode[])objectArray, 0, objectArray.length, 0);
            object = object2 = new a(0, (CCNode[])objectArray);
        }
        this.children = object;
    }

    private static final void a(CCNode[] cCNodeArray, CCNode[] cCNodeArray2, int n2, int n3, int n4) {
        int n5 = n3 - n2;
        if (n5 < 10) {
            for (int i2 = n2; i2 < n3; ++i2) {
                for (int i3 = i2; i3 > n2 && cCNodeArray2[i3 - 1].zOrder - cCNodeArray2[i3].zOrder > 0; --i3) {
                    CCNode cCNode = cCNodeArray2[i3];
                    cCNodeArray2[i3] = cCNodeArray2[i3 - 1];
                    cCNodeArray2[i3 - 1] = cCNode;
                }
            }
            return;
        }
        int n6 = n2;
        int n7 = n3;
        int n8 = (n2 += n4) + (n3 += n4) >>> 1;
        CCNode.a(cCNodeArray2, cCNodeArray, n2, n8, -n4);
        CCNode.a(cCNodeArray2, cCNodeArray, n8, n3, -n4);
        if (cCNodeArray[n8 - 1].zOrder - cCNodeArray[n8].zOrder <= 0) {
            System.arraycopy(cCNodeArray, n2, cCNodeArray2, n6, n5);
            return;
        }
        n5 = n8;
        for (n4 = n6; n4 < n7; ++n4) {
            cCNodeArray2[n4] = n5 >= n3 || n2 < n8 && cCNodeArray[n2].zOrder - cCNodeArray[n5].zOrder <= 0 ? cCNodeArray[n2++] : cCNodeArray[n5++];
        }
    }
}

