/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.game.objects;

import in.spicelabs.doodleCopter.common.Config;
import in.spicelabs.game.objects.AnimationSprite;
import in.spicelabs.game.objects.Controller;
import in.spicelabs.game.objects.FallableSprite;
import in.spicelabs.game.objects.World;
import in.spicelabs.game.objects.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Copter
extends FallableSprite {
    public static final int SHIELD_BERAK_LIMIT = 10;
    public static final int FULL_LIFE = 50;
    public static final int ANIM_DIE_ID = 200;
    private static final int SPEED = -Controller.DIS_H / 40;
    protected boolean isJumping;
    protected boolean isAlive;
    protected int life;
    protected boolean canAttack;
    int frequency;
    Image[][] frames;
    private boolean hasBlown;
    private boolean isShielded;
    private boolean canConsume;
    private boolean isFlying;
    private int coin;
    private int missiles;
    private int smokeDis;
    private int shieldFrame;

    public Copter(int x, int y, Image[][] frames, World world) {
        super(new XYRect(x, y, frames[0][0].getWidth(), frames[0][0].getHeight()), world);
        this.frames = frames;
        this.mass = 2;
        this.isAlive = true;
        this.life = 50;
    }

    private Image[] getCurrentStateFrames() {
        Image[] frm = this.isInState(2) ? this.frames[1] : (this.isInState(8) ? this.frames[3] : (this.isInState(4) ? this.frames[1] : this.frames[1]));
        this.updateRect(frm[0]);
        return frm;
    }

    protected void draw(Graphics g) {
        Image[] frms = this.getCurrentStateFrames();
        this.updateRect(frms[this.frameCount]);
        g.drawImage(frms[this.frameCount], this.rect.x, this.rect.y, 0);
        if (this.isShielded) {
            g.drawImage(Config.SHIELD[this.shieldFrame], this.rect.x + (this.rect.width - Config.SHIELD[this.shieldFrame].getWidth() >> 1), this.rect.y + (this.rect.height - Config.SHIELD[this.shieldFrame].getHeight() >> 1), 0);
            ++this.shieldFrame;
            this.shieldFrame %= Config.SHIELD_FRAME.length;
        }
        super.draw(g);
    }

    protected void tick() {
        Image[] frms = this.getCurrentStateFrames();
        if (this.getState() != 8 || this.getState() == 8 && this.frameCount != frms.length - 1) {
            ++this.frameCount;
            this.frameCount %= frms.length;
        }
        this.ejectSmoke();
        if (this.isInState(8)) {
            return;
        }
        this.rect.y += this.velocityY;
        if (this.isFlying) {
            this.velocityY -= this.mass * 1;
            if (this.velocityY < SPEED) {
                this.velocityY = SPEED;
            }
        } else if (this.velocityY + this.mass * 1 <= -(SPEED + (SPEED >> 2))) {
            this.velocityY += this.mass * 1;
        }
    }

    private void ejectSmoke() {
        if (this.smokeDis >= Config.SMOKE[0].getWidth()) {
            this.smokeDis = 0;
            AnimationSprite animSmoke = new AnimationSprite(Config.SMOKE, this.rect.x - 2 * Config.SMOKE[0].getWidth() / 3, this.rect.y + (this.rect.height - Config.SMOKE[0].getHeight() >> 1), 0, null, 0);
            this.world.addAnimation(animSmoke);
        } else {
            this.smokeDis += this.world.getSpeed();
        }
    }

    public boolean hasBlown() {
        return this.hasBlown;
    }

    public void setHasBlown(boolean hasBlown) {
        this.hasBlown = hasBlown;
    }

    public void Explode() {
        if (this.isInState(8)) {
            return;
        }
        this.velocityY = 0;
        this.addAnimation(new AnimationSprite(Config.EXPLOSION, this.rect.width - Config.EXPLOSION[0].getWidth() >> 1, this.rect.height - Config.EXPLOSION[0].getHeight() >> 1, 0, this, 200));
        this.world.setShouldStop(true);
        this.addState(8);
    }

    public void resume() {
        this.setState(1);
        this.rect.y = Config.SCREEN_HEIGHT - Config.COPTER_FRAMES[0][0].getHeight() >> 1;
        this.isAlive = true;
        this.setShielded(true);
    }

    public int getCoins() {
        return this.coin;
    }

    public void setCoins(int coins) {
        this.coin = coins;
    }

    public void incrementCoin() {
        ++this.coin;
    }

    public int getMissiles() {
        return this.missiles;
    }

    public void incrementMissiles() {
        ++this.missiles;
    }

    public boolean canConsume() {
        return this.canConsume;
    }

    public void setCanConsume(boolean canConsume) {
        this.canConsume = canConsume;
    }

    public boolean hasFallen() {
        return this.rect.y + this.rect.height >= Controller.DIS_H;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public void setFlying(boolean isFlying) {
        this.isFlying = isFlying;
    }

    protected int getAcceleration() {
        return 1 * this.mass;
    }

    public boolean attack(int direction) {
        if (this.isAlive && this.missiles > 0) {
            --this.missiles;
            this.world.attack(this.rect.x + this.rect.width - (Config.ROCKET[0].getWidth() >> 1), this.rect.y + (this.rect.height - Config.ROCKET[0].getHeight() >> 1), 2, 0, this);
            return true;
        }
        return false;
    }

    public void setShielded(boolean isShielded) {
        this.isShielded = isShielded;
    }

    public boolean isShielded() {
        return this.isShielded;
    }

    public void onAnimationComplete(AnimationSprite sprite) {
        super.onAnimationComplete(sprite);
        if (sprite.getId() == 200) {
            this.world.notifyGameOver();
        }
    }

    public XYRect getCollisionRect() {
        int dx = this.rect.width / 10;
        int dy = this.rect.height / 5;
        return new XYRect(this.rect.x + dx, this.rect.y + dy, this.rect.width - 2 * dx, this.rect.height - dy);
    }
}

