/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.game.objects;

import in.spicelabs.game.objects.ConsumableObstacle;
import in.spicelabs.game.objects.FallableSprite;
import in.spicelabs.game.objects.Obstacles;
import in.spicelabs.game.objects.Sprite;
import in.spicelabs.game.objects.World;
import in.spicelabs.game.objects.XYRect;
import java.util.Enumeration;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Platform
extends Sprite {
    private int dx;
    private Image bmp;

    public Platform(XYRect rect, boolean isWithObstacles, Image bmp, World world) {
        super(rect, world);
        this.bmp = bmp;
        rect.height = bmp.getHeight();
        if (isWithObstacles) {
            this.initObstacles();
        }
    }

    private void initObstacles() {
    }

    protected void draw(Graphics g) {
        g.drawImage(this.bmp, this.rect.x, this.rect.y, 0);
    }

    protected void tick() {
        this.dx += this.world.getSpeed();
        this.dx %= this.bmp.getWidth();
    }

    public int getSurfaceForSprite(FallableSprite fallableSprite) {
        Enumeration e = this.world.obstacles.elements();
        while (e.hasMoreElements()) {
            Obstacles ob = (Obstacles)e.nextElement();
            XYRect collRect = ob.getCollisionRect();
            if (ob instanceof ConsumableObstacle || fallableSprite.equals(ob) || ob.isDestroyed() || fallableSprite.rect.x < collRect.x || fallableSprite.rect.x > collRect.x + (collRect.width >> 1)) continue;
            return collRect.y;
        }
        return super.getSurfaceForSprite(fallableSprite);
    }
}

