/*
 * Decompiled with CFR 0.152.
 */
package com.spicelabs.eggtoss.screens;

import com.spicelabs.eggtoss.screens.Config;
import com.spicelabs.eggtoss.screens.Egg;
import com.spicelabs.eggtoss.screens.GameListener;
import com.spicelabs.eggtoss.screens.LevelGenerator;
import com.spicelabs.eggtoss.screens.LevelGeneratorListener;
import com.spicelabs.eggtoss.screens.Sprite;
import com.spicelabs.eggtoss.screens.World;
import com.spicelabs.eggtoss.screens.WorldListener;
import com.spicelabs.eggtoss.screens.XYRect;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Controller
implements WorldListener,
LevelGeneratorListener {
    public static final int DIS_W = Config.DISPLAY_WIDTH;
    public static final int DIS_H = Config.DISPLAY_HEIGHT;
    private static final int BEGIN_CYCLE_RATE = 45;
    private static Controller controller;
    private World world;
    private boolean isGameOver;
    private int cycleRate = 45;
    private int score;
    private int duration;
    private boolean isPaused;
    private int gameOverType;
    private GameListener gameListener;
    private StringBuffer strHighScore = new StringBuffer();
    private Egg egg;
    private boolean isFirstToss;
    int i = 0;
    int[] array;

    private Controller() {
    }

    public void draw(Graphics g) {
        if (this.isPaused) {
            return;
        }
        g.fillRect(0, 0, DIS_W, DIS_H);
        g.drawImage(Config.backgroundImage, 0, 0, 0);
        this.duration += this.cycleRate;
        g.setFont(Font.getFont((int)0, (int)1, (int)8));
        this.world.tick();
        this.world.draw(g);
        int fh = g.getFont().getHeight();
        int gap = fh / 3;
        int boardW = DIS_W - DIS_H - gap;
        int y = gap + 50;
        int boardH = DIS_H - y - gap;
        g.fillRoundRect(DIS_H, y, DIS_W - DIS_H - gap, boardH, 1, 1);
        g.setColor(0xFFFFFF);
        int boardY = gap;
        g.drawString("Best: ", DIS_H + (boardW - g.getFont().stringWidth("Best: ") >> 1), y + boardY, 0);
        g.drawString(this.strHighScore.toString(), DIS_H + (boardW - g.getFont().stringWidth(this.strHighScore.toString()) >> 1), y + (boardY += fh), 0);
        g.drawString("Score: ", DIS_H + (boardW - g.getFont().stringWidth("Score: ") >> 1), y + (boardY += fh), 0);
        String s = "" + this.score;
        g.drawString(s, DIS_H + (boardW - g.getFont().stringWidth(s) >> 1), y + (boardY += fh), 0);
        int gapV = gap;
        int temp = (boardH - (boardY += fh) - 2 * gapV) / 6;
        int r = temp >> 1;
        temp = (int)((double)temp * 0.1);
        int x = DIS_H + r;
        g.setColor(0x808080);
        g.fillRoundRect(x, y + (boardY += gapV), boardW - 2 * r, boardH - boardY - gapV, 1, 1);
        g.setColor(0xFFFFFF);
        int gapH = (boardW - 6 * r) / 3;
        x += gapH + r + (2 * r + gapH);
        boardY -= r;
        int j = 0;
        while (j < 12) {
            if (j % 2 == 0) {
                x -= 2 * r + gapH;
                boardY += 2 * r;
            } else {
                x += 2 * r + gapH;
            }
            g.setColor(j < this.egg.getLife() ? 0xFFFFFF : 0);
            g.fillArc(x, y + boardY, (int)((double)(x + r - temp - x) * 1.5), (int)((double)(y + boardY + r - temp - (y + boardY)) * 1.5), 0, 360);
            ++j;
        }
        if (this.isFirstToss) {
            g.drawImage(Config.blankImage, 0, 0, 0);
            g.setColor(0xFFFFFF);
            Vector hintVec = this.wrap("How to toss egg:TAP on screen", (int)((double)DIS_W * 0.8), g);
            x = (int)((double)DIS_W * 0.1);
            y = DIS_H - 2 * g.getFont().getHeight() >> 1;
            int i = 0;
            while (i < hintVec.size()) {
                String str = (String)hintVec.elementAt(i);
                g.drawString(str, (DIS_W - g.getFont().stringWidth(str) - boardW) / 2, y, 0);
                y += g.getFont().getHeight();
                ++i;
            }
        }
    }

    private Vector wrap(String text, int width, Graphics g) {
        Vector<String> result = new Vector<String>();
        if (text == null) {
            return result;
        }
        boolean hasMore = true;
        int current = 0;
        int lineBreak = -1;
        int nextSpace = -1;
        while (hasMore) {
            int linewidth;
            do {
                if ((lineBreak = nextSpace) == text.length() - 1) {
                    hasMore = false;
                    break;
                }
                nextSpace = text.indexOf(32, lineBreak + 1);
                if (nextSpace != -1) continue;
                nextSpace = text.length() - 1;
            } while ((linewidth = g.getFont().substringWidth(text, current, nextSpace - current)) <= width);
            String line = text.substring(current, lineBreak + 1);
            result.addElement(line);
            current = lineBreak + 1;
        }
        return result;
    }

    public static Controller getController() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    public void setGameListener(GameListener gameListener) {
        this.gameListener = gameListener;
    }

    public static int getWorldSpeed() {
        return Controller.controller.world.getSpeed();
    }

    public static int getDurationInSeconds() {
        return Controller.controller.duration / 1000;
    }

    public void startNewGame() {
        this.isFirstToss = true;
        this.isGameOver = false;
        this.isPaused = false;
        this.score = 0;
        this.duration = 0;
        this.cycleRate = 45;
        LevelGenerator.getInstance().setListener(this);
        LevelGenerator.reset();
        this.world = new World(new XYRect(0, 0, DIS_H, DIS_H));
        this.world.addListener(this);
        this.egg = new Egg(0, 0, this.world);
        this.world.initEnvironment(this.egg);
    }

    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public int getScore() {
        return this.score;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isGameOver() {
        return this.isGameOver;
    }

    public void gameOver(int type) {
        this.isGameOver = true;
        if (this.gameListener != null) {
            switch (type) {
                case 0: {
                    this.gameListener.onGameOver();
                }
            }
        }
        this.gameOverType = type;
    }

    public static boolean isOutOfWorld(Sprite sprite) {
        return !Controller.controller.world.intersectWith(sprite.rect);
    }

    public static int getCycleRate() {
        return Controller.controller.cycleRate;
    }

    public static void setCycleRate(int cycleRate) {
        Controller.controller.cycleRate = cycleRate;
    }

    public boolean throwEgg() {
        if (this.isFirstToss) {
            this.isFirstToss = false;
            return false;
        }
        return this.world.throwEgg();
    }

    public void setHighscore(long highscore) {
        this.strHighScore = new StringBuffer();
        this.strHighScore.append(highscore);
    }

    public int getGameOverType() {
        return this.gameOverType;
    }

    public void onLevelUp() {
        this.score += 10;
    }
}

