/*
 * Decompiled with CFR 0.152.
 */
package com.spicelabs.eggtoss.screens;

import com.spicelabs.eggtoss.screens.AnimatableSprite;
import com.spicelabs.eggtoss.screens.Controller;
import com.spicelabs.eggtoss.screens.Sprite;
import com.spicelabs.eggtoss.screens.World;
import com.spicelabs.eggtoss.screens.XYRect;
import javax.microedition.lcdui.Graphics;

public abstract class FallableSprite
extends AnimatableSprite {
    public static final int STATE_NORMAL = 1;
    public static final int STATE_JUMP = 2;
    public static final int STATE_FALL = 4;
    public static final int G = 2;
    protected int velocityY;
    protected int mass = 1;
    protected int state = 1;
    protected Sprite base;
    int previousState;

    public FallableSprite(XYRect rect, World world) {
        super(rect, world);
    }

    protected void draw(Graphics g) {
        super.draw(g);
    }

    protected void tick() {
        if (this.isInState(4)) {
            int lb = this.getLowerBound();
            this.rect.y += this.velocityY;
            this.velocityY += this.mass * 2;
            if (this.rect.y + this.rect.height >= lb) {
                this.rect.y = lb - this.rect.height;
                this.velocityY = 0;
            }
        } else if (this.isInState(2)) {
            this.rect.y -= this.velocityY;
            this.velocityY -= this.mass * 2;
            if (this.velocityY <= 0) {
                this.setState(4);
            }
        }
    }

    public boolean isOnTheBase() {
        int lb = this.getLowerBound();
        return this.rect.y + this.rect.height >= lb;
    }

    public void setBase(Sprite base) {
        this.base = base;
    }

    protected int getLowerBound() {
        return Controller.DIS_H + this.rect.height;
    }

    public boolean isInState(int state) {
        return (this.state & state) == state;
    }

    public boolean isOutOfTheWorld() {
        return !this.intersectWith(this.world.rect);
    }

    public void setState(int state) {
        this.previousState = this.state;
        this.state |= state;
        switch (state) {
            case 4: {
                this.state &= 0xFFFFFFFD;
                break;
            }
            case 2: {
                this.state &= 0xFFFFFFFE;
                break;
            }
            case 1: {
                this.state &= 0xFFFFFFFB;
            }
        }
    }
}

