/*
 * Decompiled with CFR 0.152.
 */
package com.spicelabs.eggtoss.screens;

import com.spicelabs.eggtoss.screens.Config;
import com.spicelabs.eggtoss.screens.Egg;
import com.spicelabs.eggtoss.screens.FallableSprite;
import com.spicelabs.eggtoss.screens.LevelGenerator;
import com.spicelabs.eggtoss.screens.Line2D;
import com.spicelabs.eggtoss.screens.World;
import com.spicelabs.eggtoss.screens.XYRect;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Nest
extends FallableSprite {
    private static int flickSize;
    private Line2D path;
    private int speedX;
    private Egg egg;
    private Nest bucketAbove;
    private boolean isFirst;
    private boolean isFlicked;
    private boolean isPassed;

    public Nest(Line2D line, int speedX, boolean isFirst, World world) {
        super(new XYRect((int)line.getX1(), (int)line.getY1(), Config.NEST[0].getWidth(), Config.NEST[0].getHeight()), world);
        this.speedX = speedX;
        this.path = line;
        this.isFirst = isFirst;
        flickSize = this.rect.height / 8;
    }

    protected void draw(Graphics g) {
        g.drawImage(Config.NEST[0], this.rect.x, this.rect.y, 0);
        if (this.isFirst) {
            g.drawImage(Config.START_LABEL, this.rect.x, this.rect.y - Config.START_LABEL.getHeight(), 0);
        }
        if (this.egg != null && this.egg.isCaught()) {
            this.egg.tick();
            this.egg.draw(g);
        }
        g.drawImage(Config.NEST[1], this.rect.x, this.rect.y, 0);
        if (this.egg != null && !this.egg.isCaught()) {
            this.egg.tick();
            this.egg.draw(g);
        }
        super.draw(g);
    }

    protected void tick() {
        if (this.isOutOfTheWorld()) {
            this.notifyRemoval();
        }
        this.rect.x += this.speedX;
        this.rect.y = (int)this.path.getYCoordWithXCoord(this.rect.x);
        if (this.isFlicked) {
            this.rect.y += flickSize;
            if ((flickSize = -flickSize) > 0) {
                this.isFlicked = false;
            }
        }
        if (this.hasGotHitWithWalls()) {
            this.speedX = -this.speedX;
        }
        if (this.egg != null && this.egg.isFalling()) {
            if (this.egg.isOutOfTheWorld()) {
                if (this.egg.getLife() > 0) {
                    this.egg.decrementLife();
                    this.egg.rect.x = this.rect.width - this.egg.rect.width >> 1;
                    this.egg.rect.y = -this.egg.rect.height;
                    this.egg.setCanBeCatch(false);
                    this.egg.setBase(this);
                    this.egg.setParent(this);
                } else {
                    this.world.notifyGameOver(0);
                }
                this.world.setState(1);
            }
            if (this.egg.isCanBeCatch()) {
                if (this.bucketAbove == null) {
                    Vector queue = this.world.getNestQueue();
                    int index = queue.indexOf(this);
                    if (index != -1 && index + 1 < queue.size()) {
                        this.bucketAbove = (Nest)queue.elementAt(index + 1);
                    }
                } else {
                    XYRect rect = new XYRect(this.bucketAbove.rect);
                    rect.overlap(this.egg.rect);
                    if (this.egg.rect.y < rect.y && rect.width >= 3 * (this.egg.rect.width / 4) && rect.height > 0 && rect.height < this.egg.rect.height >> 1) {
                        this.bucketAbove.setEgg(this.egg);
                        this.egg.setCaughtBy(this.bucketAbove);
                        this.setEgg(null);
                        LevelGenerator.increamentLevel();
                    }
                }
            } else {
                XYRect rect = new XYRect(this.rect);
                rect.overlap(this.egg.getAbsoluteRect());
                if (rect.width >= 3 * (this.egg.rect.width / 4) && rect.height > this.egg.rect.height >> 2) {
                    this.setEgg(this.egg);
                    this.egg.setCaughtBy(this);
                }
            }
        }
        super.tick();
    }

    public Line2D getPath() {
        return this.path;
    }

    public void setEgg(Egg egg) {
        if (egg != null) {
            this.isPassed = true;
            this.egg = egg;
            egg.setParent(this);
            egg.setBase(this);
            egg.rect.x = this.rect.width - egg.rect.width >> 1;
            egg.rect.y = -(egg.rect.height >> 1);
        } else {
            this.egg = null;
        }
    }

    public Egg getEgg() {
        return this.egg;
    }

    public boolean isPassed() {
        return this.isPassed;
    }

    public void throwEgg() {
        if (this.egg != null && this.egg.isCaught()) {
            this.isFlicked = true;
            this.egg.throughTillHeight(World.DEF_ONE_THIRD + (this.egg.rect.height >> 1));
            this.egg.rect.x = this.egg.getAbsoluteX();
            this.egg.rect.y = this.egg.getAbsoluteY();
            this.egg.setParent(null);
            this.egg.setBase(null);
        }
    }

    private void notifyRemoval() {
        if (this.isPassed) {
            this.world.removeNest(this);
        }
    }

    public boolean hasGotHitWithWalls() {
        return this.rect.x + this.rect.width >= this.world.rightBoundary || this.rect.x <= this.world.leftBoundary;
    }

    public boolean hasEgg() {
        return this.egg != null;
    }
}

