/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.linerunner.objects;

import in.spicelabs.linerunner.common.Config;
import in.spicelabs.linerunner.objects.Obstacles;
import in.spicelabs.linerunner.objects.World;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Block
extends Obstacles {
    private final int count;
    private final int g2;
    private int graveFrameCount;

    public Block(int x, int y, int count, int g, Image[] frames, World world) {
        super(x, y, frames, world);
        this.rect.width = frames[0].getWidth() + (count - 1) * (frames[0].getWidth() + g);
        this.count = count;
        this.g2 = g;
        this.canFall = false;
    }

    protected void draw(Graphics g) {
        int x = this.rect.x;
        int i = 0;
        while (i < this.count) {
            g.drawImage(this.frames[this.frameCount], x, this.rect.y, 0);
            x += this.frames[this.frameCount].getWidth() + this.g2;
            ++i;
        }
        if (this.isDestroyed()) {
            if (this.graveFrameCount < Config.GRAVE.length - 1) {
                ++this.graveFrameCount;
            }
            Image frm = Config.GRAVE[this.graveFrameCount];
            g.drawImage(frm, this.rect.x + (this.rect.width - frm.getWidth() >> 1), this.base.rect.y - frm.getHeight(), 0);
        }
    }

    protected void tick() {
        super.tick();
        if (this.rect.x < -this.rect.width) {
            this.world.removeSprite(this);
        }
    }
}

