/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.linerunner.objects;

import in.spicelabs.linerunner.common.Config;
import in.spicelabs.linerunner.objects.Controller;
import in.spicelabs.linerunner.objects.FallableSprite;
import in.spicelabs.linerunner.objects.Sprite;
import in.spicelabs.linerunner.objects.World;
import in.spicelabs.linerunner.objects.XYRect;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Building
extends Sprite {
    private static final int SPIKE_OR_FIREBALL_COUNTER_MIN = 1;
    private static final int SPIKE_OR_FIREBALL_COUNTER_MAX = 5;
    private static Random random = new Random();
    static int spikeOrFireballCounter = 1 + random.nextInt(4);

    public Building(XYRect rect, World world) {
        super(rect, world);
    }

    public static void init() {
        spikeOrFireballCounter = 1 + random.nextInt(4);
    }

    private boolean canAddSpikesOrFireball() {
        if (spikeOrFireballCounter == 0) {
            spikeOrFireballCounter = 1 + random.nextInt(4);
            return true;
        }
        --spikeOrFireballCounter;
        return false;
    }

    protected void draw(Graphics g) {
        int i = 0;
        while (i <= Config.SCREEN_WIDTH / Config.BLOCK.getWidth()) {
            g.drawRegion(Config.BLOCK, 0, 0, Config.BLOCK.getWidth(), Config.BLOCK.getHeight(), 0, this.rect.x + Config.BLOCK.getWidth() * i, this.rect.y, 0);
            ++i;
        }
    }

    protected void tick() {
        this.moveWithSpeed(Controller.getWorldSpeed());
    }

    private void moveWithSpeed(float f) {
        this.rect.x = (int)((float)this.rect.x - f);
    }

    public boolean hasSpikesOrFireball() {
        return false;
    }

    public int getSurfaceForSprite(FallableSprite sprite) {
        return super.getSurfaceForSprite(sprite);
    }
}

