/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.linerunner.objects;

import in.spicelabs.linerunner.common.Config;
import in.spicelabs.linerunner.objects.AttackDirections;
import in.spicelabs.linerunner.objects.AttackListener;
import in.spicelabs.linerunner.objects.Block;
import in.spicelabs.linerunner.objects.Building;
import in.spicelabs.linerunner.objects.Controller;
import in.spicelabs.linerunner.objects.Obstacles;
import in.spicelabs.linerunner.objects.RemoveSpriteListener;
import in.spicelabs.linerunner.objects.Runner;
import in.spicelabs.linerunner.objects.Sprite;
import in.spicelabs.linerunner.objects.WorldListener;
import in.spicelabs.linerunner.objects.XYRect;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class World
extends Sprite
implements AttackListener,
AttackDirections,
RemoveSpriteListener {
    public static final int AIR_BLOCK_H = 3 * Config.BLOCK.getHeight();
    private static final int HIT_JUMP = (int)((double)Controller.DIS_H * 0.07);
    private static int MIN_GAP;
    private static int MAX_GAP;
    private Random random = new Random();
    private Vector sprites;
    private WorldListener listener;
    private Runner runner;
    private float speed = Controller.DIS_W / 30;
    private int distance;
    private int lifeCounter = 300;
    private int shieldCounter = 300;
    private Building floor;
    private Vector obstacles;

    public World(XYRect rect) {
        super(rect, null);
        this.sprites = new Vector();
        this.obstacles = new Vector();
    }

    public void initEnvironment() {
        int temp = this.getMinDistance();
        MIN_GAP = temp + (temp >> 1);
        MAX_GAP = temp << 1;
        this.floor = new Building(new XYRect(0, this.rect.height - (this.rect.height >> 2), this.rect.width, Config.BLOCK.getHeight()), this);
        this.runner.rect.y = this.floor.rect.y - this.runner.rect.height;
        this.runner.setBase(this.floor);
        Block obs = new Block(2 * Controller.DIS_W, this.floor.rect.y - Config.BLOCK.getHeight(), 1, 0, new Image[]{Config.BLOCK}, this);
        obs.setBase(this.floor);
        this.obstacles.addElement(obs);
    }

    protected void draw(Graphics g) {
        g.drawImage(Config.BUILDINGS, -this.distance, this.rect.height - Config.BUILDINGS.getHeight(), 0);
        g.drawImage(Config.BUILDINGS, Config.SCREEN_WIDTH - this.distance, this.rect.height - Config.BUILDINGS.getHeight(), 0);
        this.floor.draw(g);
        this.floor.draw(g);
        int j = 0;
        while (j < this.sprites.size()) {
            ((Sprite)this.sprites.elementAt(j)).draw(g);
            ++j;
        }
        Enumeration en = this.obstacles.elements();
        while (en.hasMoreElements()) {
            Obstacles type = (Obstacles)en.nextElement();
            type.tick();
            type.draw(g);
        }
    }

    private int getMinDistance() {
        double vi = Controller.MIN_JUMP_FORCE;
        boolean vf = false;
        double time = ((double)vf - vi) / (double)(-this.runner.getAcceleration());
        return (int)((double)(2.0f * this.speed) * time);
    }

    protected void tick() {
        if ((this.runner.hasFallen() || !this.runner.isAlive) && this.listener != null) {
            this.listener.gameOver(this.runner.isAlive ? 1 : this.runner.killType);
        }
        if (this.lifeCounter > 0) {
            --this.lifeCounter;
        }
        if (this.shieldCounter > 0) {
            --this.shieldCounter;
        }
        this.updateScene();
        this.detectCollision();
        int j = 0;
        while (j < this.sprites.size()) {
            ((Sprite)this.sprites.elementAt(j)).tick();
            ++j;
        }
    }

    private void detectCollision() {
        if (this.runner.isInState(32) || this.runner.isInState(64)) {
            return;
        }
        int i = 0;
        int j = this.obstacles.size() >= 2 ? 2 : this.obstacles.size();
        while (i < j) {
            Obstacles ob = (Obstacles)this.obstacles.elementAt(i);
            if (ob.intersectWith(this.runner.rect)) {
                XYRect tmp = new XYRect(this.runner.rect);
                ob.setDestroyed(true);
                tmp.intersect(ob.rect);
                boolean isHitAtTop = tmp.y == this.runner.rect.y;
                this.runner.addState(isHitAtTop ? 32 : 64);
                this.runner.jumpWithVelocity(isHitAtTop ? 0 : HIT_JUMP);
                this.runner.setBase(null);
                this.runner.velocityX = isHitAtTop ? Controller.DIS_W / 80 : Controller.DIS_W / 90;
                this.speed = 0.0f;
                return;
            }
            ++i;
        }
    }

    public void resetLifeCounter() {
        if (this.lifeCounter <= 0) {
            this.lifeCounter = 300;
        }
    }

    public void resetShieldCounter() {
        if (this.shieldCounter <= 0) {
            this.shieldCounter = 150;
        }
    }

    public boolean shouldGiveLife() {
        return this.lifeCounter <= 0;
    }

    public boolean shouldGiveShield() {
        return this.shieldCounter == 0;
    }

    public void stopShieldCounter() {
        this.shieldCounter = -10;
    }

    private void updateScene() {
        this.distance += (int)this.speed >> 3;
        this.distance %= Config.BUILDINGS.getWidth();
        Enumeration en = this.obstacles.elements();
        while (en.hasMoreElements()) {
            Obstacles type = (Obstacles)en.nextElement();
            type.rect.x = (int)((float)type.rect.x - this.speed);
        }
        Obstacles last = (Obstacles)this.obstacles.lastElement();
        if (last.rect.x < Controller.DIS_W) {
            int gap = last.rect.x + MIN_GAP + this.random.nextInt(MAX_GAP - MIN_GAP);
            int toss = this.random.nextInt(4);
            int y = toss == 0 ? this.floor.rect.y - AIR_BLOCK_H : this.floor.rect.y - Config.BLOCK.getHeight();
            int count = toss == 0 ? 1 : 1 + this.random.nextInt(2);
            int g = (int)((double)MIN_GAP * 0.05);
            Block obs = new Block(gap, y, count, g, new Image[]{Config.BLOCK}, this);
            obs.setBase(this.floor);
            this.obstacles.addElement(obs);
        }
    }

    public void setRunner(Runner sprite) {
        this.runner = sprite;
        sprite.setAttackListener(this);
        this.sprites.addElement(sprite);
    }

    public float getSpeed() {
        return this.speed;
    }

    public void addListener(WorldListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    public void attack(XYRect from, int inDirection) {
    }

    public void removeSprite(Sprite sprite) {
        if (sprite != null) {
            if (this.obstacles.contains(sprite)) {
                this.obstacles.removeElement(sprite);
            } else {
                this.sprites.removeElement(sprite);
            }
        }
    }

    public Runner getNinja() {
        return this.runner;
    }
}

