/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.objects;

import in.spicelabs.hippojump.objects.AnimationCompleteListener;
import in.spicelabs.hippojump.objects.AnimationSprite;
import in.spicelabs.hippojump.objects.Sprite;
import in.spicelabs.hippojump.objects.World;
import in.spicelabs.hippojump.objects.XYRect;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class AnimatableSprite
extends Sprite
implements AnimationCompleteListener {
    Vector animations = new Vector(10);

    public AnimatableSprite(XYRect rect, World world) {
        super(rect, world);
    }

    public void addAnimation(AnimationSprite anim) {
        if (anim == null) {
            return;
        }
        anim.setAnimationListener(this);
        this.animations.addElement(anim);
    }

    protected void draw(Graphics g) {
        if (this.animations.isEmpty()) {
            return;
        }
        Enumeration en = this.animations.elements();
        while (en.hasMoreElements()) {
            AnimationSprite element = (AnimationSprite)en.nextElement();
            element.draw(g);
            element.tick();
        }
    }

    public void onAnimationComplete(AnimationSprite sprite) {
        if (this.animations.contains(sprite)) {
            this.animations.removeElement(sprite);
        }
    }
}

