/*
 * Decompiled with CFR 0.152.
 */
package com.emobtech.googleanalyticsme;

import com.emobtech.googleanalyticsme.Request;
import com.emobtech.googleanalyticsme.TrackingURL;
import com.emobtech.googleanalyticsme.util.StringUtil;
import com.emobtech.googleanalyticsme.util.URLEncoder;

public final class Event
extends Request {
    private String event;

    public Event(String category, String action, String label, Integer value) {
        if (StringUtil.isEmpty(category)) {
            throw new IllegalArgumentException("Category must not be empty.");
        }
        if (StringUtil.isEmpty(action)) {
            throw new IllegalArgumentException("Action must not be empty.");
        }
        StringBuffer event = new StringBuffer();
        event.append("5(");
        event.append(category);
        event.append('*');
        event.append(action);
        if (!StringUtil.isEmpty(label)) {
            event.append('*');
            event.append(label);
        }
        event.append(')');
        if (value != null) {
            event.append('(');
            event.append(value);
            event.append(')');
        }
        this.event = event.toString();
    }

    TrackingURL trackingURL() {
        TrackingURL turl = super.trackingURL();
        turl.addParameter("utmt", "event");
        turl.addParameter("utme", URLEncoder.encode(this.event));
        return turl;
    }
}

