/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.objects;

import in.spicelabs.hippojump.objects.World;
import in.spicelabs.hippojump.objects.XYRect;
import javax.microedition.lcdui.Graphics;

public abstract class Sprite {
    protected XYRect rect;
    World world;
    Sprite parent;

    public Sprite(XYRect rect, World world) {
        this.rect = rect;
        this.world = world;
    }

    protected abstract void draw(Graphics var1);

    protected abstract void tick();

    public void setParent(Sprite parent) {
        this.parent = parent;
    }

    public int getSurfaceForSprite(Sprite fallableSprite) {
        return this.rect.y;
    }

    public boolean intersectWith(XYRect rect1) {
        if (this.parent == null) {
            return this.rect.intersects(rect1);
        }
        return this.getAbsoluteRect().intersects(rect1);
    }

    public int getAbsoluteX() {
        if (this.parent != null) {
            return this.parent.rect.x + this.rect.x;
        }
        return this.rect.x;
    }

    public int getAbsoluteY() {
        if (this.parent != null) {
            return this.parent.rect.y + this.rect.y;
        }
        return this.rect.y;
    }

    public XYRect getAbsoluteRect() {
        return new XYRect(this.getAbsoluteX(), this.getAbsoluteY(), this.rect.width, this.rect.height);
    }
}

