/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.jpride.objects;

import in.spicelabs.jpride.common.Config;
import in.spicelabs.jpride.objects.Circle;
import in.spicelabs.jpride.objects.Obstacles;
import in.spicelabs.jpride.objects.World;
import in.spicelabs.jpride.objects.XYRect;
import javax.microedition.lcdui.Image;

public class Electrods
extends Obstacles {
    private double angle;
    private XYRect zeroAngleRect;
    private int centerX;
    private int centerY;

    public Electrods(int x, int y, int type, World world) {
        super(x, y, Electrods.getFramesForType(type), type, false, world);
        this.setCanFall(false);
        this.centerX = this.rect.x + (this.rect.width >> 1);
        this.centerY = this.rect.y + (this.rect.height >> 1);
        this.updateZeroAngleRectAndCenter(type);
        switch (type) {
            case 8: {
                this.angle = -45.0;
                break;
            }
            case 7: {
                this.angle = 45.0;
                break;
            }
            case 4: {
                this.angle = -45.0;
                break;
            }
            case 3: {
                this.angle = 45.0;
            }
        }
    }

    private void updateZeroAngleRectAndCenter(int type) {
        this.centerX = this.rect.x + (this.rect.width >> 1);
        this.centerY = this.rect.y + (this.rect.height >> 1);
        int h = 0;
        int w = 0;
        switch (type) {
            case 7: 
            case 8: {
                h = (int)(0.5 * (double)Config.ELECTRODS_L[0][0].getHeight());
                w = (int)(0.8 * (double)Config.ELECTRODS_L[0][0].getWidth());
                break;
            }
            case 3: 
            case 4: {
                h = (int)(0.5 * (double)Config.ELECTRODS_S[0][0].getHeight());
                w = (int)(0.8 * (double)Config.ELECTRODS_S[0][0].getWidth());
                break;
            }
            default: {
                h = (int)(0.5 * (double)this.frames[0].getHeight());
                w = (int)(0.8 * (double)this.frames[0].getWidth());
            }
        }
        if (this.zeroAngleRect == null) {
            this.zeroAngleRect = new XYRect(this.centerX - (w >> 1), this.centerY - (h >> 1), w, h);
        } else {
            this.zeroAngleRect.x = this.centerX - (w >> 1);
            this.zeroAngleRect.y = this.centerY - (h >> 1);
        }
    }

    private static Image[] getFramesForType(int type) {
        switch (type) {
            case 8: {
                return Config.ELECTRODS_L[1];
            }
            case 7: {
                return Config.ELECTRODS_L[2];
            }
            case 5: {
                return Config.ELECTRODS_L[0];
            }
            case 6: {
                return Config.ELECTRODS_L[3];
            }
            case 4: {
                return Config.ELECTRODS_S[1];
            }
            case 3: {
                return Config.ELECTRODS_S[2];
            }
            case 1: {
                return Config.ELECTRODS_S[0];
            }
            case 2: {
                return Config.ELECTRODS_S[3];
            }
        }
        return null;
    }

    public XYRect getCollisionRect() {
        return super.getCollisionRect();
    }

    public boolean isCollidingWith(Circle circle) {
        this.updateZeroAngleRectAndCenter(this.getType());
        double unrotatedCircleX = Math.cos(this.angle) * (double)(circle.getX() - this.centerX) - Math.sin(this.angle) * (double)(circle.getY() - this.centerY) + (double)this.centerX;
        double unrotatedCircleY = Math.sin(this.angle) * (double)(circle.getX() - this.centerX) + Math.cos(this.angle) * (double)(circle.getY() - this.centerY) + (double)this.centerY;
        double closestX = unrotatedCircleX < (double)this.zeroAngleRect.x ? (double)this.zeroAngleRect.x : (unrotatedCircleX > (double)(this.zeroAngleRect.x + this.zeroAngleRect.width) ? (double)(this.zeroAngleRect.x + this.zeroAngleRect.width) : unrotatedCircleX);
        double closestY = unrotatedCircleY < (double)this.zeroAngleRect.y ? (double)this.zeroAngleRect.y : (unrotatedCircleY > (double)(this.zeroAngleRect.y + this.zeroAngleRect.height) ? (double)(this.zeroAngleRect.y + this.zeroAngleRect.height) : unrotatedCircleY);
        double distance = this.findDistance(unrotatedCircleX, unrotatedCircleY, closestX, closestY);
        return distance < circle.getRadius();
    }

    private double findDistance(double fromX, double fromY, double toX, double toY) {
        double a2 = Math.abs(fromX - toX);
        double b = Math.abs(fromY - toY);
        return Math.sqrt(a2 * a2 + b * b);
    }
}

