/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.jpride.objects;

import in.spicelabs.jpride.common.Config;
import in.spicelabs.jpride.objects.AnimationSprite;
import in.spicelabs.jpride.objects.AttackableSprite;
import in.spicelabs.jpride.objects.Circle;
import in.spicelabs.jpride.objects.ConsumableObstacle;
import in.spicelabs.jpride.objects.Controller;
import in.spicelabs.jpride.objects.Electrods;
import in.spicelabs.jpride.objects.FallableSprite;
import in.spicelabs.jpride.objects.Obstacles;
import in.spicelabs.jpride.objects.Platform;
import in.spicelabs.jpride.objects.Sprite;
import in.spicelabs.jpride.objects.World;
import in.spicelabs.jpride.objects.XYRect;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Runner
extends FallableSprite
implements AttackableSprite {
    public static final int INITIAL_POWER = 50;
    public static final int SHIELD_BERAK_LIMIT = 10;
    public static final int FULL_LIFE = 50;
    private static final int ANIM_DIE_ID = 200;
    protected boolean isJumping;
    protected boolean isAlive;
    protected int life;
    protected boolean canAttack;
    protected Vector jumpTrajectory;
    int frequency;
    Image[][] frames;
    int powers = 50;
    private int shieldBreakCounter;
    private int enemyDefeatCount;
    private boolean canConsume;
    private boolean isShielded;
    private int shieldFrame;
    private int coins;
    private Circle circle;
    AnimationSprite aniJetPack;

    public Runner(int x, int y, Image[][] frames, World world) {
        super(new XYRect(x, y, frames[0][0].getWidth(), frames[0][0].getHeight()), world);
        this.frames = frames;
        this.mass = 2;
        this.isAlive = true;
        this.life = 50;
        this.circle = new Circle(this);
        this.initJumpTrajectoryWithJumpVelocity(Controller.MAX_JUMP_H);
    }

    private void initJumpTrajectoryWithJumpVelocity(int v) {
        if (this.jumpTrajectory == null) {
            this.jumpTrajectory = new Vector(22);
            boolean isUP = true;
            int x = 0;
            int y = Controller.DIS_H;
            this.jumpTrajectory.addElement(new XYRect(x, Controller.DIS_H - y, 0, 0));
            while (true) {
                XYRect r;
                if (isUP) {
                    r = new XYRect(x += this.world.getSpeed(), Controller.DIS_H - (y -= v), 0, 0);
                    this.jumpTrajectory.addElement(r);
                    if ((v -= this.mass * 2) > 0) continue;
                    isUP = false;
                    continue;
                }
                r = new XYRect(x += this.world.getSpeed(), Controller.DIS_H - (y += v), 0, 0);
                this.jumpTrajectory.addElement(r);
                if ((v += this.mass * 2) >= Controller.MAX_JUMP_H) break;
            }
            this.jumpTrajectory.addElement(new XYRect(x + this.world.getSpeed(), 0, 0, 0));
        }
    }

    private Image[] getCurrentStateFrames() {
        Image[] frm = this.isInState(2) ? this.frames[1] : (this.isInState(8) ? this.frames[2] : (this.isInState(4) ? this.frames[1] : this.frames[0]));
        this.updateRect(frm[0]);
        return frm;
    }

    protected void draw(Graphics g) {
        Image[] frms = this.getCurrentStateFrames();
        this.updateRect(frms[this.frameCount]);
        g.drawImage(frms[this.frameCount], this.rect.x, this.rect.y, 0);
        super.draw(g);
    }

    protected void tick() {
        Image[] frms = this.getCurrentStateFrames();
        if (this.getState() != 8 || this.getState() == 8 && this.frameCount != frms.length - 1) {
            ++this.frameCount;
            this.frameCount %= frms.length;
        } else {
            this.isAlive = false;
            if (this.aniJetPack != null) {
                this.aniJetPack.setStopped(true);
            }
        }
        if (this.isInState(2)) {
            this.isJumping = true;
        }
        super.tick();
        if (this.isJumping && this.rect.y + this.rect.height >= this.getLowerBound()) {
            this.isJumping = false;
        }
        this.actionOnCollisionWithObstacles();
    }

    private void actionOnCollisionWithObstacles() {
        if (this.base != null && this.base instanceof Platform) {
            Enumeration e = this.world.obstacles.elements();
            while (e.hasMoreElements()) {
                Electrods electrods;
                Obstacles obs = (Obstacles)e.nextElement();
                if (obs.isFalling() || !this.intersectWith(obs.getCollisionRect())) continue;
                if (obs instanceof ConsumableObstacle) {
                    ConsumableObstacle cobs = (ConsumableObstacle)obs;
                    if (!this.canConsume || cobs.isConsumed()) continue;
                    switch (cobs.getType()) {
                        case 10: {
                            ++this.coins;
                        }
                    }
                    cobs.setConsumed(true);
                    continue;
                }
                if (!(obs instanceof Electrods) || (electrods = (Electrods)obs).isDestroyed() || !electrods.isCollidingWith(this.circle)) continue;
                electrods.setDestroyed(true);
                this.killWithExplosion();
            }
        }
    }

    private void killWithExplosion() {
        AnimationSprite ani = new AnimationSprite(Config.EXPLOSION, this.rect.width - Config.EXPLOSION[0].getWidth() >> 1, this.rect.height - Config.EXPLOSION[0].getHeight() >> 1, 2, this, 200);
        this.addAnimation(ani);
        this.world.setShouldStop(true);
    }

    public void resume() {
        this.setState(1);
        this.rect.y = 0;
        this.life = 50;
        this.isAlive = true;
        if (this.aniJetPack != null) {
            super.onAnimationComplete(this.aniJetPack);
            this.aniJetPack = null;
        }
    }

    public int getEnemyDefeatCount() {
        return this.enemyDefeatCount;
    }

    public void inicrementEnemyDefeatCount() {
        ++this.enemyDefeatCount;
    }

    public boolean isLifeNeeded() {
        return this.life > 25;
    }

    public int getShieldPowerPercentage() {
        return this.shieldBreakCounter * 100 / 10;
    }

    public int getLifePercentage() {
        return this.life * 100 / 50;
    }

    public int getCoins() {
        return this.coins;
    }

    public void setCoins(int coins) {
        this.coins = coins;
    }

    public int getPowers() {
        return this.powers;
    }

    public void setCanConsume(boolean canConsume) {
        this.canConsume = canConsume;
    }

    public boolean hasFallen() {
        return this.rect.y + this.rect.height >= Controller.DIS_H;
    }

    public void jumpWithVelocity(int velocityX, int velocitY) {
        if (this.isInState(8)) {
            return;
        }
        if (this.isAlive && this.rect.x + this.rect.width >= this.base.rect.x + this.rect.width) {
            this.velocityX = velocityX;
            this.velocityY = velocitY;
            this.addState(2);
        }
    }

    public void cancelJump() {
        if (this.isJumping && this.isInState(2)) {
            this.addState(4);
            this.velocityY = 0;
        }
    }

    protected int getAcceleration() {
        return 2 * this.mass;
    }

    public boolean beingAttacked(Sprite sprite) {
        if (this.isShielded) {
            --this.shieldBreakCounter;
            if (this.shieldBreakCounter <= 0) {
                this.isShielded = false;
            }
        } else {
            --this.life;
            this.isAlive = this.life > 0;
        }
        this.killWithExplosion();
        return true;
    }

    public boolean isShielded() {
        System.out.println("................................isShielded: " + (this.isShielded ? "true" : "false"));
        return this.isShielded;
    }

    public XYRect[] getjumpTrajectory() {
        Object[] trajectory = new XYRect[this.jumpTrajectory.size()];
        this.jumpTrajectory.copyInto(trajectory);
        return trajectory;
    }

    public void onAnimationComplete(AnimationSprite sprite) {
        super.onAnimationComplete(sprite);
        if (sprite.getId() == 200) {
            this.setState(8);
            if (this.aniJetPack == null) {
                this.aniJetPack = new AnimationSprite(Config.JET_FALL, this.rect.width + 20, this.rect.height - Config.EXPLOSION[0].getHeight() >> 1, 2, this, -1);
                this.aniJetPack.setAnimationCount(-1);
                this.addAnimation(this.aniJetPack);
            }
        }
    }
}

