/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.objects;

import in.spicelabs.subwaySketes.common.Config;
import in.spicelabs.subwaySketes.objects.Obstacles;
import in.spicelabs.subwaySketes.objects.Runner;
import in.spicelabs.subwaySketes.objects.Sprite;
import in.spicelabs.subwaySketes.objects.World;
import in.spicelabs.subwaySketes.objects.XYRect;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Spikes
extends Obstacles {
    private Vector activeObjects;

    public Spikes(int x, int y, int width, World world) {
        super(new XYRect(x, y, width, Config.SPIKES[0].getHeight()), world);
        this.frames = Config.SPIKES;
        this.mass = 4;
        this.canFall = false;
        this.rect.y -= this.rect.height;
        this.rect.width -= this.rect.width % this.frames[0].getWidth();
        this.activeObjects = new Vector();
    }

    public Spikes(int x, int y, Image[] frames, World world) {
        super(x, y, frames, world);
        this.isWalkable = false;
        this.canFall = false;
        this.rect.y -= this.rect.height;
        this.activeObjects = new Vector();
    }

    protected void draw(Graphics g) {
        g.drawImage(this.frames[0], this.rect.x, this.rect.y, 0);
    }

    public void setDestroyed(boolean isDestroyed) {
        super.setDestroyed(isDestroyed);
        Enumeration en = this.activeObjects.elements();
        while (en.hasMoreElements()) {
            Runner type = (Runner)en.nextElement();
            type.setState(1);
            type.isUnderSpikes = false;
        }
    }

    protected void tick() {
        super.tick();
        Enumeration en = this.activeObjects.elements();
        while (en.hasMoreElements()) {
            Runner type = (Runner)en.nextElement();
            if (this.intersectWith(type.rect) || !type.isUnderSpikes) continue;
            type.setState(1);
            type.isUnderSpikes = false;
        }
    }

    public void addActiveObject(Sprite activeObject) {
        if (!this.activeObjects.contains(activeObject)) {
            this.activeObjects.addElement(activeObject);
        }
    }
}

