/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.screens;

import com.emobtech.googleanalyticsme.Event;
import com.emobtech.googleanalyticsme.Tracker;
import in.spicelabs.subwaySketes.common.Config;
import in.spicelabs.subwaySketes.midlet.MainMidlet;
import in.spicelabs.subwaySketes.objects.Controller;
import in.spicelabs.subwaySketes.objects.MediaPlayerUtils;
import in.spicelabs.subwaySketes.screens.GameOverScreen;
import in.spicelabs.subwaySketes.screens.HomeScreen;
import in.spicelabs.subwaySketes.store.RMSData;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import vInAppAdEngine.VservManager;

public class GameScreen
extends GameCanvas
implements Runnable,
CommandListener {
    private Controller controller;
    private boolean isGameExited;
    private Alert alert;
    private Command backCommand;
    public static GameScreen screen;
    int startxpoint;
    int startyPoint;

    public GameScreen() {
        super(false);
        this.setFullScreenMode(true);
        this.controller = Controller.getController();
        this.controller.setHighscore(RMSData.getScore());
        this.controller.startNewGame();
        this.start();
        this.isGameExited = false;
        ++Config.gameCount;
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    public void start() {
        Thread runner = new Thread(this);
        runner.start();
    }

    public void paint(Graphics g) {
        this.controller.draw(g);
        g.drawImage(Config.getImage("back.png"), Config.SCREEN_WIDTH - Config.getImage("back.png").getWidth(), Config.SCREEN_HEIGHT - Config.getImage("back.png").getHeight(), 0);
    }

    public static GameScreen getinstance() {
        if (screen == null) {
            screen = new GameScreen();
        }
        return screen;
    }

    public void run() {
        while (!this.controller.isGameOver()) {
            if (this.isGameExited) break;
            this.repaint();
            try {
                Thread.sleep(Controller.getCycleRate());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.isGameExited) {
            return;
        }
        int ttlCoins = (int)(RMSData.getClassicGameTotalCoins() + (long)this.controller.getCoins());
        if ((long)ttlCoins >= 2000L) {
            this.showConfirmation("", "You can resume from here by redeeming your 2000 coins.", ttlCoins);
        } else {
            System.out.println("else");
            RMSData.setClassicGameTotalCoins(RMSData.getClassicGameTotalCoins() + (long)this.controller.getCoins());
            Hashtable<String, String> vservConfigTableAd = new Hashtable<String, String>();
            vservConfigTableAd.put("zoneId", "d4e9bb5e");
            vservConfigTableAd.put("showAt", "end");
            new VservManager(Config.midlet, vservConfigTableAd);
            if ((long)this.controller.getScore() > RMSData.getScore()) {
                MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), this.controller.getCoins(), this.controller.getGameOverType(), true));
            } else {
                MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), this.controller.getCoins(), this.controller.getGameOverType(), false));
            }
            screen = null;
        }
    }

    protected void exitConfirmation(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    GameScreen.this.isGameExited = true;
                    MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                    screen = null;
                }
                if (c.getLabel().equals("No")) {
                    MainMidlet.display.setCurrent((Displayable)GameScreen.getinstance());
                    GameScreen.this.isGameExited = false;
                    if (!GameScreen.this.controller.isGameOver()) {
                        GameScreen.this.controller.setPaused(false);
                    }
                    GameScreen.this.alert = null;
                }
            }
        });
        MainMidlet.display.setCurrent((Displayable)this.alert);
    }

    public void showConfirmation(String title, String text, final int ttlCoins) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    int coinsLeft = 0;
                    if (RMSData.getClassicGameTotalCoins() < 2000L) {
                        coinsLeft = (int)((long)ttlCoins - 2000L);
                        GameScreen.this.controller.setCoins(coinsLeft);
                    }
                    MainMidlet.display.setCurrent((Displayable)GameScreen.getinstance());
                    GameScreen.this.controller.resumeGame();
                    GameScreen.this.start();
                    long remainingCoins = (long)ttlCoins - 2000L - (long)coinsLeft;
                    RMSData.setClassicGameTotalCoins(remainingCoins);
                    GameScreen.this.alert = null;
                }
                if (c.getLabel().equals("No")) {
                    RMSData.setClassicGameTotalCoins(RMSData.getClassicGameTotalCoins() + (long)GameScreen.this.controller.getCoins());
                    if ((long)GameScreen.this.controller.getScore() > RMSData.getScore()) {
                        MainMidlet.display.setCurrent((Displayable)new GameOverScreen(GameScreen.this.controller.getScore(), GameScreen.this.controller.getCoins(), GameScreen.this.controller.getGameOverType(), true));
                    } else {
                        MainMidlet.display.setCurrent((Displayable)new GameOverScreen(GameScreen.this.controller.getScore(), GameScreen.this.controller.getCoins(), GameScreen.this.controller.getGameOverType(), false));
                    }
                    GameScreen.this.alert = null;
                    screen = null;
                }
            }
        });
        MainMidlet.display.setCurrent((Displayable)this.alert);
    }

    protected void pointerReleased(int x, int y) {
        if (x > Config.SCREEN_WIDTH - Config.getImage("back.png").getWidth() && x < Config.SCREEN_WIDTH && y > Config.SCREEN_HEIGHT - Config.getImage("back.png").getHeight()) {
            this.exitConfirmation(" ", "Are you sure you want to exit?");
            if (!this.controller.isGameOver()) {
                this.controller.setPaused(true);
            }
        }
        int xdiff = x - this.startxpoint;
        int ydiff = y - this.startyPoint;
        if (Math.abs(xdiff) < Math.abs(ydiff)) {
            if (ydiff > 0) {
                this.controller.navigationDown();
            } else {
                this.controller.jump(1);
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        this.startxpoint = x;
        this.startyPoint = y;
    }

    protected void showNotify() {
        System.out.println("show notify");
        MediaPlayerUtils.getInstance().playMedia("subwayskates.mp3", -1);
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-10");
        tracker.addToQueue(new Event("Game_Play", "Play_Started", "Game_Play", null));
    }

    protected void keyPressed(int keyCode) {
        System.out.println(this.getKeyName(keyCode) + this.getGameAction(keyCode));
        int key = this.getGameAction(keyCode);
        switch (key) {
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 1: {
                this.controller.jump(1);
                break;
            }
            case 6: {
                this.controller.navigationDown();
            }
        }
        if (this.getKeyName(keyCode).equals("2")) {
            this.controller.jump(1);
        } else if (!this.getKeyName(keyCode).equals("4") && !this.getKeyName(keyCode).equals("6") && this.getKeyName(keyCode).equals("8")) {
            this.controller.navigationDown();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.exitConfirmation(" ", "Are you sure you want to exit?");
            if (!this.controller.isGameOver()) {
                this.controller.setPaused(true);
            }
        }
    }

    protected void hideNotify() {
        MediaPlayerUtils.getInstance().stopMedia();
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-10");
        tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(this.controller.getScore())));
    }
}

