/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.objects;

import in.spicelabs.subwaySketes.common.Config;
import in.spicelabs.subwaySketes.objects.PowerSprite;
import in.spicelabs.subwaySketes.objects.Runner;
import in.spicelabs.subwaySketes.objects.Sprite;
import in.spicelabs.subwaySketes.objects.World;
import in.spicelabs.subwaySketes.objects.WorldListener;
import in.spicelabs.subwaySketes.objects.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Controller
implements WorldListener {
    public static int DIS_W = Config.SCREEN_WIDTH;
    public static int DIS_H = Config.SCREEN_HEIGHT;
    public static final int MIN_JUMP_H = (int)((double)DIS_H * 0.05);
    public static final int MAX_JUMP_H = (int)((double)DIS_H * 0.09);
    private static final int BEGIN_CYCLE_RATE = 75;
    private static final int SCORE_BONUS_FOR_ENEMY_DEFEAT = 1000;
    private static Controller controller;
    private Runner ninja;
    private World world;
    private boolean isGameOver;
    private int cycleRate = 75;
    private int cycleCounter;
    private int score;
    private int duration;
    private boolean isPaused;
    private PowerSprite coin;
    private PowerSprite shield;
    private PowerSprite enemyDefeat;
    private StringBuffer strHighScore = new StringBuffer("High Score: ");
    private int gameOverType;

    private Controller() {
        int gap;
        int y = gap = 5;
        this.coin = new PowerSprite(new Image[]{Config.COIN}, gap, y);
        y += this.coin.rect.height + gap;
        y += gap;
        this.shield = new PowerSprite(Config.PWR_SHIELD, 0, gap, Config.SCREEN_WIDTH >> 2, 0x808080);
        this.shield.rect.x = Config.SCREEN_WIDTH - this.shield.rect.width >> 1;
        this.shield.rect.y = gap + this.coin.rect.height;
    }

    public void draw(Graphics g) {
        if (!this.isPaused) {
            ++this.score;
            ++this.cycleCounter;
            this.duration += this.cycleRate;
            if (this.cycleCounter > 150 && this.cycleRate > 50) {
                this.cycleRate -= 2;
                this.cycleCounter = 0;
            }
            this.world.tick();
        }
        this.world.draw(g);
        this.coin.draw(g, "" + this.ninja.getCoins());
        g.drawString(this.strHighScore.toString(), Config.SCREEN_WIDTH - g.getFont().stringWidth(this.strHighScore.toString()), 0, 0);
        g.drawString("" + this.score, Config.SCREEN_WIDTH - g.getFont().stringWidth("" + this.score), g.getFont().getHeight(), 0);
        if (this.ninja.isShielded()) {
            this.shield.draw(g, this.ninja.getShieldPowerPercentage());
        }
    }

    public static Controller getController() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    public static int getWorldSpeed() {
        return Controller.controller.world.getSpeed();
    }

    public static int getDurationInSeconds() {
        return Controller.controller.duration / 1000;
    }

    public void startNewGame() {
        this.isGameOver = false;
        this.isPaused = false;
        this.score = 0;
        this.duration = 0;
        this.cycleRate = 75;
        int x = DIS_W / 7;
        this.world = new World(new XYRect(0, 0, DIS_W, DIS_H));
        this.world.addListener(this);
        this.ninja = new Runner(x, 0, Config.NINJA_FRAMES, this.world);
        this.ninja.setCanConsume(true);
        this.world.setNinja(this.ninja);
        this.world.initEnvironment();
    }

    public void resumeGame() {
        this.ninja.rect.y = 0;
        this.ninja.beingAttackedCount = 0;
        this.isGameOver = false;
        this.ninja.isUnderSpikes = false;
        this.ninja.isAlive = true;
        this.ninja.setFullLife();
    }

    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public int getScore() {
        return this.score;
    }

    public int getDuration() {
        return this.duration;
    }

    public void jump(int jumpRate) {
        if (!this.isGameOver) {
            this.ninja.jumpWithVelocity(MAX_JUMP_H);
        }
    }

    public void cancelJump() {
        if (!this.isGameOver) {
            this.ninja.cancelJump();
        }
    }

    public void navigationDown() {
        if (!this.isGameOver) {
            if (this.ninja.isInState(2)) {
                this.ninja.cancelJump();
            } else {
                this.rollDown();
            }
        }
    }

    public void rollDown() {
        if (!this.isGameOver) {
            this.ninja.rollDown();
        }
    }

    public void attack() {
    }

    public boolean isGameOver() {
        return this.isGameOver;
    }

    public void gameOver(int type) {
        this.gameOverType = type;
        this.isGameOver = true;
    }

    public void taskAchieved(int taskType) {
        if (taskType == 1001) {
            this.score += 1000;
        }
    }

    public static int getNinjaAcceleration() {
        return Controller.controller.ninja.getAcceleration();
    }

    public static boolean isOutOfWorld(Sprite sprite) {
        return !Controller.controller.world.intersectWith(sprite.rect);
    }

    public static int getCycleRate() {
        return Controller.controller.cycleRate;
    }

    public static void setCycleRate(int cycleRate) {
        Controller.controller.cycleRate = cycleRate;
    }

    public int getCoins() {
        return this.ninja.getCoins();
    }

    public void setCoins(int coins) {
        this.ninja.setCoins(coins);
    }

    public void setHighscore(long highscore) {
        this.strHighScore = new StringBuffer("High Score: ");
        this.strHighScore.append(highscore);
    }

    public int getGameOverType() {
        return this.gameOverType;
    }
}

