/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.objects;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import javax.microedition.media.control.VolumeControl;

public class MediaPlayer {
    private Player player;

    public MediaPlayer(String fileURL) throws IOException, MediaException {
        this.player = Manager.createPlayer((String)fileURL);
        this.setListener();
    }

    public MediaPlayer(InputStream inputStream, String contentType) throws IOException, MediaException {
        this.player = Manager.createPlayer((InputStream)inputStream, (String)contentType);
        this.setListener();
    }

    public void addPlayerListener(PlayerListener playerListener) {
        this.player.addPlayerListener(playerListener);
    }

    private void setListener() {
        this.player.addPlayerListener(new PlayerListener(){

            public void playerUpdate(Player player, String event, Object eventData) {
                if ("started".equals(event)) {
                    VolumeControl vc = (VolumeControl)player.getControl("VolumeControl");
                    vc.setLevel(vc.getLevel());
                }
            }
        });
    }

    public void deallocate() {
        this.player.deallocate();
    }

    public String getContentType() {
        return this.player.getContentType();
    }

    public long getDuration() {
        return this.player.getDuration();
    }

    public long getMediaTime() {
        return this.player.getMediaTime();
    }

    public int getState() {
        return this.player.getState();
    }

    public TimeBase getTimeBase() {
        return null;
    }

    public void prefetch() throws MediaException {
        this.player.prefetch();
    }

    public void realize() throws MediaException {
        this.player.realize();
    }

    public void removePlayerListener(PlayerListener playerListener) {
        this.player.removePlayerListener(playerListener);
    }

    public void setLoopCount(int count) {
        this.player.setLoopCount(count);
    }

    public long setMediaTime(long now) throws MediaException {
        return this.player.setMediaTime(now);
    }

    public void play() throws MediaException {
        this.player.start();
    }

    public void pause() throws MediaException {
        if (this.isPlaying()) {
            this.player.stop();
        }
    }

    public void stop() {
        this.player.close();
    }

    public Control getControl(String controlType) {
        return this.getControl(controlType);
    }

    public Control[] getControls() {
        return this.player.getControls();
    }

    public int getLevel() {
        VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
        return vc.getLevel();
    }

    public boolean isMuted() {
        VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
        return vc.isMuted();
    }

    public boolean isPlaying() {
        return this.player.getState() == 400;
    }

    public int setLevel(int level) {
        VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
        return vc.setLevel(level);
    }

    public void setMute(boolean mute) {
        VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
        vc.setMute(mute);
    }

    public boolean isSamePlayer(Player player2) {
        return this.player == player2;
    }
}

