/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.objects;

import in.spicelabs.subwaySketes.common.Config;
import in.spicelabs.subwaySketes.objects.Building;
import in.spicelabs.subwaySketes.objects.Coins;
import in.spicelabs.subwaySketes.objects.ConsumableObstacle;
import in.spicelabs.subwaySketes.objects.Controller;
import in.spicelabs.subwaySketes.objects.FallableSprite;
import in.spicelabs.subwaySketes.objects.FireBall;
import in.spicelabs.subwaySketes.objects.Life;
import in.spicelabs.subwaySketes.objects.Obstacles;
import in.spicelabs.subwaySketes.objects.Shuriken;
import in.spicelabs.subwaySketes.objects.Spikes;
import in.spicelabs.subwaySketes.objects.Sprite;
import in.spicelabs.subwaySketes.objects.World;
import in.spicelabs.subwaySketes.objects.XYRect;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Runner
extends FallableSprite {
    public static final int INITIAL_POWER = 50;
    public static final int SHIELD_BERAK_LIMIT = 10;
    public static final int INITIAL_LIFE = 50;
    protected boolean isJumping;
    protected int killType;
    protected boolean isAlive;
    protected int beingAttackedCount;
    protected int maxSurvivableAttack;
    protected boolean canAttack;
    protected Vector jumpTrajectory;
    protected boolean isUnderSpikes;
    int frameCount;
    int frequency;
    Image[][] frames;
    int powers = 50;
    private boolean canConsume;
    private int coins;
    public boolean isShielded;
    private int shieldBreakCounter;
    public int shieldFrame;
    private int enemyDefeatCount;

    public Runner(int x, int y, Image[][] frames, World world) {
        super(new XYRect(x, y, frames[0][0].getWidth(), frames[0][0].getHeight()), world);
        this.frames = frames;
        this.mass = 3;
        this.isAlive = true;
        this.maxSurvivableAttack = 50;
        this.initJumpTrajectoryWithJumpVelocity(Controller.MAX_JUMP_H);
    }

    private void initJumpTrajectoryWithJumpVelocity(int v) {
        if (this.jumpTrajectory == null) {
            this.jumpTrajectory = new Vector(22);
            boolean isUP = true;
            int x = 0;
            int y = Controller.DIS_H;
            this.jumpTrajectory.addElement(new XYRect(x, Controller.DIS_H - y, 0, 0));
            while (true) {
                XYRect r;
                if (isUP) {
                    r = new XYRect(x += this.world.getSpeed(), Controller.DIS_H - (y -= v), 0, 0);
                    this.jumpTrajectory.addElement(r);
                    if ((v -= this.mass * 2) > 0) continue;
                    isUP = false;
                    continue;
                }
                r = new XYRect(x += this.world.getSpeed(), Controller.DIS_H - (y += v), 0, 0);
                this.jumpTrajectory.addElement(r);
                if ((v += this.mass * 2) >= Controller.MAX_JUMP_H) break;
            }
            this.jumpTrajectory.addElement(new XYRect(x + this.world.getSpeed(), 0, 0, 0));
        }
    }

    protected void draw(Graphics g) {
        Image[] frms = this.getCurrentStateFrames();
        g.drawImage(frms[this.frameCount], this.rect.x, this.rect.y, 0);
        if (this.isShielded) {
            g.drawImage(Config.SHIELD_FRAME[this.shieldFrame], this.rect.x + (this.rect.width - Config.SHIELD_FRAME[this.shieldFrame].getWidth() >> 1), this.rect.y + this.rect.height - Config.SHIELD_FRAME[this.shieldFrame].getHeight(), 0);
            ++this.shieldFrame;
            this.shieldFrame %= Config.SHIELD_FRAME.length;
        }
        int w = (int)((float)(this.rect.width * (this.maxSurvivableAttack - this.beingAttackedCount)) / (float)this.maxSurvivableAttack);
        g.setColor(this.maxSurvivableAttack - this.beingAttackedCount <= this.maxSurvivableAttack >> 2 ? 14876706 : 128);
        g.fillRect(this.rect.x, this.rect.y, w, this.rect.height / 12);
        g.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height / 12);
        super.draw(g);
    }

    private Image[] getCurrentStateFrames() {
        if (this.isInState(16)) {
            return this.frames[4];
        }
        if (this.isInState(2)) {
            return this.frames[1];
        }
        if (this.isInState(4)) {
            return this.frames[2];
        }
        if (this.isInState(8)) {
            return this.frames[3];
        }
        return this.frames[0];
    }

    protected void tick() {
        Image[] frms = this.getCurrentStateFrames();
        ++this.frequency;
        if (this.frequency % 2 == 0) {
            ++this.frameCount;
            this.frameCount %= frms.length;
            this.frequency = 0;
        }
        this.updateCurrentBase();
        if (this.isInState(16) && this.frameCount == frms.length - 1) {
            this.setState(1);
        }
        if (this.isInState(2)) {
            this.isJumping = true;
            this.rect.y -= this.velocity;
            this.velocity -= this.mass * 2;
            if (this.velocity <= 0) {
                this.setState(4);
            }
            this.actionOnCollisionWithObstacles();
            return;
        }
        if (this.isInState(8) && this.frameCount == frms.length - 1 && !this.isUnderSpikes) {
            this.setState(1);
        }
        super.tick();
        if (this.isJumping && this.rect.y + this.rect.height >= this.getLowerBound()) {
            this.isJumping = false;
        }
        this.actionOnCollisionWithObstacles();
    }

    private void actionOnCollisionWithObstacles() {
        if (this.base != null && this.base instanceof Building) {
            Building b = (Building)this.base;
            int i = 0;
            while (i < b.obstacles.length) {
                Obstacles obs = b.obstacles[i];
                if (!obs.isFalling && this.intersectWith(obs.rect)) {
                    if (obs instanceof ConsumableObstacle) {
                        ConsumableObstacle cobs = (ConsumableObstacle)obs;
                        if (this.canConsume && !cobs.isConsumed) {
                            if (cobs instanceof Coins) {
                                ++this.coins;
                            } else if (cobs instanceof Shuriken) {
                                ++this.powers;
                            } else if (cobs instanceof Life) {
                                this.beingAttackedCount -= this.maxSurvivableAttack >> 1;
                                if (this.beingAttackedCount < this.maxSurvivableAttack) {
                                    this.beingAttackedCount = 0;
                                }
                            } else {
                                this.isShielded = true;
                                this.shieldBreakCounter = 10;
                            }
                            cobs.isConsumed = true;
                        }
                    } else if (obs instanceof Spikes) {
                        if (obs.isDestroyed()) {
                            ++i;
                            continue;
                        }
                        if (this.isUnderSpikes && this.isInState(8)) {
                            ++i;
                            continue;
                        }
                        if (this.isInState(8)) {
                            this.isUnderSpikes = true;
                            ((Spikes)obs).addActiveObject(this);
                        } else {
                            this.beingAttacked(obs);
                            ((Spikes)obs).setDestroyed(true);
                            if (this.isShielded) {
                                this.setShieldBreakCounter(0);
                            } else {
                                this.isAlive = false;
                                this.killType = obs instanceof FireBall ? 3 : 2;
                                this.beingAttackedCount = this.maxSurvivableAttack + 1;
                            }
                        }
                    } else {
                        this.beingAttacked(obs);
                        obs.startFall(10);
                    }
                }
                ++i;
            }
        }
    }

    public int getEnemyDefeatCount() {
        return this.enemyDefeatCount;
    }

    public void inicrementEnemyDefeatCount() {
        ++this.enemyDefeatCount;
    }

    public boolean isLifeNeeded() {
        return this.beingAttackedCount > this.maxSurvivableAttack >> 1;
    }

    private void updateCurrentBase() {
        if (this.rect.x + (this.rect.width >> 1) > this.base.rect.x + this.base.rect.width && this.rect.y + this.rect.height <= this.base.rect.y) {
            this.base = (Sprite)this.world.buildings.elementAt(this.world.buildings.indexOf(this.base) + 1);
        }
    }

    public int getShieldPowerPercentage() {
        return this.shieldBreakCounter * 100 / 10;
    }

    public int getCoins() {
        return this.coins;
    }

    public void setCoins(int coins) {
        this.coins = coins;
    }

    public void setState(int state) {
        super.setState(state);
        this.frameCount = 0;
    }

    public void setState(int state, boolean resetFrame) {
        super.setState(state);
        if (resetFrame) {
            this.frameCount = 0;
        }
    }

    public int getPowers() {
        return this.powers;
    }

    public void setCanConsume(boolean canConsume) {
        this.canConsume = canConsume;
    }

    public boolean hasFallen() {
        return this.rect.y + this.rect.height >= Controller.DIS_H;
    }

    public void jumpWithVelocity(int velocity) {
        if (!this.isJumping && !this.isUnderSpikes && this.rect.x >= this.base.rect.x) {
            this.velocity = velocity;
            this.setState(2);
        }
    }

    public void cancelJump() {
        if (this.isJumping && this.isInState(2)) {
            this.setState(4);
            this.velocity = 0;
        }
    }

    public void rollDown() {
        if (this.isInState(1)) {
            this.setState(8);
        }
    }

    protected int getAcceleration() {
        return 2 * this.mass;
    }

    public boolean beingAttacked(Sprite sprite) {
        if (this.isShielded) {
            this.setShieldBreakCounter(this.shieldBreakCounter - 1);
        } else {
            ++this.beingAttackedCount;
            this.isAlive = this.beingAttackedCount <= this.maxSurvivableAttack;
            this.killType = 0;
        }
        return true;
    }

    public void setShieldBreakCounter(int shieldBreakCounter) {
        this.shieldBreakCounter = shieldBreakCounter;
        if (shieldBreakCounter <= 0) {
            this.world.resetShieldCounter();
            this.isShielded = false;
        } else {
            this.isShielded = true;
        }
    }

    public void setFullLife() {
        this.beingAttackedCount = 0;
    }

    public boolean isShielded() {
        return this.isShielded;
    }

    public XYRect[] getjumpTrajectory() {
        Object[] trajectory = new XYRect[this.jumpTrajectory.size()];
        this.jumpTrajectory.copyInto(trajectory);
        return trajectory;
    }
}

