/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.objects;

import in.spicelabs.subwaySketes.common.Config;
import in.spicelabs.subwaySketes.objects.Building;
import in.spicelabs.subwaySketes.objects.Controller;
import in.spicelabs.subwaySketes.objects.RemoveSpriteListener;
import in.spicelabs.subwaySketes.objects.Runner;
import in.spicelabs.subwaySketes.objects.Shield;
import in.spicelabs.subwaySketes.objects.Sprite;
import in.spicelabs.subwaySketes.objects.WorldListener;
import in.spicelabs.subwaySketes.objects.XYRect;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class World
extends Sprite
implements RemoveSpriteListener {
    private static final int MIN_GAP = 80;
    private static final int MIN_BUILDING_H = Controller.DIS_H >> 2;
    private static final int MIN_BUILDING_W = Controller.DIS_W / 3;
    private static final int LIFE_INCREMENT = 5;
    protected Vector buildings;
    private Vector sprites;
    private WorldListener listener;
    private Runner ninja;
    private Random random = new Random();
    private int speed = Controller.DIS_W / 20;
    private long opponentAppearanceCount = (8 + this.random.nextInt(7)) * 1000 / Controller.getCycleRate();
    private Image bgBuilding1;
    private Image bgBuilding2;
    private int distance;
    private int lifeCounter = 120;
    private int shieldCounter = 120;
    private int opponentCount;
    private int resumeCyceRate = -1;

    public World(XYRect rect) {
        super(rect, null);
        this.buildings = new Vector(3);
        this.sprites = new Vector();
        this.bgBuilding1 = Config.BACKGROUNDS[this.random.nextInt(Config.BACKGROUNDS.length)];
        this.bgBuilding2 = Config.BACKGROUNDS[this.random.nextInt(Config.BACKGROUNDS.length)];
    }

    public void initEnvironment() {
        int bh = this.getRandomHeight();
        Building.init();
        Building bb = new Building(new XYRect(0, Controller.DIS_H - bh, 2 * Controller.DIS_W, bh), this);
        this.buildings.addElement(bb);
        this.ninja.setBase(bb);
    }

    protected void draw(Graphics g) {
        g.drawImage(this.bgBuilding1, -this.distance, this.rect.height - this.bgBuilding1.getHeight(), 0);
        g.drawImage(this.bgBuilding2, Config.SCREEN_WIDTH - this.distance, this.rect.height - this.bgBuilding2.getHeight(), 0);
        int i = 0;
        while (i < this.buildings.size()) {
            ((Sprite)this.buildings.elementAt(i)).draw(g);
            ++i;
        }
        int j = 0;
        while (j < this.sprites.size()) {
            ((Sprite)this.sprites.elementAt(j)).draw(g);
            ++j;
        }
    }

    protected void tick() {
        if ((this.ninja.hasFallen() || !this.ninja.isAlive) && this.listener != null) {
            this.listener.gameOver(this.ninja.isAlive ? 1 : this.ninja.killType);
        }
        if (this.lifeCounter > 0) {
            --this.lifeCounter;
        }
        if (this.shieldCounter > 0) {
            --this.shieldCounter;
        }
        this.updateScene();
        this.updateBuildingQueue();
        int i = 0;
        while (i < this.buildings.size()) {
            ((Building)this.buildings.elementAt(i)).tick();
            ++i;
        }
        this.detectCollisionAmongAttacableSprites();
        int j = 0;
        while (j < this.sprites.size()) {
            ((Sprite)this.sprites.elementAt(j)).tick();
            ++j;
        }
    }

    public void resetLifeCounter() {
        if (this.lifeCounter <= 0) {
            this.lifeCounter = 120;
        }
    }

    public void resetShieldCounter() {
        if (this.shieldCounter <= 0) {
            this.shieldCounter = 60;
        }
    }

    public boolean shouldGiveLife() {
        return this.lifeCounter <= 0;
    }

    public boolean shouldGiveShield() {
        return this.shieldCounter == 0;
    }

    public void stopShieldCounter() {
        this.shieldCounter = -10;
    }

    private void updateScene() {
        this.distance += this.speed >> 2;
        if (this.distance >= this.bgBuilding1.getWidth()) {
            this.bgBuilding1 = this.bgBuilding2;
            this.bgBuilding2 = Config.BACKGROUNDS[this.random.nextInt(Config.BACKGROUNDS.length)];
            this.distance = 0;
        }
    }

    public void setNinja(Runner sprite) {
        this.ninja = sprite;
        this.sprites.addElement(sprite);
    }

    public int getSpeed() {
        return this.speed;
    }

    public void addListener(WorldListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    private void updateBuildingQueue() {
        Building first = (Building)this.buildings.firstElement();
        if (first.rect.x + first.rect.width < 0) {
            int i = 0;
            while (i < first.obstacles.length) {
                if (first.obstacles[i] instanceof Shield && !((Shield)first.obstacles[i]).isConsumed) {
                    this.resetShieldCounter();
                }
                ++i;
            }
            this.buildings.removeElementAt(0);
        }
        Building last = (Building)this.buildings.lastElement();
        if (last.rect.x + last.rect.width < this.rect.width + 80) {
            int bh = this.getRandomHeight();
            XYRect[] trajectory = this.ninja.getjumpTrajectory();
            int a2 = trajectory.length >> 1;
            XYRect rect = trajectory[a2 + this.random.nextInt(trajectory.length - a2 - 2)];
            Building building = new Building(new XYRect(last.rect.x + last.rect.width + rect.x - 3 * (this.ninja.rect.width >> 1), Controller.DIS_H - bh, this.getRandomWidth(), bh), this);
            this.buildings.addElement(building);
        }
    }

    private int getRandomHeight() {
        return MIN_BUILDING_H + this.random.nextInt(Controller.DIS_H / 5);
    }

    private int getRandomWidth() {
        return MIN_BUILDING_W + this.random.nextInt(2 * Controller.DIS_W);
    }

    private void detectCollisionAmongAttacableSprites() {
        int j = 0;
        while (j < this.sprites.size()) {
            Sprite sp = (Sprite)this.sprites.elementAt(j);
            ++j;
        }
    }

    public void attack(XYRect from, int inDirection) {
    }

    public void removeSprite(Sprite sprite) {
    }

    public Runner getNinja() {
        return this.ninja;
    }

    public Vector getBuildings() {
        return this.buildings;
    }
}

