/*
 * Decompiled with CFR 0.152.
 */
import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

class GameCanvas
extends Component
implements CommandListener {
    Random random;
    int w;
    int h;
    boolean loadBackground;
    int playerLocationX;
    int playerLocationY;
    int playerWidth;
    int playerHeight;
    public boolean clickFlag;
    public boolean moveUp;
    int[][] arr;
    int[][] brickDimensions;
    int brickCount = 1;
    public int gameLevel;
    public boolean newBrick;
    int time = 20;
    int brickSpeed = 1;
    int userSpeed = 1;
    int bgSpeed = 1;
    Image batman;
    Image levelNumber;
    int level = 1;
    public boolean initilizeVariables = false;
    public boolean animation = true;
    public boolean gameoverflag = false;
    int score = 0;
    int maxBricksOnScreen;
    int targetBricksCross;
    public int life;
    public int brickCrossed = 0;
    public boolean levelCompleted = false;
    public int collisionWithBrickNumber = -1;
    public Image ballImage;
    public Image gameOver;
    public Image up;
    public Image down;
    int highScore = 0;
    int h75;
    public Player gameMusic;
    Vector v1;
    MIDlet mainMidlet;
    boolean flag501;
    Image bg;
    int bgx = 0;
    Image[] sprite = new Image[5];
    Image power;
    int spriteCounter = 0;
    public boolean powerflag = true;
    int powerx;
    int powery;
    int powerWH;
    public boolean powerGrantedFlag = false;
    int powerType = 1;
    int powerCount = 1;
    public int oldSpeed;
    public int oldBgSpeed;
    public int powerCounter;
    int gapCount = 0;

    public GameCanvas() {
        try {
            for (int i = 0; i < this.sprite.length; ++i) {
                this.sprite[i] = Image.createImage("/bird" + i + ".png");
            }
            this.spriteCounter = 0;
            this.ballImage = Image.createImage("/ball1.png");
            this.up = Image.createImage("/up.png");
            this.down = Image.createImage("/down.png");
            this.bg = Image.createImage("/bg.jpg");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.highScore = new HighScore().previousScore;
        try {
            this.gameMusic = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/smooth.mp3"), (String)"audio/mpeg");
            this.gameMusic.setLoopCount(-1);
            this.gameMusic.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        String str = System.getProperty("microedition.platform");
        System.out.println(str);
        if (str.substring(0, str.indexOf("/")).equalsIgnoreCase("Nokia501")) {
            this.flag501 = true;
        }
    }

    GameCanvas(MIDlet mainMidlet) {
        this();
        this.mainMidlet = mainMidlet;
        new AdThread(mainMidlet, this).start();
    }

    public void imageNumberChange() {
    }

    public void paint(Graphics g) {
        this.w = this.getWidth();
        this.h = this.getHeight();
        if (!this.initilizeVariables) {
            this.initilizeVariables();
            this.initilizeVariables = true;
        }
        if (this.animation) {
            this.animationIsGoingOn(g);
        } else if (this.gameoverflag) {
            try {
                this.gameOver = Image.createImage("/gameover1.png");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.updateScreen(g);
            g.drawImage(this.gameOver, 10, 10, this.w - 10, this.h - 10);
            if (this.v1 != null) {
                g.drawImage(Image.createImage(this.v1.elementAt(0)), 0, 0, this.getWidth(), this.getHeight() / 7);
            }
        } else if (this.levelCompleted) {
            System.out.println("Level Increasing......");
            ++this.level;
            this.gameLevel(this.level);
            this.levelCompleted = false;
        } else if (this.powerGrantedFlag) {
            switch (this.powerType) {
                case 1: {
                    if (this.powerCounter < 100) {
                        ++this.powerCounter;
                    }
                    if (this.powerCounter >= 100) {
                        this.powerGrantedFlag = false;
                        this.bgSpeed = this.oldBgSpeed;
                        this.brickSpeed = this.oldSpeed;
                        this.time = 20;
                        this.powerflag = true;
                    }
                    this.updateScreen(g);
                    this.showBricks(g);
                    this.drawPlayer(g);
                }
            }
        } else {
            if (!this.loadBackground) {
                this.loadScreen(g);
            } else {
                this.updateScreen(g);
            }
            this.showBricks(g);
            if (this.clickFlag) {
                this.upDatePlayerLocation();
            }
            if (this.checkForCollison()) {
                --this.life;
                this.arr[this.collisionWithBrickNumber][0] = 0;
                this.arr[this.collisionWithBrickNumber][1] = 0;
                this.swapToPreviousIndex(this.collisionWithBrickNumber);
            }
            if (this.brickCrossed > 10 * this.powerCount && this.brickCrossed < 10 * this.powerCount + 10 && this.powerflag) {
                this.powerCount += this.level;
                this.powerflag = false;
                this.powerCounter = 1;
                this.powery = this.randomInRange(this.percentage(this.h, 70));
                this.powerx = this.w + 10;
                this.powerType = 1;
                try {
                    this.power = Image.createImage("/apple1.png");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (!this.powerflag) {
                if (this.powerx < 0) {
                    this.power = null;
                    this.powerflag = true;
                }
                if (this.power != null) {
                    g.drawImage(this.power, this.powerx, this.powery, this.powerWH, this.powerWH);
                    this.powerx -= this.brickSpeed;
                    if (this.powerx < this.w / 2 && this.ispowerEaten()) {
                        this.powerGrantedFlag = true;
                        this.oldSpeed = this.brickSpeed;
                        this.oldBgSpeed = this.bgSpeed;
                        this.brickSpeed *= 3;
                        this.bgSpeed *= 4;
                        this.time = 1;
                        this.power = null;
                        this.powerflag = true;
                    }
                }
            }
            this.drawPlayer(g);
        }
        this.updateGameStatus();
        this.delay(this.time);
        this.repaint();
    }

    public int randomInRange(int limit) {
        int i = this.random.nextInt() % limit;
        if (i < 0) {
            return i + limit;
        }
        return i;
    }

    public void delay(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void makeSound(int note) {
        try {
            Manager.playTone((int)note, (int)100, (int)100);
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void pointerPressed(int x, int y) {
        System.out.println("Clicked ...");
        if (!this.gameoverflag) {
            this.moveUp = x > this.w / 2;
        } else {
            try {
                System.out.println("CLICK URL : " + this.v1.elementAt(1).toString());
                if (this.v1 != null) {
                    this.mainMidlet.platformRequest(this.v1.elementAt(1).toString());
                }
            }
            catch (ConnectionNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        this.clickFlag = true;
        this.repaint();
    }

    public void pointerReleased(int x, int y) {
        this.repaint();
    }

    public void pointerDragged(int x, int y) {
        this.playerLocationY = x < this.w / 2 ? ++this.playerLocationY : --this.playerLocationY;
        this.repaint();
    }

    private void loadScreen(Graphics g) {
        this.loadBackground = true;
    }

    private void updateScreen(Graphics g) {
        this.w = this.getWidth();
        this.h = this.getHeight();
        g.setColor(0);
        g.drawImage(this.bg, this.bgx, 0);
        this.bgx -= this.bgSpeed;
        if (this.bgx <= -1000 + this.w) {
            g.drawImage(this.bg, 1000 + this.bgx, 0);
        }
        if (this.bgx <= -1000) {
            this.bgx = 0;
        }
        if (this.gameoverflag) {
            return;
        }
        this.h75 = this.percentage(this.h, 75);
        g.setColor(65280);
        g.drawLine(0, this.h75, this.w, this.h75);
        g.drawLine(0, this.h75 + 2, this.w, this.h75 + 2);
        g.drawImage(this.down, 10, this.h75 + 4, this.percentage(this.w, 20), this.h75 / 3);
        g.drawImage(this.up, this.percentage(this.w, 80), this.h75 + 4, this.percentage(this.w, 20), this.h75 / 3);
        g.drawString("Score :" + this.score, this.percentage(this.w, 30), this.percentage(this.h, 77));
        g.drawString("Life  :" + this.life, this.percentage(this.w, 30), this.percentage(this.h, 84));
        g.drawString("Top   :" + this.highScore, this.percentage(this.w, 30), this.percentage(this.h, 91));
    }

    private int percentage(int w, int i) {
        return i * w / 100;
    }

    private void drawPlayer(Graphics g) {
        g.setColor(200);
        g.drawImage(this.sprite[this.spriteCounter], this.playerLocationX, this.playerLocationY, this.playerWidth, this.playerHeight);
        if (this.gapCount == 0) {
            ++this.spriteCounter;
            this.spriteCounter %= this.sprite.length;
        }
        ++this.gapCount;
        this.gapCount %= 5;
    }

    private void upDatePlayerLocation() {
        this.playerLocationY = this.moveUp ? (this.playerLocationY -= this.userSpeed) : (this.playerLocationY += this.userSpeed);
        if (this.playerLocationY < 10) {
            this.playerLocationY = 10;
        } else if (this.playerLocationY + this.playerHeight > this.percentage(this.h, 75)) {
            this.playerLocationY = this.percentage(this.h, 75) - this.playerHeight;
        }
    }

    private void showBricks(Graphics g) {
        g.setColor(0xFF0000);
        if (this.arr[0][0] <= 10) {
            this.swapToPreviousIndex(0);
            ++this.brickCrossed;
            this.score += this.level;
        }
        for (int i = 0; i < this.brickCount; ++i) {
            if (this.arr[i][0] == 0) continue;
            int[] nArray = this.arr[i];
            int n = nArray[0] - this.brickSpeed;
            nArray[0] = n;
            g.drawImage(this.ballImage, n, this.arr[i][1], this.brickDimensions[i][0], this.brickDimensions[i][1]);
        }
        System.out.println("Next Power At " + 10 * this.powerCount + " Speed " + this.brickSpeed + "   Time :" + this.time + "    BrickCount:" + this.brickCount + " Score :" + this.score + " target : " + this.targetBricksCross + " BrickCrossed :" + this.brickCrossed + " Life :" + this.life + "  Level :" + this.level + " Power Granted: " + this.powerGrantedFlag + " Power Counter : " + this.powerCounter);
    }

    private void fillBrickLocations(int i) {
        if (i != -1 && this.arr[i][0] == 0 && this.arr[i][1] == 0) {
            this.arr[i][0] = this.getWidth() + this.randomInRange(this.percentage(this.w, 75));
            this.arr[i][1] = this.randomInRange(this.brickCount) == 0 ? this.percentage(this.h, this.randomInRange(70)) : this.nearSuperman();
            this.brickDimensions[i][0] = this.percentage(this.w, 10);
            this.brickDimensions[i][1] = this.percentage(this.h, 10);
        }
    }

    private void swapToPreviousIndex(int i) {
        int j;
        for (j = i; j < this.brickCount; ++j) {
            this.arr[j %= 10][0] = this.arr[(j + 1) % 10][0];
            this.arr[j][1] = this.arr[(j + 1) % 10][1];
            this.brickDimensions[j][0] = this.brickDimensions[(j + 1) % 10][0];
            this.brickDimensions[j][1] = this.brickDimensions[(j + 1) % 10][1];
        }
        this.arr[j][0] = 0;
        this.arr[j][1] = 0;
        this.fillBrickLocations(j);
    }

    private boolean checkForCollison() {
        int playerMidHeight = this.playerLocationY + this.playerHeight / 2;
        int playerMidWidth = this.playerLocationX + this.playerWidth / 2;
        for (int i = 0; i < this.brickCount; ++i) {
            int brickMidHeight = this.arr[i][1] + this.brickDimensions[i][1] / 2;
            int heightDifference = playerMidHeight - brickMidHeight;
            int brickMidWidth = this.arr[i][0] + this.brickDimensions[i][0] / 2;
            int widthDifference = playerMidWidth - brickMidWidth;
            if ((heightDifference < 0 || heightDifference > this.playerHeight / 2) && (heightDifference > 0 || heightDifference * -1 > this.playerHeight / 2) || (widthDifference < 0 || widthDifference > this.playerWidth / 2) && (widthDifference >= 0 || widthDifference * -1 > this.playerWidth / 2)) continue;
            this.collisionWithBrickNumber = i;
            return true;
        }
        return false;
    }

    public void commandAction(Command c, Displayable d) {
    }

    private void initilizeVariables() {
        System.gc();
        this.random = new Random();
        this.loadBackground = false;
        this.playerLocationX = 0 - this.percentage(this.w, 25);
        this.playerLocationY = this.percentage(this.h, 40);
        this.playerWidth = this.percentage(this.w, 20);
        this.powerWH = this.playerHeight = this.percentage(this.h, 10);
        this.arr = new int[10][2];
        this.brickDimensions = new int[10][2];
        this.gameLevel = 7;
        this.clickFlag = false;
        this.moveUp = false;
        this.newBrick = true;
        this.brickCount = 3;
        this.fillBrickLocations(0);
        this.fillBrickLocations(1);
        this.fillBrickLocations(2);
        this.brickCrossed = 0;
        this.brickSpeed = 2;
        this.targetBricksCross = 10;
        this.life = 2;
    }

    private void gameLevel(int i) {
        if (this.brickSpeed < 6) {
            ++this.brickSpeed;
        } else if (this.time > 10) {
            this.time -= 3;
        } else if (this.brickSpeed >= 6 && this.brickSpeed < 10) {
            ++this.brickSpeed;
        }
        this.targetBricksCross = this.targetBricksCross + 5 * this.brickSpeed + (50 - this.time);
        this.score += i * 100;
        if (this.score > this.highScore) {
            new HighScore().upDateScore(this.score);
            this.highScore = this.score;
        }
        if (this.brickSpeed % 2 == 0 && this.userSpeed < 5) {
            ++this.userSpeed;
            ++this.bgSpeed;
        }
        if (this.brickCount < 8) {
            ++this.brickCount;
            this.fillBrickLocations(this.brickCount - 1);
        }
    }

    private void animationIsGoingOn(Graphics g) {
        this.updateScreen(g);
        if (this.playerLocationX < this.percentage(this.w, 5)) {
            ++this.playerLocationX;
        } else {
            this.animation = false;
        }
        this.drawPlayer(g);
    }

    private void gameSpeed() {
    }

    private void updateGameStatus() {
        if (this.brickCrossed > this.targetBricksCross) {
            this.levelCompleted = true;
        }
        if (this.life <= 0) {
            this.gameoverflag = true;
            try {
                this.gameMusic.stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
            if (this.score > this.highScore) {
                new HighScore().upDateScore(this.score);
            }
        }
    }

    private int nearSuperman() {
        return this.playerLocationY + this.randomInRange(this.playerHeight / 2);
    }

    private boolean ispowerEaten() {
        int playerMidHeight = this.playerLocationY + this.playerHeight / 2;
        int playerMidWidth = this.playerLocationX + this.playerWidth / 2;
        int brickMidHeight = this.powery + this.powerWH / 2;
        int heightDifference = playerMidHeight - brickMidHeight;
        int brickMidWidth = this.powerx + this.powerWH / 2;
        int widthDifference = playerMidWidth - brickMidWidth;
        return (heightDifference >= 0 && heightDifference <= this.playerHeight / 2 || heightDifference <= 0 && heightDifference * -1 <= this.playerHeight / 2) && (widthDifference >= 0 && widthDifference <= this.playerWidth / 2 || widthDifference < 0 && widthDifference * -1 <= this.playerWidth / 2);
    }
}

