/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.List;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class ComboBox
extends List {
    public static boolean defaultActAsSpinnerDialog;
    public boolean actAsSpinnerDialog = defaultActAsSpinnerDialog;
    public static boolean defaultIncludeSelectCancel;
    public boolean includeSelectCancel = defaultIncludeSelectCancel;

    public static boolean isDefaultActAsSpinnerDialog() {
        return defaultActAsSpinnerDialog;
    }

    public static void setDefaultActAsSpinnerDialog(boolean aDefaultActAsSpinnerDialog) {
        defaultActAsSpinnerDialog = aDefaultActAsSpinnerDialog;
    }

    public ComboBox(Vector items) {
        this(new DefaultListModel(items));
    }

    public ComboBox(Object[] items) {
        this(new DefaultListModel(items));
    }

    public ComboBox() {
        this(new DefaultListModel());
    }

    public ComboBox(ListModel model) {
        super(model);
        Component c;
        super.setUIID("ComboBox");
        ((DefaultListCellRenderer)super.getRenderer()).setShowNumbers(false);
        this.setInputOnFocus(false);
        this.setIsScrollVisible(false);
        this.setFixedSelection(1);
        ListCellRenderer r = this.getRenderer();
        if (r instanceof Component) {
            c = (Component)((Object)this.getRenderer());
            c.setUIID("ComboBoxItem");
        }
        if ((c = this.getRenderer().getListFocusComponent(this)) != null) {
            c.setUIID("ComboBoxFocus");
        }
    }

    public void setUIID(String uiid) {
        Component c;
        super.setUIID(uiid);
        ListCellRenderer r = this.getRenderer();
        if (r instanceof Component) {
            c = (Component)((Object)this.getRenderer());
            c.setUIID(uiid + "Item");
        }
        if ((c = this.getRenderer().getListFocusComponent(this)) != null) {
            c.setUIID(uiid + "Focus");
        }
    }

    public int getBaseline(int width, int height) {
        if (this.getRenderingPrototype() != null) {
            Component component = this.getRenderer().getListCellRendererComponent(this, this.getRenderingPrototype(), 0, true);
        }
        Component selected = this.getModel().getSize() > 0 ? this.getRenderer().getListCellRendererComponent(this, this.getModel().getItemAt(0), 0, true) : this.getRenderer().getListCellRendererComponent(this, "XXXXXXXXXXX", 0, true);
        return this.getHeight() - this.getStyle().getPadding(false, 2) - selected.getStyle().getPadding(false, 2);
    }

    protected void laidOut() {
    }

    protected Rectangle getVisibleBounds() {
        return this.getBounds();
    }

    public void setSelectedIndex(int selection) {
        super.setSelectedIndex(selection, false);
    }

    public void setSelectedIndex(int selection, boolean scroll) {
        super.setSelectedIndex(selection, false);
    }

    public void pointerHover(int[] x, int[] y) {
    }

    public void pointerHoverReleased(int[] x, int[] y) {
    }

    protected Dialog createPopupDialog(List l) {
        Dialog popupDialog = new Dialog(this.getUIID() + "Popup", this.getUIID() + "PopupTitle");
        popupDialog.setScrollable(false);
        popupDialog.getContentPane().setAlwaysTensile(false);
        popupDialog.setAlwaysTensile(false);
        popupDialog.getContentPane().setUIID("PopupContentPane");
        popupDialog.setDisposeWhenPointerOutOfBounds(true);
        popupDialog.setTransitionInAnimator(CommonTransitions.createEmpty());
        popupDialog.setTransitionOutAnimator(CommonTransitions.createEmpty());
        popupDialog.setLayout(new BorderLayout());
        popupDialog.addComponent("Center", (Component)l);
        return popupDialog;
    }

    protected Command showPopupDialog(Dialog popupDialog, List l) {
        if (UIManager.getInstance().isThemeConstant("popupTitleBool", false) && this.getLabelForComponent() != null) {
            popupDialog.setTitle(this.getLabelForComponent().getText());
        }
        if (this.includeSelectCancel) {
            popupDialog.setBackCommand(popupDialog.getMenuBar().getCancelMenuItem());
            if (Display.getInstance().isTouchScreenDevice()) {
                if (UIManager.getInstance().isThemeConstant("popupCancelBodyBool", false)) {
                    popupDialog.placeButtonCommands(new Command[]{popupDialog.getMenuBar().getCancelMenuItem()});
                }
            } else if (Display.getInstance().isThirdSoftButton()) {
                popupDialog.addCommand(popupDialog.getMenuBar().getSelectMenuItem());
                popupDialog.addCommand(popupDialog.getMenuBar().getCancelMenuItem());
            } else {
                popupDialog.addCommand(popupDialog.getMenuBar().getCancelMenuItem());
                popupDialog.addCommand(popupDialog.getMenuBar().getSelectMenuItem());
            }
        }
        if (this.actAsSpinnerDialog) {
            l.setFixedSelection(12);
            l.setUIID("Spinner");
            l.spinnerOverlay = UIManager.getInstance().getComponentStyle("SpinnerOverlay");
            l.spinnerOverlay.setMargin(0, 0, 0, 0);
            l.setAlwaysTensile(false);
            l.installDefaultPainter(l.spinnerOverlay);
            popupDialog.setDialogUIID("Container");
            popupDialog.setUIID("Container");
            popupDialog.getTitleComponent().setUIID("Container");
            popupDialog.setTransitionInAnimator(CommonTransitions.createSlide(1, true, 200));
            popupDialog.setTransitionOutAnimator(CommonTransitions.createSlide(1, false, 200));
            return popupDialog.show(Display.getInstance().getDisplayHeight() - popupDialog.getDialogComponent().getPreferredH(), 0, 0, 0, true, true);
        }
        if (UIManager.getInstance().isThemeConstant("centeredPopupBool", false)) {
            return popupDialog.showPacked("Center", true);
        }
        Form parentForm = this.getComponentForm();
        int listW = Math.max(this.getWidth(), l.getPreferredW());
        listW = Math.min(listW + UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth(), parentForm.getContentPane().getWidth());
        Container content = popupDialog.getDialogComponent();
        Style contentStyle = content.getStyle();
        int listH = content.getPreferredH() + contentStyle.getMargin(false, 0) + contentStyle.getMargin(false, 2);
        Container title = popupDialog.getTitleArea();
        listH += title.getPreferredH() + title.getStyle().getMargin(false, 0) + title.getStyle().getMargin(false, 2);
        int bottom = 0;
        int top = this.getAbsoluteY();
        int formHeight = parentForm.getHeight();
        if (parentForm.getSoftButtonCount() > 1) {
            Container c = parentForm.getSoftButton(0).getParent();
            formHeight -= c.getHeight();
            Style s = c.getStyle();
            formHeight -= s.getMargin(0) + s.getMargin(2);
        }
        if (listH < formHeight) {
            if (top > formHeight / 2) {
                bottom = formHeight - top;
                top -= listH;
            } else {
                bottom = formHeight - (top += this.getHeight()) - listH;
            }
        } else {
            top = 0;
        }
        int left = this.getAbsoluteX();
        int right = parentForm.getWidth() - left - listW;
        if (right < 0) {
            left += right;
            right = 0;
        }
        popupDialog.setBackCommand(popupDialog.getMenuBar().getCancelMenuItem());
        return popupDialog.show(Math.max(top, 0), Math.max(bottom, 0), Math.max(left, 0), Math.max(right, 0), false, true);
    }

    protected void fireClicked() {
        List l = this.createPopupList();
        l.dispatcher = this.dispatcher;
        l.eventSource = this;
        l.disposeDialogOnSelection = true;
        Form parentForm = this.getComponentForm();
        int tint = parentForm.getTintColor();
        parentForm.setTintColor(0);
        Dialog popupDialog = this.createPopupDialog(l);
        int originalSel = this.getSelectedIndex();
        Form.comboLock = this.includeSelectCancel;
        Command result = this.showPopupDialog(popupDialog, l);
        Form.comboLock = false;
        parentForm.setTintColor(tint);
        if (result == popupDialog.getMenuBar().getCancelMenuItem()) {
            this.setSelectedIndex(originalSel);
        }
    }

    protected List createPopupList() {
        List l = new List(this.getModel());
        l.setSmoothScrolling(this.isSmoothScrolling());
        l.setFixedSelection(this.getFixedSelection());
        l.setListCellRenderer(this.getRenderer());
        l.setItemGap(this.getItemGap());
        l.setUIID("ComboBoxList");
        if (UIManager.getInstance().isThemeConstant("otherPopupRendererBool", false)) {
            DefaultListCellRenderer renderer = new DefaultListCellRenderer();
            renderer.setUIID("PopupItem");
            renderer.getListFocusComponent(l).setUIID("PopupFocus");
            l.setListCellRenderer(renderer);
        }
        return l;
    }

    public void keyReleased(int keyCode) {
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (gameAction == 8) {
            this.fireClicked();
            return;
        }
        super.keyPressed(keyCode);
    }

    void selectElement(int selectedIndex) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (this.isEnabled()) {
            this.fireClicked();
        }
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawComboBox(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getComboBoxPreferredSize(this);
    }

    public int getOrientation() {
        return 2;
    }

    public boolean isIncludeSelectCancel() {
        return this.includeSelectCancel;
    }

    public void setIncludeSelectCancel(boolean includeSelectCancel) {
        this.includeSelectCancel = includeSelectCancel;
    }

    public static boolean isDefaultIncludeSelectCancel() {
        return defaultIncludeSelectCancel;
    }

    public static void setDefaultIncludeSelectCancel(boolean aDefaultIncludeSelectCancel) {
        defaultIncludeSelectCancel = aDefaultIncludeSelectCancel;
    }

    public boolean isActAsSpinnerDialog() {
        return this.actAsSpinnerDialog;
    }

    public void setActAsSpinnerDialog(boolean actAsSpinnerDialog) {
        this.actAsSpinnerDialog = actAsSpinnerDialog;
    }

    static {
        defaultIncludeSelectCancel = true;
    }
}

