/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;

public class M3G {
    public static final M3G INSTANCE = new M3G();
    public static final boolean IS_SUPPORTED;

    private M3G() {
    }

    public static M3G getInstance() {
        return INSTANCE;
    }

    public static boolean isM3GSupported() {
        return IS_SUPPORTED;
    }

    public int getMaxTextureDimension() {
        return (Integer)Graphics3D.getProperties().get("maxTextureDimension");
    }

    public static int closestLowerPowerOf2(int x) {
        return M3G.closestHigherPowerOf2(x) >> 1;
    }

    public static int closestHigherPowerOf2(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return ++x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderM3G(Graphics g, boolean depth, int arguments, Callback c) {
        Graphics3D g3d = Graphics3D.getInstance();
        g3d.bindTarget(g.getGraphics(), depth, arguments);
        try {
            c.paintM3G(g3d);
        }
        finally {
            g3d.releaseTarget();
        }
    }

    public Image2D createImage2D(int type, Image img) {
        if (img.getImage() == null) {
            Image im = Image.createImage(img.getWidth(), img.getHeight());
            im.getGraphics().drawImage(img, 0, 0);
            img = im;
        }
        return new Image2D(type, img.getImage());
    }

    static {
        boolean supported = false;
        try {
            Class.forName("javax.microedition.m3g.Graphics3D");
            supported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_SUPPORTED = supported;
    }

    public static interface Callback {
        public void paintM3G(Graphics3D var1);
    }
}

