/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;

public class Slider
extends Label {
    public int value;
    public int maxValue = 100;
    public int minValue = 0;
    public boolean vertical;
    public boolean editable;
    public EventDispatcher listeners = new EventDispatcher();
    public int increments = 4;
    public int previousX = -1;
    public int previousY = -1;
    public Style sliderFull;
    public Style sliderFullSelected;
    public boolean paintingFull;
    public boolean renderPercentageOnTop;
    public boolean renderValueOnTop;
    public boolean infinite = false;
    public float infiniteDirection = 0.03f;
    public Image thumbImage;

    public Slider() {
        this("Slider", "SliderFull");
    }

    private Slider(String uiid, String fullUIID) {
        this.setFocusable(false);
        this.setUIID(uiid);
        this.sliderFull = UIManager.getInstance().getComponentStyle(fullUIID);
        this.sliderFullSelected = UIManager.getInstance().getComponentSelectedStyle(fullUIID);
        this.initCustomStyle(this.sliderFull);
        this.initCustomStyle(this.sliderFullSelected);
        this.setAlignment(4);
    }

    public void setUIID(String id) {
        super.setUIID(id);
        this.sliderFull = UIManager.getInstance().getComponentStyle(id + "Full");
        this.sliderFullSelected = UIManager.getInstance().getComponentSelectedStyle(id + "Full");
        this.initCustomStyle(this.sliderFull);
        this.initCustomStyle(this.sliderFullSelected);
    }

    public void initComponent() {
        if (this.infinite) {
            this.getComponentForm().registerAnimatedInternal(this);
        }
    }

    public void deinitialize() {
        Form f;
        if (this.infinite && (f = this.getComponentForm()) != null) {
            f.deregisterAnimatedInternal(this);
        }
    }

    public boolean animate() {
        if (this.infinite) {
            super.animate();
            float f = this.infiniteDirection * (float)this.maxValue;
            if ((int)f == 0) {
                f = f < 0.0f ? -1.0f : 1.0f;
            }
            this.value += (int)f;
            if (this.value >= this.maxValue) {
                this.value = this.maxValue;
                this.infiniteDirection *= -1.0f;
            }
            if (this.value <= 0) {
                this.value = 0;
                this.infiniteDirection *= -1.0f;
            }
            return true;
        }
        return super.animate();
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void setInfinite(boolean i) {
        if (this.infinite != i) {
            this.infinite = i;
            if (this.isInitialized()) {
                if (i) {
                    this.getComponentForm().registerAnimatedInternal(this);
                } else {
                    this.getComponentForm().deregisterAnimatedInternal(this);
                }
            }
        }
    }

    public static Slider createInfinite() {
        Slider s = new Slider();
        s.infinite = true;
        return s;
    }

    public void refreshTheme() {
        super.refreshTheme();
        this.deinitializeCustomStyle(this.sliderFull);
        this.deinitializeCustomStyle(this.sliderFullSelected);
        this.sliderFull = UIManager.getInstance().getComponentStyle("SliderFull");
        this.sliderFullSelected = UIManager.getInstance().getComponentSelectedStyle("SliderFull");
    }

    public int getProgress() {
        return this.value;
    }

    public void setProgress(int value) {
        this.value = value;
        if (this.renderValueOnTop) {
            super.setText("" + value);
        } else if (this.renderPercentageOnTop) {
            super.setText(value + "%");
        } else {
            this.repaint();
        }
    }

    public Style getStyle() {
        if (this.paintingFull) {
            if (this.hasFocus()) {
                return this.sliderFullSelected;
            }
            return this.sliderFull;
        }
        return super.getStyle();
    }

    protected Dimension calcPreferredSize() {
        Style style = this.getStyle();
        int prefW = 0;
        int prefH = 0;
        if (style.getBorder() != null) {
            prefW = Math.max(style.getBorder().getMinimumWidth(), prefW);
            prefH = Math.max(style.getBorder().getMinimumHeight(), prefH);
        }
        if (Display.getInstance().isTouchScreenDevice() && this.isEditable()) {
            if (this.vertical) {
                return new Dimension(Math.max(prefW, Font.getDefaultFont().charWidth('X') * 2), Math.max(prefH, Display.getInstance().getDisplayHeight() / 2));
            }
            return new Dimension(Math.max(prefW, Display.getInstance().getDisplayWidth() / 2), Math.max(prefH, Font.getDefaultFont().getHeight() * 2));
        }
        if (this.vertical) {
            return new Dimension(Math.max(prefW, Font.getDefaultFont().charWidth('X')), Math.max(prefH, Display.getInstance().getDisplayHeight() / 2));
        }
        return new Dimension(Math.max(prefW, Display.getInstance().getDisplayWidth() / 2), Math.max(prefH, Font.getDefaultFont().getHeight()));
    }

    public void paintBackground(Graphics g) {
        super.paintBackground(g);
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int width = this.getWidth();
        int height = this.getHeight();
        int y = this.getY();
        if (this.infinite) {
            int blockSize = this.getWidth() / 5;
            int x = this.getX() + (int)((float)this.value / ((float)this.maxValue - (float)this.minValue) * (float)(this.getWidth() - blockSize));
            g.clipRect(x, y, blockSize, height - 1);
        } else {
            if (this.vertical) {
                int actualHeight = (int)((float)this.value / ((float)this.maxValue - (float)this.minValue) * (float)this.getHeight());
                y += height - actualHeight;
            } else {
                width = (int)((float)this.value / ((float)this.maxValue - (float)this.minValue) * (float)this.getWidth());
            }
            g.clipRect(this.getX(), y, width, height);
        }
        this.paintingFull = true;
        super.paintBackground(g);
        this.paintingFull = false;
        g.setClip(clipX, clipY, clipW, clipH);
        if (this.thumbImage != null && !this.infinite) {
            if (!this.vertical) {
                int xPos = this.getX() + width - this.thumbImage.getWidth() / 2;
                xPos = Math.max(this.getX(), xPos);
                xPos = Math.min(this.getX() + this.getWidth() - this.thumbImage.getWidth(), xPos);
                g.drawImage(this.thumbImage, xPos, y + height / 2 - this.thumbImage.getHeight() / 2);
            } else {
                int yPos = y + height - this.thumbImage.getHeight() / 2;
                yPos = Math.max(this.getY(), yPos);
                yPos = Math.min(this.getY() + this.getHeight() - this.thumbImage.getHeight(), yPos);
                g.drawImage(this.thumbImage, this.getX() + width / 2 - this.thumbImage.getWidth() / 2, yPos);
            }
        }
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.setFocusable(editable);
    }

    public void pointerPressed(int x, int y) {
        if (!this.editable) {
            return;
        }
        if (this.vertical) {
            y = Math.abs(this.getHeight() - (y - this.getAbsoluteY()));
            this.setProgress((byte)Math.min(100.0f, (float)y / (float)this.getHeight() * 100.0f));
        } else {
            x = Math.abs(x - this.getAbsoluteX());
            this.setProgress((byte)Math.min(100.0f, (float)x / (float)this.getWidth() * 100.0f));
        }
        if (this.vertical) {
            if (this.previousY < y) {
                this.fireDataChanged(1, this.value);
            } else {
                this.fireDataChanged(0, this.value);
            }
            this.previousY = y;
        } else {
            if (this.previousX < x) {
                this.fireDataChanged(1, this.value);
            } else {
                this.fireDataChanged(0, this.value);
            }
            this.previousX = x;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.editable) {
            return;
        }
        if (this.vertical && this.previousY == -1) {
            this.previousY = y;
            return;
        }
        if (!this.vertical && this.previousX == -1) {
            this.previousX = x;
            return;
        }
        byte per = 0;
        if (this.vertical) {
            y = Math.abs(this.getHeight() - (y - this.getAbsoluteY()));
            per = (byte)Math.min(100.0f, (float)y / (float)this.getHeight() * 100.0f);
        } else {
            x = Math.abs(x - this.getAbsoluteX());
            per = (byte)Math.min(100.0f, (float)x / (float)this.getWidth() * 100.0f);
        }
        if (per != this.getProgress()) {
            this.setProgress(per);
            if (this.vertical) {
                if (this.previousY < y) {
                    this.fireDataChanged(1, this.value);
                } else {
                    this.fireDataChanged(0, this.value);
                }
                this.previousY = y;
            } else {
                if (this.previousX < x) {
                    this.fireDataChanged(1, this.value);
                } else {
                    this.fireDataChanged(0, this.value);
                }
                this.previousX = x;
            }
        }
    }

    protected void fireClicked() {
        this.setHandlesInput(!this.handlesInput());
    }

    protected boolean isSelectableInteraction() {
        return this.editable;
    }

    public void pointerReleased(int x, int y) {
        if (!this.editable) {
            return;
        }
        this.previousX = -1;
        this.previousY = -1;
    }

    public void keyPressed(int code) {
        if (this.editable && this.handlesInput()) {
            int game = Display.getInstance().getGameAction(code);
            switch (game) {
                case 1: {
                    if (this.vertical) {
                        this.setProgress((byte)Math.min(this.maxValue, this.value + this.increments));
                        this.fireDataChanged(1, this.value);
                        break;
                    }
                    this.setHandlesInput(false);
                    break;
                }
                case 6: {
                    if (this.vertical) {
                        this.setProgress((byte)Math.max(this.minValue, this.value - this.increments));
                        this.fireDataChanged(0, this.value);
                        break;
                    }
                    this.setHandlesInput(false);
                    break;
                }
                case 2: {
                    if (!this.vertical) {
                        this.setProgress((byte)Math.max(this.minValue, this.value - this.increments));
                        this.fireDataChanged(0, this.value);
                        break;
                    }
                    this.setHandlesInput(false);
                    break;
                }
                case 5: {
                    if (!this.vertical) {
                        this.setProgress((byte)Math.min(this.maxValue, this.value + this.increments));
                        this.fireDataChanged(1, this.value);
                        break;
                    }
                    this.setHandlesInput(false);
                    break;
                }
                case 8: {
                    if (Display.getInstance().isThirdSoftButton()) break;
                    this.fireClicked();
                }
            }
        } else if (!Display.getInstance().isThirdSoftButton() && Display.getInstance().getGameAction(code) == 8) {
            this.fireClicked();
        }
        super.keyPressed(code);
    }

    public int getIncrements() {
        return this.increments;
    }

    public void setIncrements(int increments) {
        this.increments = increments;
    }

    private void fireDataChanged(int event, int val) {
        this.listeners.fireDataChangeEvent(val, event);
    }

    public void addDataChangedListener(DataChangedListener l) {
        this.listeners.addListener(l);
    }

    public void removeDataChangedListener(DataChangedListener l) {
        this.listeners.removeListener(l);
    }

    public boolean isRenderPercentageOnTop() {
        return this.renderPercentageOnTop;
    }

    public void setRenderPercentageOnTop(boolean renderPercentageOnTop) {
        this.renderPercentageOnTop = renderPercentageOnTop;
    }

    public boolean isRenderValueOnTop() {
        return this.renderValueOnTop;
    }

    public void setRenderValueOnTop(boolean renderValueOnTop) {
        this.renderValueOnTop = renderValueOnTop;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public Image getThumbImage() {
        return this.thumbImage;
    }

    public void setThumbImage(Image thumbImage) {
        this.thumbImage = thumbImage;
    }

    boolean shouldBlockSideSwipe() {
        return !this.vertical;
    }
}

