/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.List;
import com.sun.lwuit.Painter;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class TabbedPane
extends Container {
    public Transition transitionRight;
    public Transition transitionLeft;
    public Container contentPane = new Container(new BorderLayout());
    public List tabsList = new List();
    public Hashtable tabsTable = new Hashtable();
    public int tabPlacement = -1;
    public int tPBorder = 1;
    public int lastListX;
    public int lastListY;

    public TabbedPane() {
        this(0);
    }

    public TabbedPane(int tabPlacement) {
        super(new BorderLayout());
        this.contentPane.setUIID("TabbedPane");
        this.contentPane.getStyle().setBgPainter(new Painter(){

            public void paint(Graphics g, Rectangle rect) {
                UIManager.getInstance().getLookAndFeel().drawTabbedPaneContentPane(TabbedPane.this, g, rect, TabbedPane.this.tabsList.getPreferredSize(), TabbedPane.this.tabsList.size(), TabbedPane.this.tabsList.getSelectedIndex(), TabbedPane.this.tabsList.getElementSize(true, true), TabbedPane.this.tabsList.getScrollX(), TabbedPane.this.tabsList.getScrollY());
            }
        });
        super.addComponent("Center", (Component)this.contentPane);
        this.setTabPlacement(tabPlacement);
        this.tabsList.getUnselectedStyle().setPadding(0, 0, 0, 0);
        this.tabsList.getUnselectedStyle().setMargin(0, 0, 0, 0);
        this.tabsList.getUnselectedStyle().setBorder(null);
        this.tabsList.getSelectedStyle().setPadding(0, 0, 0, 0);
        this.tabsList.getSelectedStyle().setMargin(0, 0, 0, 0);
        this.tabsList.getSelectedStyle().setBorder(null);
        this.tabsList.setListCellRenderer(new TabsRenderer());
        this.tabsList.setItemGap(0);
        this.tabsList.setIsScrollVisible(false);
        this.tabsList.addSelectionListener(new SelectionListener(){

            public void selectionChanged(int oldSelected, int newSelected) {
                if (oldSelected == newSelected) {
                    return;
                }
                Component c = (Component)TabbedPane.this.tabsList.getModel().getItemAt(newSelected);
                Transition t = TabbedPane.this.transitionLeft;
                if (oldSelected < newSelected) {
                    t = TabbedPane.this.transitionRight;
                }
                if (c != null) {
                    if (t == null || TabbedPane.this.contentPane.getComponentCount() == 0) {
                        TabbedPane.this.contentPane.removeAll();
                        TabbedPane.this.contentPane.addComponent("Center", (Component)TabbedPane.this.tabsTable.get(c));
                        if (TabbedPane.this.isInitialized()) {
                            TabbedPane.this.revalidate();
                        } else {
                            TabbedPane.this.setShouldCalcPreferredSize(true);
                        }
                    } else {
                        TabbedPane.this.contentPane.flushReplace();
                        TabbedPane.this.contentPane.replace(TabbedPane.this.contentPane.getComponentAt(0), (Component)TabbedPane.this.tabsTable.get(c), t);
                    }
                }
            }
        });
    }

    public boolean animate() {
        boolean b = super.animate();
        int x = this.tabsList.getScrollX();
        int y = this.tabsList.getScrollY();
        if (this.lastListY != y || this.lastListX != x) {
            b = true;
            this.lastListX = x;
            this.lastListY = y;
        }
        return b;
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.getComponentForm().registerAnimatedInternal(this);
    }

    public void setTransitionLeft(Transition transitionLeft) {
        this.transitionLeft = transitionLeft;
    }

    public Transition getTransitionLeft() {
        return this.transitionLeft;
    }

    public void setTransitionRight(Transition transitionRight) {
        this.transitionRight = transitionRight;
    }

    public Transition getTransitionRight() {
        return this.transitionRight;
    }

    public void setFocusable(boolean b) {
        if (this.tabsList != null) {
            this.tabsList.setFocusable(b);
        }
        super.setFocusable(b);
    }

    public void setFocus(boolean b) {
        if (this.tabsList != null) {
            this.tabsList.setFocus(b);
        }
    }

    public boolean hasFocus() {
        if (this.tabsList != null) {
            return this.tabsList.hasFocus();
        }
        return super.hasFocus();
    }

    public void addTabsListener(SelectionListener listener) {
        this.tabsList.addSelectionListener(listener);
    }

    public void requestFocus() {
        this.tabsList.requestFocus();
    }

    protected Dimension calcPreferredSize() {
        int maxContentW = 0;
        int maxContentH = 0;
        int maxW = 0;
        int maxH = 0;
        for (int i = 0; i < this.tabsList.size(); ++i) {
            Component tabsComp = (Component)this.tabsList.getModel().getItemAt(i);
            Component contentComp = (Component)this.tabsTable.get(tabsComp);
            if (contentComp.getPreferredW() > maxContentW) {
                maxContentW = contentComp.getPreferredW();
            }
            if (contentComp.getPreferredH() <= maxContentH) continue;
            maxContentH = contentComp.getPreferredH();
        }
        if (this.tabPlacement == 0 || this.tabPlacement == 2) {
            maxW = maxContentW;
            maxH = this.tabsList.getPreferredH() + maxContentH;
        } else {
            maxW = this.tabsList.getPreferredW() + maxContentW;
            maxH = maxContentH;
        }
        return new Dimension(maxW, maxH);
    }

    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement != 0 && tabPlacement != 1 && tabPlacement != 2 && tabPlacement != 3) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement == tabPlacement) {
            return;
        }
        this.tabPlacement = tabPlacement;
        this.removeComponent(this.tabsList);
        if (tabPlacement == 0 || tabPlacement == 2) {
            this.tabsList.setOrientation(1);
            if (tabPlacement == 0) {
                super.addComponent("North", (Component)this.tabsList);
            } else if (tabPlacement == 2) {
                super.addComponent("South", (Component)this.tabsList);
            }
        } else {
            this.tabsList.setOrientation(0);
            if (tabPlacement == 1) {
                super.addComponent("West", (Component)this.tabsList);
            } else {
                super.addComponent("East", (Component)this.tabsList);
            }
        }
        this.tabsList.setShouldCalcPreferredSize(true);
        this.contentPane.setShouldCalcPreferredSize(true);
        this.revalidate();
    }

    public void addTab(String title, Image icon, Component component) {
        this.insertTab(title, icon, component, this.tabsList.size());
    }

    public void addTab(String title, Component component) {
        this.insertTab(title, null, component, this.tabsList.size());
    }

    public void insertTab(String title, Image icon, Component component, int index) {
        this.checkIndex(index);
        if (component == null) {
            return;
        }
        Button b = new Button(title != null ? title : "", icon);
        ((DefaultListModel)this.tabsList.getModel()).addItemAtIndex(b, index);
        this.tabsTable.put(b, component);
        if (this.tabsList.size() == 1) {
            this.contentPane.addComponent("Center", component);
        }
    }

    public void setTabTitle(String title, Image icon, int index) {
        this.checkIndex(index);
        Button b = (Button)this.tabsList.getModel().getItemAt(index);
        b.setText(title);
        b.setIcon(icon);
        ((DefaultListModel)this.tabsList.getModel()).setItem(index, b);
    }

    public void removeTabAt(int index) {
        this.checkIndex(index);
        Object key = this.tabsList.getModel().getItemAt(index);
        ((DefaultListModel)this.tabsList.getModel()).removeItem(index);
        this.tabsTable.remove(key);
    }

    public Component getTabComponentAt(int index) {
        this.checkIndex(index);
        return (Component)this.tabsTable.get((Component)this.tabsList.getModel().getItemAt(index));
    }

    private void checkIndex(int index) {
        if (index < 0 || index > this.tabsList.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    public int indexOfComponent(Component component) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component c = (Component)this.tabsList.getModel().getItemAt(i);
            Component content = (Component)this.tabsTable.get(c);
            if (!component.equals(content)) continue;
            return i;
        }
        return -1;
    }

    public int getTabCount() {
        return this.tabsList.size();
    }

    public int getSelectedIndex() {
        return this.tabsList.getSelectedIndex();
    }

    public void setTabTitlePrototype(String title) {
        this.tabsList.setRenderingPrototype(title);
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return className + "[x=" + this.getX() + " y=" + this.getY() + " width=" + this.getWidth() + " height=" + this.getHeight() + ", tab placement = " + this.tabPlacement + ", tab count = " + this.getTabCount() + ", selected index = " + this.getSelectedIndex() + "]";
    }

    public void paint(Graphics g) {
        super.paint(g);
        UIManager.getInstance().getLookAndFeel().drawTabbedPane(g, this);
    }

    public void setTabsSelectedStyle(Style style) {
        this.tabsList.setSelectedStyle(style);
    }

    public void setTabsUnselectedStyle(Style unselectedStyle) {
        this.tabsList.setUnselectedStyle(unselectedStyle);
    }

    public void setContentPaneSelectedStyle(Style style) {
        this.contentPane.setSelectedStyle(style);
    }

    public void setContentPaneUnselectedStyle(Style unselectedStyle) {
        this.contentPane.setUnselectedStyle(unselectedStyle);
    }

    public void refreshTheme() {
        Painter p = this.contentPane.getStyle().getBgPainter();
        super.refreshTheme();
        this.contentPane.getStyle().setBgPainter(p);
        Enumeration e = this.tabsTable.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            c.refreshTheme();
        }
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public int getTabbedPaneBorderWidth() {
        return this.tPBorder;
    }

    public void setTabbedPaneBorderWidth(int tabbedPaneBorderWidth) {
        this.tPBorder = tabbedPaneBorderWidth;
    }

    public void setPadding(int top, int bottom, int left, int right) {
        if (this.contentPane != null) {
            this.contentPane.getStyle().setPadding(top, bottom, left, right);
        }
    }

    public void setPadding(int orientation, int gap) {
        if (this.contentPane != null) {
            this.contentPane.getStyle().setPadding(orientation, gap);
        }
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.tabsList.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Tab count: " + this.tabsList.size());
        }
        this.tabsList.setSelectedIndex(index);
    }

    class TabsRenderer
    implements ListCellRenderer {
        TabsRenderer() {
        }

        public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
            if (value == null || !(value instanceof Button)) {
                value = new Button("" + value);
            }
            return UIManager.getInstance().getLookAndFeel().getTabbedPaneCell(TabbedPane.this, ((Button)value).getText(), ((Button)value).getIcon(), isSelected, list.hasFocus(), list.getStyle(), list.getSelectedStyle(), TabbedPane.this.getStyle(), list.getScrollX(), list.getScrollY(), list.getPreferredSize(), TabbedPane.this.contentPane.getBounds().getSize());
        }

        public Component getListFocusComponent(List list) {
            return null;
        }
    }
}

