/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;

public class Tabs
extends Container {
    public Container contentPane = new Container(new TabsLayout());
    public int tabPlacement = -1;
    public Container tabsContainer;
    public ButtonGroup radioGroup = new ButtonGroup();
    public Button selectedTab;
    public boolean swipeActivated = true;
    public ActionListener press;
    public ActionListener drag;
    public ActionListener release;
    public Motion slideToDestMotion;
    public int initialX = -1;
    public int initialY = -1;
    public int lastX = -1;
    public boolean dragStarted = false;
    public int activeComponent = 0;
    public EventDispatcher focusListeners;
    public TabFocusListener focusListener = new TabFocusListener();
    public boolean tabsFillRows;
    public boolean tabsGridLayout;
    public int textPosition = -1;
    public boolean changeTabOnFocus;
    public boolean changeTabContainerStyleOnFocus;
    public Style originalTabsContainerUnselected;
    public Style originalTabsContainerSelected;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Lcom$sun$lwuit$Image;

    public Tabs() {
        this(UIManager.getInstance().getThemeConstant("tabPlacementInt", 0));
    }

    public Tabs(int tabPlacement) {
        super(new BorderLayout());
        this.contentPane.setUIID("TabbedPane");
        super.addComponent("Center", (Component)this.contentPane);
        this.tabsContainer = new Container();
        this.tabsContainer.setUIID("TabsContainer");
        this.tabsContainer.setScrollVisible(false);
        this.tabsContainer.getStyle().setMargin(0, 0, 0, 0);
        this.tabsFillRows = UIManager.getInstance().isThemeConstant("tabsFillRowsBool", false);
        this.tabsGridLayout = UIManager.getInstance().isThemeConstant("tabsGridBool", false);
        this.changeTabOnFocus = UIManager.getInstance().isThemeConstant("changeTabOnFocusBool", false);
        this.changeTabContainerStyleOnFocus = UIManager.getInstance().isThemeConstant("changeTabContainerStyleOnFocusBool", false);
        ((FlowLayout)this.tabsContainer.getLayout()).setFillRows(this.tabsFillRows);
        this.setTabPlacement(tabPlacement);
        this.press = new SwipeListener(0);
        this.drag = new SwipeListener(1);
        this.release = new SwipeListener(2);
        this.setUIID("Tabs");
    }

    void initComponentImpl() {
        Component f;
        super.initComponentImpl();
        this.getComponentForm().registerAnimatedInternal(this);
        if (this.changeTabContainerStyleOnFocus && Display.getInstance().shouldRenderSelection() && (f = this.getComponentForm().getFocused()) != null && f.getParent() == this.tabsContainer) {
            this.initTabsContainerStyle();
            this.tabsContainer.setUnselectedStyle(this.originalTabsContainerSelected);
            this.tabsContainer.repaint();
        }
    }

    public void refreshTheme() {
        super.refreshTheme();
        this.originalTabsContainerSelected = null;
        this.originalTabsContainerUnselected = null;
    }

    protected void deinitialize() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.removePointerPressedListener(this.press);
            form.removePointerReleasedListener(this.release);
            form.removePointerDraggedListener(this.drag);
        }
        super.deinitialize();
    }

    protected void initComponent() {
        super.initComponent();
        Form form = this.getComponentForm();
        if (form != null && this.swipeActivated) {
            form.addPointerPressedListener(this.press);
            form.addPointerReleasedListener(this.release);
            form.addPointerDraggedListener(this.drag);
        }
    }

    public boolean animate() {
        boolean b = super.animate();
        if (this.slideToDestMotion != null && this.swipeActivated) {
            int i;
            int motionX = this.slideToDestMotion.getValue();
            int size = this.contentPane.getComponentCount();
            for (i = 0; i < size; ++i) {
                int xOffset;
                if (this.isRTL()) {
                    xOffset = (size - i) * this.contentPane.getWidth();
                    xOffset -= (size - this.activeComponent) * this.contentPane.getWidth();
                } else {
                    xOffset = i * this.contentPane.getWidth();
                    xOffset -= this.activeComponent * this.contentPane.getWidth();
                }
                Component component = this.contentPane.getComponentAt(i);
                component.setX(xOffset += motionX);
            }
            if (this.slideToDestMotion.isFinished()) {
                for (i = 0; i < this.contentPane.getComponentCount(); ++i) {
                    Component component = this.contentPane.getComponentAt(i);
                    component.paintLockRelease();
                }
                this.slideToDestMotion = null;
                this.deregisterAnimatedInternal();
                this.setSelectedIndex(this.activeComponent);
            }
            return true;
        }
        return b;
    }

    void deregisterAnimatedInternal() {
        Form f;
        if ((this.slideToDestMotion == null || this.slideToDestMotion.isFinished()) && (f = this.getComponentForm()) != null) {
            f.deregisterAnimatedInternal(this);
        }
    }

    public void setTabTextPosition(int textPosition) {
        if (textPosition != 1 && textPosition != 3 && textPosition != 2 && textPosition != 0) {
            throw new IllegalArgumentException("Text position can't be set to " + textPosition);
        }
        this.textPosition = textPosition;
        for (int iter = 0; iter < this.getTabCount(); ++iter) {
            Button b = (Button)this.tabsContainer.getComponentAt(iter);
            b.setTextPosition(textPosition);
        }
    }

    public int getTabTextPosition() {
        return this.textPosition;
    }

    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement != 0 && tabPlacement != 1 && tabPlacement != 2 && tabPlacement != 3) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement == tabPlacement) {
            return;
        }
        this.tabPlacement = tabPlacement;
        this.removeComponent(this.tabsContainer);
        if (tabPlacement == 0 || tabPlacement == 2) {
            if (this.tabsFillRows) {
                FlowLayout f = new FlowLayout();
                f.setFillRows(true);
                this.tabsContainer.setLayout(f);
            } else if (this.tabsGridLayout) {
                this.tabsContainer.setLayout(new GridLayout(1, Math.max(1, this.getTabCount())));
            } else {
                this.tabsContainer.setLayout(new BoxLayout(1));
            }
            this.tabsContainer.setScrollableX(true);
            this.tabsContainer.setScrollableY(false);
            if (tabPlacement == 0) {
                super.addComponent("North", (Component)this.tabsContainer);
            } else if (tabPlacement == 2) {
                super.addComponent("South", (Component)this.tabsContainer);
            }
        } else {
            this.tabsContainer.setLayout(new BoxLayout(2));
            this.tabsContainer.setScrollableX(false);
            this.tabsContainer.setScrollableY(true);
            if (tabPlacement == 1) {
                super.addComponent("West", (Component)this.tabsContainer);
            } else {
                super.addComponent("East", (Component)this.tabsContainer);
            }
        }
        this.initTabsFocus();
        this.tabsContainer.setShouldCalcPreferredSize(true);
        this.contentPane.setShouldCalcPreferredSize(true);
        this.revalidate();
    }

    public void addTab(String title, Image icon, Component component) {
        this.insertTab(title, icon, component, this.tabsContainer.getComponentCount());
    }

    public void addTab(String title, Component component) {
        this.insertTab(title, null, component, this.tabsContainer.getComponentCount());
    }

    public void addTab(Button tab, Component component) {
        this.insertTab(tab, component, this.tabsContainer.getComponentCount());
    }

    public void insertTab(String title, Image icon, Component component, int index) {
        RadioButton b = new RadioButton(title != null ? title : "", icon);
        b.setToggle(true);
        this.radioGroup.add(b);
        b.setTextPosition(2);
        if (this.radioGroup.getButtonCount() == 1) {
            b.setSelected(true);
        }
        if (this.textPosition != -1) {
            b.setTextPosition(this.textPosition);
        }
        this.insertTab(b, component, index);
    }

    public void insertTab(Button tab, Component component, int index) {
        Image d;
        this.checkIndex(index);
        if (component == null) {
            return;
        }
        final Button b = tab;
        b.setUIID("Tab");
        if (b.getIcon() == null && (d = UIManager.getInstance().getThemeImageConstant("TabUnselectedImage")) != null) {
            b.setIcon(d);
            d = UIManager.getInstance().getThemeImageConstant("TabSelectedImage");
            if (d != null) {
                b.setRolloverIcon(d);
                b.setPressedIcon(d);
            }
        }
        b.addFocusListener(this.focusListener);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (Tabs.this.selectedTab != null) {
                    Component previousContent;
                    Tabs.this.selectedTab.setUIID("Tab");
                    Tabs.this.selectedTab.setShouldCalcPreferredSize(true);
                    Tabs.this.selectedTab.repaint();
                    int previousSelectedIndex = Tabs.this.tabsContainer.getComponentIndex(Tabs.this.selectedTab);
                    if (previousSelectedIndex != -1 && (previousContent = Tabs.this.contentPane.getComponentAt(previousSelectedIndex)) instanceof Container) {
                        ((Container)previousContent).setBlockFocus(true);
                    }
                }
                Tabs.this.activeComponent = Tabs.this.tabsContainer.getComponentIndex(b);
                Component content = Tabs.this.contentPane.getComponentAt(Tabs.this.activeComponent);
                if (content instanceof Container) {
                    ((Container)content).setBlockFocus(false);
                }
                Tabs.this.initTabsFocus();
                Tabs.this.selectedTab = b;
                Tabs.this.selectedTab.setShouldCalcPreferredSize(true);
                Tabs.this.tabsContainer.revalidate();
                Tabs.this.tabsContainer.scrollComponentToVisible(Tabs.this.selectedTab);
                Tabs.this.contentPane.revalidate();
            }
        });
        if (component instanceof Container) {
            ((Container)component).setBlockFocus(true);
        }
        this.tabsContainer.addComponent(index, (Component)b);
        this.contentPane.addComponent(index, component);
        if (this.tabsGridLayout) {
            this.tabsContainer.setLayout(new GridLayout(1, Math.max(1, this.getTabCount())));
        }
        if (this.tabsContainer.getComponentCount() == 1) {
            this.selectedTab = (Button)this.tabsContainer.getComponentAt(0);
            if (component instanceof Container) {
                ((Container)component).setBlockFocus(false);
            }
            this.initTabsFocus();
        }
    }

    public void setTabTitle(String title, Image icon, int index) {
        this.checkIndex(index);
        Button b = (Button)this.tabsContainer.getComponentAt(index);
        b.setText(title);
        b.setIcon(icon);
    }

    public String getTabTitle(int index) {
        this.checkIndex(index);
        return ((Button)this.tabsContainer.getComponentAt(index)).getText();
    }

    public Image getTabIcon(int index) {
        this.checkIndex(index);
        return ((Button)this.tabsContainer.getComponentAt(index)).getIcon();
    }

    public Image getTabSelectedIcon(int index) {
        this.checkIndex(index);
        return ((Button)this.tabsContainer.getComponentAt(index)).getPressedIcon();
    }

    public void setTabSelectedIcon(int index, Image icon) {
        this.checkIndex(index);
        ((Button)this.tabsContainer.getComponentAt(index)).setPressedIcon(icon);
    }

    public void removeTabAt(int index) {
        this.checkIndex(index);
        Component key = this.tabsContainer.getComponentAt(index);
        this.tabsContainer.removeComponent(key);
        Component content = this.contentPane.getComponentAt(index);
        this.contentPane.removeComponent(content);
        if (this.tabsGridLayout) {
            this.tabsContainer.setLayout(new GridLayout(1, Math.max(1, this.getTabCount())));
        }
    }

    public Component getTabComponentAt(int index) {
        this.checkIndex(index);
        return this.contentPane.getComponentAt(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index > this.tabsContainer.getComponentCount()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    public int indexOfComponent(Component component) {
        return this.contentPane.getComponentIndex(component);
    }

    public int getTabCount() {
        return this.tabsContainer.getComponentCount();
    }

    public int getSelectedIndex() {
        if (this.tabsContainer != null) {
            return this.activeComponent;
        }
        return -1;
    }

    public Component getSelectedComponent() {
        int i = this.getSelectedIndex();
        if (i == -1) {
            return null;
        }
        return this.getTabComponentAt(i);
    }

    public void addTabsFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new EventDispatcher();
        }
        this.focusListeners.addListener(listener);
    }

    public void removeTabsFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.removeListener(listener);
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return className + "[x=" + this.getX() + " y=" + this.getY() + " width=" + this.getWidth() + " height=" + this.getHeight() + ", tab placement = " + this.tabPlacement + ", tab count = " + this.getTabCount() + ", selected index = " + this.getSelectedIndex() + "]";
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Container getTabsContainer() {
        return this.tabsContainer;
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.tabsContainer.getComponentCount()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Tab count: " + this.tabsContainer.getComponentCount());
        }
        Button b = (Button)this.tabsContainer.getComponentAt(index);
        b.fireClicked();
    }

    public void hideTabs() {
        this.removeComponent(this.tabsContainer);
        this.revalidate();
    }

    public void showTabs() {
        int tp = this.tabPlacement;
        this.tabPlacement = -1;
        this.setTabPlacement(tp);
        this.revalidate();
    }

    public boolean isSwipeActivated() {
        return this.swipeActivated;
    }

    public void setSwipeActivated(boolean swipeActivated) {
        this.swipeActivated = swipeActivated;
    }

    private void initTabsFocus() {
        for (int i = 0; i < this.tabsContainer.getComponentCount(); ++i) {
            this.initTabFocus(this.tabsContainer.getComponentAt(i), this.contentPane.getComponentAt(this.activeComponent));
        }
    }

    private void initTabFocus(Component tab, Component content) {
        Component focus = null;
        if (content.isFocusable()) {
            focus = content;
        }
        if (content instanceof Container) {
            focus = ((Container)content).findFirstFocusable();
        }
    }

    public boolean isChangeTabOnFocus() {
        return this.changeTabOnFocus;
    }

    public void setChangeTabOnFocus(boolean changeTabOnFocus) {
        this.changeTabOnFocus = changeTabOnFocus;
    }

    public boolean isChangeTabContainerStyleOnFocus() {
        return this.changeTabContainerStyleOnFocus;
    }

    public void setChangeTabContainerStyleOnFocus(boolean changeTabContainerStyleOnFocus) {
        this.changeTabContainerStyleOnFocus = changeTabContainerStyleOnFocus;
    }

    void initTabsContainerStyle() {
        if (this.originalTabsContainerSelected == null) {
            this.originalTabsContainerSelected = this.tabsContainer.getSelectedStyle();
            this.originalTabsContainerUnselected = this.tabsContainer.getUnselectedStyle();
        }
    }

    public String[] getPropertyNames() {
        return new String[]{"titles", "icons", "selectedIcons"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = Tabs.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Lcom$sun$lwuit$Image == null ? (array$Lcom$sun$lwuit$Image = Tabs.class$("[Lcom.sun.lwuit.Image;")) : array$Lcom$sun$lwuit$Image, array$Lcom$sun$lwuit$Image == null ? (array$Lcom$sun$lwuit$Image = Tabs.class$("[Lcom.sun.lwuit.Image;")) : array$Lcom$sun$lwuit$Image};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("titles")) {
            String[] t = new String[this.getTabCount()];
            for (int iter = 0; iter < t.length; ++iter) {
                t[iter] = this.getTabTitle(iter);
            }
            return t;
        }
        if (name.equals("icons")) {
            Image[] t = new Image[this.getTabCount()];
            for (int iter = 0; iter < t.length; ++iter) {
                t[iter] = this.getTabIcon(iter);
            }
            return t;
        }
        if (name.equals("selectedIcons")) {
            Image[] t = new Image[this.getTabCount()];
            for (int iter = 0; iter < t.length; ++iter) {
                t[iter] = this.getTabSelectedIcon(iter);
            }
            return t;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("titles")) {
            String[] t = (String[])value;
            for (int iter = 0; iter < Math.min(this.getTabCount(), t.length); ++iter) {
                this.setTabTitle(t[iter], this.getTabIcon(iter), iter);
            }
            return null;
        }
        if (name.equals("icons")) {
            Image[] t = (Image[])value;
            for (int iter = 0; iter < Math.min(this.getTabCount(), t.length); ++iter) {
                this.setTabTitle(this.getTabTitle(iter), t[iter], iter);
            }
            return null;
        }
        if (name.equals("selectedIcons")) {
            Image[] t = (Image[])value;
            for (int iter = 0; iter < Math.min(this.getTabCount(), t.length); ++iter) {
                this.setTabSelectedIcon(iter, t[iter]);
            }
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SwipeListener
    implements ActionListener {
        public static final int PRESS = 0;
        public static final int DRAG = 1;
        public static final int RELEASE = 2;
        public final int type;
        public boolean blockSwipe;
        public boolean riskySwipe;

        SwipeListener(int type) {
            this.type = type;
        }

        public void actionPerformed(ActionEvent evt) {
            if (Tabs.this.getComponentCount() == 0 || !Tabs.this.swipeActivated || Tabs.this.animate()) {
                return;
            }
            int x = evt.getX();
            int y = evt.getY();
            switch (this.type) {
                case 0: {
                    this.blockSwipe = false;
                    this.riskySwipe = false;
                    if (Tabs.this.contentPane.contains(x, y)) {
                        Component testCmp = Tabs.this.contentPane.getComponentAt(x, y);
                        if (testCmp != null && testCmp != Tabs.this.contentPane) {
                            while (testCmp != null && testCmp != Tabs.this.contentPane) {
                                if (testCmp.shouldBlockSideSwipe()) {
                                    Tabs.this.lastX = -1;
                                    Tabs.this.initialX = -1;
                                    this.blockSwipe = true;
                                    return;
                                }
                                if (testCmp.isScrollable()) {
                                    if (testCmp.isScrollableX()) {
                                        Tabs.this.lastX = -1;
                                        Tabs.this.initialX = -1;
                                        this.blockSwipe = true;
                                        return;
                                    }
                                    this.riskySwipe = true;
                                    break;
                                }
                                testCmp = testCmp.getParent();
                            }
                        }
                        Tabs.this.lastX = x;
                        Tabs.this.initialX = x;
                        Tabs.this.initialY = y;
                    } else {
                        Tabs.this.lastX = -1;
                        Tabs.this.initialX = -1;
                        Tabs.this.initialY = -1;
                    }
                    Tabs.this.dragStarted = false;
                    break;
                }
                case 1: {
                    int diffX;
                    if (this.blockSwipe) {
                        return;
                    }
                    if (!Tabs.this.dragStarted) {
                        if (this.riskySwipe) {
                            if (Math.abs(x - Tabs.this.initialX) < Math.abs(y - Tabs.this.initialY)) {
                                return;
                            }
                            Tabs.this.dragStarted = Math.abs(x - Tabs.this.initialX) > Tabs.this.contentPane.getWidth() / 5;
                        } else {
                            Tabs.this.dragStarted = Math.abs(x - Tabs.this.initialX) > Tabs.this.contentPane.getWidth() / 8;
                        }
                    }
                    if (Tabs.this.initialX == -1 || !Tabs.this.contentPane.contains(x, y) || (diffX = x - Tabs.this.lastX) == 0 || !Tabs.this.dragStarted) break;
                    Tabs.this.lastX += diffX;
                    int size = Tabs.this.contentPane.getComponentCount();
                    for (int i = 0; i < size; ++i) {
                        Component component = Tabs.this.contentPane.getComponentAt(i);
                        component.setX(component.getX() + diffX);
                        component.paintLock(false);
                    }
                    Tabs.this.repaint();
                    break;
                }
                case 2: {
                    int diff;
                    if (Tabs.this.changeTabContainerStyleOnFocus) {
                        Tabs.this.initTabsContainerStyle();
                        Tabs.this.tabsContainer.setUnselectedStyle(Tabs.this.originalTabsContainerUnselected);
                        Tabs.this.tabsContainer.repaint();
                    }
                    if (this.blockSwipe) {
                        return;
                    }
                    if (Tabs.this.initialX != -1 && (diff = x - Tabs.this.initialX) != 0 && Tabs.this.dragStarted) {
                        if (Math.abs(diff) > Tabs.this.contentPane.getWidth() / 2) {
                            if (Tabs.this.isRTL()) {
                                diff *= -1;
                            }
                            if (diff > 0) {
                                Tabs.this.activeComponent--;
                                if (Tabs.this.activeComponent < 0) {
                                    Tabs.this.activeComponent = (Tabs.this.activeComponent = 0);
                                }
                            } else {
                                Tabs.this.activeComponent++;
                                if (Tabs.this.activeComponent >= Tabs.this.contentPane.getComponentCount()) {
                                    Tabs.this.activeComponent = Tabs.this.contentPane.getComponentCount() - 1;
                                }
                            }
                        }
                        int start = Tabs.this.contentPane.getComponentAt(Tabs.this.activeComponent).getX();
                        int end = 0;
                        Tabs.this.slideToDestMotion = Motion.createSplineMotion(start, end, 250);
                        Tabs.this.slideToDestMotion.start();
                        Form form = Tabs.this.getComponentForm();
                        if (form != null) {
                            form.registerAnimatedInternal(Tabs.this);
                        }
                    }
                    Tabs.this.lastX = -1;
                    Tabs.this.initialX = -1;
                    Tabs.this.dragStarted = false;
                }
            }
        }
    }

    class TabFocusListener
    implements FocusListener {
        TabFocusListener() {
        }

        public void focusGained(Component cmp) {
            if (Tabs.this.focusListeners != null) {
                Tabs.this.focusListeners.fireFocus(cmp);
            }
            if (Display.getInstance().shouldRenderSelection()) {
                if (Tabs.this.isChangeTabOnFocus() && !((Button)cmp).isSelected()) {
                    ((Button)cmp).fireClicked();
                }
                if (Tabs.this.changeTabContainerStyleOnFocus) {
                    Tabs.this.initTabsContainerStyle();
                    Tabs.this.tabsContainer.setUnselectedStyle(Tabs.this.originalTabsContainerSelected);
                    Tabs.this.tabsContainer.repaint();
                }
            }
        }

        public void focusLost(Component cmp) {
            if (Tabs.this.focusListeners != null) {
                Tabs.this.focusListeners.fireFocus(cmp);
            }
            if (Tabs.this.changeTabContainerStyleOnFocus) {
                Tabs.this.initTabsContainerStyle();
                Tabs.this.tabsContainer.setUnselectedStyle(Tabs.this.originalTabsContainerUnselected);
                Tabs.this.tabsContainer.repaint();
            }
        }
    }

    class TabsLayout
    extends Layout {
        TabsLayout() {
        }

        public void layoutContainer(Container parent) {
            int size = parent.getComponentCount();
            for (int i = 0; i < size; ++i) {
                int xOffset;
                if (Tabs.this.isRTL()) {
                    xOffset = (size - i) * parent.getWidth();
                    xOffset -= (size - Tabs.this.activeComponent) * parent.getWidth();
                } else {
                    xOffset = i * parent.getWidth();
                    xOffset -= Tabs.this.activeComponent * parent.getWidth();
                }
                Component component = parent.getComponentAt(i);
                component.setX(component.getStyle().getMargin(1) + xOffset);
                component.setY(component.getStyle().getMargin(0));
                component.setWidth(parent.getWidth() - component.getStyle().getMargin(1) - component.getStyle().getMargin(3));
                component.setHeight(parent.getHeight() - component.getStyle().getMargin(0) - component.getStyle().getMargin(2));
            }
        }

        public Dimension getPreferredSize(Container parent) {
            Dimension dim = new Dimension(0, 0);
            dim.setWidth(parent.getWidth() + parent.getStyle().getPadding(false, 1) + parent.getStyle().getPadding(false, 3));
            dim.setHeight(parent.getHeight() + parent.getStyle().getPadding(false, 0) + parent.getStyle().getPadding(false, 2));
            int compCount = Tabs.this.contentPane.getComponentCount();
            for (int iter = 0; iter < compCount; ++iter) {
                Dimension d = Tabs.this.contentPane.getComponentAt(iter).getPreferredSizeWithMargin();
                dim.setWidth(Math.max(d.getWidth(), dim.getWidth()));
                dim.setHeight(Math.max(d.getHeight(), dim.getHeight()));
            }
            return dim;
        }
    }
}

