/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.Button;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.list.CellRenderer;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;
import java.util.Vector;

public class GenericListCellRenderer
implements ListCellRenderer,
CellRenderer {
    public Button lastClickedComponent;
    public Vector pendingAnimations;
    public static final String ENABLED = "$$ENABLED$$";
    public static final String SELECT_ALL_FLAG = "$$SELECTALL$$";
    public Label focusComponent = new Label();
    public Component selected;
    public Component unselected;
    public Component[] selectedEntries;
    public Component[] unselectedEntries;
    public Component selectedEven;
    public Component unselectedEven;
    public Component[] selectedEntriesEven;
    public Component[] unselectedEntriesEven;
    public Monitor mon = new Monitor();
    public Component parentList;
    public boolean selectionListener = true;
    public boolean firstCharacterRTL;
    public boolean fisheye;

    public GenericListCellRenderer(Component selected, Component unselected) {
        if (selected == unselected) {
            throw new IllegalArgumentException("Must use distinct instances for renderer!");
        }
        this.selected = selected;
        this.unselected = unselected;
        this.focusComponent.setUIID(selected.getUIID() + "Focus");
        this.focusComponent.setFocus(true);
        this.selectedEntries = this.initRenderer(selected);
        this.unselectedEntries = this.initRenderer(unselected);
        this.firstCharacterRTL = UIManager.getInstance().isThemeConstant("firstCharRTLBool", false);
        this.addSelectedEntriesListener(this.selectedEntries);
    }

    private void addSelectedEntriesListener(Component[] e) {
        for (int iter = 0; iter < e.length; ++iter) {
            if (!(e[iter] instanceof Button)) continue;
            ((Button)e[iter]).addActionListener(this.mon);
        }
    }

    private Component[] initRenderer(Component r) {
        r.setCellRenderer(true);
        if (r instanceof Container) {
            Vector selectedVector = new Vector();
            this.findComponentsOfInterest(r, selectedVector);
            return this.vectorToComponentArray(selectedVector);
        }
        return new Component[]{r};
    }

    public Button extractLastClickedComponent() {
        Button c = this.lastClickedComponent;
        this.lastClickedComponent = null;
        return c;
    }

    public GenericListCellRenderer(Component odd, Component oddUnselected, Component even, Component evenUnselected) {
        this(odd, oddUnselected);
        this.selectedEven = even;
        this.unselectedEven = evenUnselected;
        this.selectedEntriesEven = this.initRenderer(even);
        this.unselectedEntriesEven = this.initRenderer(evenUnselected);
        this.addSelectedEntriesListener(this.selectedEntriesEven);
    }

    private Component[] vectorToComponentArray(Vector v) {
        Component[] result = new Component[v.size()];
        for (int iter = 0; iter < result.length; ++iter) {
            result[iter] = (Component)v.elementAt(iter);
        }
        return result;
    }

    private void findComponentsOfInterest(Component cmp, Vector dest) {
        if (cmp instanceof Container) {
            Container c = (Container)cmp;
            int count = c.getComponentCount();
            for (int iter = 0; iter < count; ++iter) {
                this.findComponentsOfInterest(c.getComponentAt(iter), dest);
            }
            return;
        }
        if ((cmp instanceof Label || cmp instanceof TextArea) && cmp.getName() != null) {
            dest.addElement(cmp);
            return;
        }
    }

    public Component getCellRendererComponent(Component list, Object model, Object value, int index, boolean isSelected) {
        if (!this.fisheye && !Display.getInstance().shouldRenderSelection(list)) {
            isSelected = false;
        }
        if (isSelected && (this.fisheye || list.hasFocus())) {
            Component cmp = this.selected;
            Component[] entries = this.selectedEntries;
            if (this.selectedEven != null && index % 2 == 0) {
                cmp = this.selectedEven;
                entries = this.selectedEntriesEven;
                if (list instanceof List) {
                    ((List)list).setMutableRendererBackgrounds(true);
                }
            }
            if (value instanceof Hashtable) {
                Hashtable h = (Hashtable)value;
                Boolean enabled = (Boolean)h.get(ENABLED);
                if (enabled != null) {
                    cmp.setEnabled(enabled);
                }
                for (int iter = 0; iter < entries.length; ++iter) {
                    String val;
                    String currentName = entries[iter].getName();
                    if (currentName.equals("$number")) {
                        val = "" + (index + 1);
                    } else {
                        val = h.get("#" + currentName);
                        if (val == null) {
                            val = h.get(currentName);
                        }
                    }
                    this.setComponentValueWithTickering(entries[iter], val, list);
                    entries[iter].setFocus(entries[iter].isFocusable());
                }
            } else {
                this.setComponentValueWithTickering(entries[0], value, list);
                entries[0].setFocus(entries[0].isFocusable());
            }
            return cmp;
        }
        Component cmp = this.unselected;
        Component[] entries = this.unselectedEntries;
        if (this.unselectedEven != null && index % 2 == 0) {
            cmp = this.unselectedEven;
            entries = this.unselectedEntriesEven;
            if (list instanceof List) {
                ((List)list).setMutableRendererBackgrounds(true);
            }
        }
        if (value instanceof Hashtable) {
            Hashtable h = (Hashtable)value;
            Boolean enabled = (Boolean)h.get(ENABLED);
            if (enabled != null) {
                cmp.setEnabled(enabled);
            }
            for (int iter = 0; iter < entries.length; ++iter) {
                String currentName = entries[iter].getName();
                if (currentName.equals("$number")) {
                    this.setComponentValue(entries[iter], "" + (index + 1));
                    continue;
                }
                this.setComponentValue(entries[iter], h.get(currentName));
            }
        } else {
            this.setComponentValue(entries[0], value);
        }
        return cmp;
    }

    public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
        return this.getCellRendererComponent(list, list.getModel(), value, index, isSelected);
    }

    private boolean isSelectedValue(Object v) {
        return v != null && "true".equalsIgnoreCase(v.toString());
    }

    private void setComponentValueWithTickering(Component cmp, Object value, Component l) {
        this.setComponentValue(cmp, value);
        if (cmp instanceof Label) {
            Label label;
            if (this.selectionListener) {
                if (l instanceof List) {
                    ((List)l).addActionListener(this.mon);
                }
                this.parentList = l;
            }
            if ((label = (Label)cmp).shouldTickerStart() && Display.getInstance().shouldRenderSelection()) {
                if (!label.isTickerRunning()) {
                    Form f;
                    this.parentList = l;
                    if (this.parentList != null && (f = this.parentList.getComponentForm()) != null) {
                        f.registerAnimated(this.mon);
                        label.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
                    }
                }
            } else {
                if (label.isTickerRunning()) {
                    label.stopTicker();
                }
                label.setTextPosition(0);
            }
        }
    }

    protected void setComponentValue(Component cmp, Object value) {
        if (cmp.getName().toLowerCase().endsWith("fixed")) {
            return;
        }
        if (cmp instanceof Label) {
            String t;
            if (value instanceof Image) {
                Image i = (Image)value;
                if (i.isAnimation()) {
                    if (this.pendingAnimations == null) {
                        this.pendingAnimations = new Vector();
                    }
                    if (!this.pendingAnimations.contains(i)) {
                        Form f;
                        this.pendingAnimations.addElement(i);
                        if (this.parentList != null && (f = this.parentList.getComponentForm()) != null) {
                            f.registerAnimated(this.mon);
                        }
                    }
                }
                ((Label)cmp).setIcon(i);
                ((Label)cmp).setText("");
                return;
            }
            ((Label)cmp).setIcon(null);
            if (cmp instanceof CheckBox) {
                ((CheckBox)cmp).setSelected(this.isSelectedValue(value));
                return;
            }
            if (cmp instanceof RadioButton) {
                ((RadioButton)cmp).setSelected(this.isSelectedValue(value));
                return;
            }
            Label l = (Label)cmp;
            if (value == null) {
                l.setText("");
            } else if (value instanceof Label) {
                l.setText(((Label)value).getText());
                l.setIcon(((Label)value).getIcon());
            } else {
                l.setText(value.toString());
            }
            if (this.firstCharacterRTL && (t = l.getText()).length() > 0) {
                l.setRTL(Display.getInstance().isRTL(t.charAt(0)));
            }
            return;
        }
        if (cmp instanceof TextArea) {
            if (value == null) {
                ((TextArea)cmp).setText("");
            } else {
                ((TextArea)cmp).setText(value.toString());
            }
        }
    }

    public Component getListFocusComponent(List list) {
        return this.focusComponent;
    }

    public Component getFocusComponent(Component list) {
        return this.focusComponent;
    }

    public boolean isSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(boolean selectionListener) {
        if (this.parentList != null && this.parentList instanceof List) {
            ((List)this.parentList).addActionListener(this.mon);
        }
        this.selectionListener = selectionListener;
    }

    public Component getSelected() {
        return this.selected;
    }

    public Component getUnselected() {
        return this.unselected;
    }

    public Component getSelectedEven() {
        return this.selectedEven;
    }

    public Component getUnselectedEven() {
        return this.unselectedEven;
    }

    public boolean isFisheye() {
        return this.fisheye;
    }

    public void setFisheye(boolean fisheye) {
        this.fisheye = fisheye;
    }

    class Monitor
    implements ActionListener,
    Animation {
        public boolean selectAllChecked;
        public int selectAllOffset;

        Monitor() {
        }

        public boolean animate() {
            if (GenericListCellRenderer.this.parentList != null) {
                Form f;
                int iter;
                boolean repaint = false;
                if (GenericListCellRenderer.this.pendingAnimations != null) {
                    int s = GenericListCellRenderer.this.pendingAnimations.size();
                    for (iter = 0; iter < s; ++iter) {
                        Image i = (Image)GenericListCellRenderer.this.pendingAnimations.elementAt(iter);
                        repaint = repaint || i.animate();
                    }
                    GenericListCellRenderer.this.pendingAnimations.removeAllElements();
                }
                if ((f = GenericListCellRenderer.this.parentList.getComponentForm()) != null) {
                    Label l;
                    if (GenericListCellRenderer.this.parentList.hasFocus() && Display.getInstance().shouldRenderSelection(GenericListCellRenderer.this.parentList)) {
                        for (iter = 0; iter < GenericListCellRenderer.this.selectedEntries.length; ++iter) {
                            if (!(GenericListCellRenderer.this.selectedEntries[iter] instanceof Label) || !(l = (Label)GenericListCellRenderer.this.selectedEntries[iter]).isTickerRunning()) continue;
                            repaint = true;
                            l.animate();
                        }
                    } else {
                        for (iter = 0; iter < GenericListCellRenderer.this.selectedEntries.length; ++iter) {
                            if (!(GenericListCellRenderer.this.selectedEntries[iter] instanceof Label) || !(l = (Label)GenericListCellRenderer.this.selectedEntries[iter]).isTickerRunning()) continue;
                            l.stopTicker();
                            repaint = true;
                        }
                    }
                    if (repaint) {
                        GenericListCellRenderer.this.parentList.repaint();
                    } else {
                        f.deregisterAnimated(this);
                    }
                    return false;
                }
                if (repaint) {
                    GenericListCellRenderer.this.parentList.repaint();
                }
            }
            return false;
        }

        public void paint(Graphics g) {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getComponent() instanceof Button) {
                GenericListCellRenderer.this.lastClickedComponent = (Button)evt.getComponent();
                return;
            }
            if (GenericListCellRenderer.this.parentList instanceof List) {
                GenericListCellRenderer.this.parentList.setHandlesInput(true);
                Object selection = ((List)GenericListCellRenderer.this.parentList).getSelectedItem();
                if (selection instanceof Hashtable) {
                    Hashtable h = (Hashtable)selection;
                    Command cmd = (Command)h.get("$navigation");
                    if (cmd != null) {
                        GenericListCellRenderer.this.parentList.getComponentForm().dispatchCommand(cmd, new ActionEvent(GenericListCellRenderer.this.parentList));
                        return;
                    }
                    for (int iter = 0; iter < GenericListCellRenderer.this.selectedEntries.length; ++iter) {
                        boolean sel;
                        if (!(GenericListCellRenderer.this.selectedEntries[iter] instanceof CheckBox) && !(GenericListCellRenderer.this.selectedEntries[iter] instanceof RadioButton)) continue;
                        boolean bl = sel = !GenericListCellRenderer.this.isSelectedValue(h.get(GenericListCellRenderer.this.selectedEntries[iter].getName()));
                        if (h.get(GenericListCellRenderer.SELECT_ALL_FLAG) != null) {
                            this.selectAllChecked = sel;
                            this.selectAllOffset = ((List)GenericListCellRenderer.this.parentList).getSelectedIndex();
                            int count = ((List)GenericListCellRenderer.this.parentList).getModel().getSize();
                            String selectionVal = "" + sel;
                            for (int x = 0; x < count; ++x) {
                                Object o = ((List)GenericListCellRenderer.this.parentList).getModel().getItemAt(x);
                                if (!(o instanceof Hashtable)) continue;
                                ((Hashtable)o).put(GenericListCellRenderer.this.selectedEntries[iter].getName(), selectionVal);
                            }
                        } else {
                            if (this.selectAllChecked) {
                                this.selectAllChecked = false;
                                Hashtable selAll = (Hashtable)((List)GenericListCellRenderer.this.parentList).getModel().getItemAt(this.selectAllOffset);
                                selAll.put(GenericListCellRenderer.this.selectedEntries[iter].getName(), "false");
                            }
                            h.put(GenericListCellRenderer.this.selectedEntries[iter].getName(), "" + sel);
                        }
                        return;
                    }
                }
            }
        }
    }
}

