/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.table;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.table.DefaultTableModel;
import com.sun.lwuit.table.TableLayout;
import com.sun.lwuit.table.TableModel;

public class Table
extends Container {
    public static final int INNER_BORDERS_NONE = 0;
    public static final int INNER_BORDERS_ROWS = 1;
    public static final int INNER_BORDERS_COLS = 2;
    public static final int INNER_BORDERS_ALL = 3;
    public TableModel model;
    public Listener listener = new Listener();
    public boolean drawBorder = true;
    public boolean collapseBorder = true;
    public boolean drawEmptyCellsBorder = true;
    public int horizontalBorderSpacing = 0;
    public int verticalBorderSpacing = 0;
    public boolean includeHeader = true;
    public int innerBorder = 3;
    public int titleAlignment = 4;
    public int cellAlignment = 1;
    public boolean potentiallyDirtyModel;
    static /* synthetic */ Class array$$Ljava$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public Table() {
        this(new DefaultTableModel(new String[]{"Col1", "Col2"}, new String[][]{{"1", "2"}, {"3", "4"}}));
    }

    public Table(TableModel model) {
        this.model = model;
        this.updateModel();
        this.setUIID("Table");
    }

    public Table(TableModel model, boolean includeHeader) {
        this.setUIID("Table");
        this.includeHeader = includeHeader;
        this.model = model;
        this.updateModel();
    }

    public int getSelectedRow() {
        Component c;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            return this.getCellRow(c);
        }
        return -1;
    }

    public int getSelectedColumn() {
        Component c;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            return this.getCellColumn(c);
        }
        return -1;
    }

    private void updateModel() {
        Component c;
        int selectionRow = -1;
        int selectionColumn = -1;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            selectionRow = this.getCellRow(c);
            selectionColumn = this.getCellColumn(c);
        }
        this.removeAll();
        int columnCount = this.model.getColumnCount();
        if (this.includeHeader) {
            this.setLayout(new TableLayout(this.model.getRowCount() + 1, columnCount));
            for (int iter = 0; iter < columnCount; ++iter) {
                String name = this.model.getColumnName(iter);
                Component header = this.createCellImpl(name, -1, iter, false);
                TableLayout.Constraint con = this.createCellConstraint(name, -1, iter);
                this.addComponent(con, header);
            }
        } else {
            this.setLayout(new TableLayout(this.model.getRowCount(), columnCount));
        }
        for (int r = 0; r < this.model.getRowCount(); ++r) {
            for (int c2 = 0; c2 < columnCount; ++c2) {
                boolean e;
                Component cell;
                Object value = this.model.getValueAt(r, c2);
                if (value == null || (cell = this.createCellImpl(value, r, c2, e = this.model.isCellEditable(r, c2))) == null) continue;
                TableLayout.Constraint con = this.createCellConstraint(value, r, c2);
                int currentRow = ((TableLayout)this.getLayout()).getNextRow();
                if (currentRow > this.model.getRowCount()) {
                    return;
                }
                this.addComponent(con, cell);
                if (r != selectionRow || c2 != selectionColumn) continue;
                cell.requestFocus();
            }
        }
    }

    protected void paintGlass(Graphics g) {
        if (this.drawBorder && this.innerBorder != 0) {
            int xPos = this.getAbsoluteX();
            int yPos = this.getAbsoluteY();
            g.translate(xPos, yPos);
            int rows = this.model.getRowCount();
            int cols = this.model.getColumnCount();
            if (this.includeHeader) {
                ++rows;
            }
            g.setColor(this.getStyle().getFgColor());
            TableLayout t = (TableLayout)this.getLayout();
            int actualWidth = Math.max(this.getWidth(), this.getScrollDimension().getWidth());
            int actualHeight = Math.max(this.getHeight(), this.getScrollDimension().getHeight());
            if (this.collapseBorder || this.innerBorder != 3 || t.hasHorizontalSpanning() || t.hasVerticalSpanning()) {
                int columnWidth;
                int rowHeight;
                int y;
                int x;
                int cellColumn;
                int cellRow;
                if (this.innerBorder == 3 || this.innerBorder == 1) {
                    if (t.hasVerticalSpanning()) {
                        for (cellRow = 0; cellRow < rows - 1; ++cellRow) {
                            for (cellColumn = 0; cellColumn < cols; ++cellColumn) {
                                if (cellRow + t.getCellVerticalSpan(cellRow, cellColumn) - 1 == rows - 1 || t.isCellSpannedThroughHorizontally(cellRow, cellColumn)) continue;
                                x = t.getColumnPosition(cellColumn);
                                y = t.getRowPosition(cellRow);
                                rowHeight = t.getRowPosition(cellRow + t.getCellVerticalSpan(cellRow, cellColumn)) - y;
                                columnWidth = cellColumn < this.getModel().getColumnCount() - 1 ? t.getColumnPosition(cellColumn + 1) - x : this.getWidth() - y;
                                if (this.innerBorder == 1 && !this.shouldDrawInnerBorderAfterRow(cellRow)) continue;
                                g.drawLine(x, y + rowHeight, x + columnWidth, y + rowHeight);
                            }
                        }
                    } else {
                        for (int row = 1; row < rows; ++row) {
                            int y2 = t.getRowPosition(row);
                            if (this.innerBorder == 1 && !this.shouldDrawInnerBorderAfterRow(row - 1)) continue;
                            g.drawLine(0, y2, actualWidth, y2);
                        }
                    }
                }
                if (this.innerBorder == 3 || this.innerBorder == 2) {
                    if (t.hasHorizontalSpanning()) {
                        for (cellRow = 0; cellRow < rows; ++cellRow) {
                            for (cellColumn = 0; cellColumn < cols - 1; ++cellColumn) {
                                if (cellColumn + t.getCellHorizontalSpan(cellRow, cellColumn) - 1 == cols - 1 || t.isCellSpannedThroughVertically(cellRow, cellColumn)) continue;
                                x = t.getColumnPosition(cellColumn);
                                y = t.getRowPosition(cellRow);
                                columnWidth = t.getColumnPosition(cellColumn + t.getCellHorizontalSpan(cellRow, cellColumn)) - x;
                                rowHeight = cellRow < this.getModel().getRowCount() - 1 ? t.getRowPosition(cellRow + 1) - y : this.getHeight() - y;
                                g.drawLine(x + columnWidth, y, x + columnWidth, y + rowHeight);
                            }
                        }
                    } else {
                        for (int col = 1; col < cols; ++col) {
                            int x2 = t.getColumnPosition(col);
                            g.drawLine(x2, 0, x2, actualHeight);
                        }
                    }
                }
            } else {
                for (int row = 0; row < rows; ++row) {
                    int y = t.getRowPosition(row);
                    int h = row + 1 < rows ? t.getRowPosition(row + 1) - y : this.getY() + actualHeight - y - 2;
                    for (int col = 0; col < cols; ++col) {
                        int x = t.getColumnPosition(col);
                        int w = col + 1 < cols ? t.getColumnPosition(col + 1) - x : this.getX() + actualWidth - x - 2;
                        Component comp = t.getComponentAt(row, col);
                        if (!comp.isVisible() || !this.drawEmptyCellsBorder && (comp.getWidth() - comp.getStyle().getPadding(false, 3) - comp.getStyle().getPadding(false, 1) <= 0 || comp.getHeight() - comp.getStyle().getPadding(false, 0) - comp.getStyle().getPadding(false, 2) <= 0)) continue;
                        int rightMargin = comp.getStyle().getMargin(3);
                        int bottomMargin = comp.getStyle().getMargin(2);
                        if (col == 0) {
                            rightMargin *= 2;
                        }
                        if (row == 0) {
                            bottomMargin *= 2;
                        }
                        g.drawRect(x + comp.getStyle().getMargin(1), y + comp.getStyle().getMargin(0), w - 2 - rightMargin, h - 2 - bottomMargin);
                    }
                }
            }
            g.translate(-xPos, -yPos);
        }
    }

    private Component createCellImpl(Object value, int row, int column, boolean editable) {
        Component c = this.createCell(value, row, column, editable);
        c.putClientProperty("row", new Integer(row));
        c.putClientProperty("column", new Integer(column));
        if (c instanceof TextArea) {
            ((TextArea)c).addActionListener(this.listener);
        }
        Style s = c.getSelectedStyle();
        s.setMargin(this.verticalBorderSpacing, this.verticalBorderSpacing, this.horizontalBorderSpacing, this.horizontalBorderSpacing);
        if (this.drawBorder && this.innerBorder != 0) {
            s.setBorder(null);
            s = c.getUnselectedStyle();
            s.setBorder(null);
        } else {
            s = c.getUnselectedStyle();
        }
        s.setBgTransparency(0);
        s.setMargin(this.verticalBorderSpacing, this.verticalBorderSpacing, this.horizontalBorderSpacing, this.horizontalBorderSpacing);
        return c;
    }

    protected Component createCell(Object value, int row, int column, boolean editable) {
        if (row == -1) {
            Label header = new Label((String)value);
            header.setUIID("TableHeader");
            header.setAlignment(this.titleAlignment);
            header.setFocusable(true);
            return header;
        }
        if (editable) {
            TextField cell = new TextField("" + value, -1);
            cell.setLeftAndRightEditingTrigger(false);
            cell.setUIID("TableCell");
            return cell;
        }
        Label cell = new Label("" + value);
        cell.setUIID("TableCell");
        cell.setAlignment(this.cellAlignment);
        cell.setFocusable(true);
        return cell;
    }

    public void initComponent() {
        if (this.potentiallyDirtyModel) {
            this.updateModel();
            this.potentiallyDirtyModel = false;
        }
        this.model.addDataChangeListener(this.listener);
    }

    public void deinitialize() {
        if (!Display.getInstance().isVirtualKeyboardShowing()) {
            this.potentiallyDirtyModel = true;
            this.model.removeDataChangeListener(this.listener);
        } else {
            this.potentiallyDirtyModel = false;
        }
    }

    public void setModel(TableModel model) {
        this.model = model;
        this.updateModel();
        this.revalidate();
    }

    public TableModel getModel() {
        return this.model;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.repaint();
    }

    public void setInnerBorderMode(int innerBorder) {
        if (innerBorder < 0 || innerBorder > 3) {
            throw new IllegalArgumentException("Inner border mode must be one of the INNER_BORDER_* constants");
        }
        this.innerBorder = innerBorder;
        this.repaint();
    }

    public int getInnerBorderMode() {
        return this.innerBorder;
    }

    protected boolean shouldDrawInnerBorderAfterRow(int row) {
        return true;
    }

    public void setCollapseBorder(boolean collapseBorder) {
        if (this.collapseBorder != collapseBorder) {
            this.collapseBorder = collapseBorder;
            if (this.horizontalBorderSpacing != 0 || this.verticalBorderSpacing != 0) {
                this.updateMargins();
            }
            this.repaint();
        }
    }

    public void setDrawEmptyCellsBorder(boolean drawEmptyCellsBorder) {
        this.drawEmptyCellsBorder = drawEmptyCellsBorder;
        this.repaint();
    }

    public void setBorderSpacing(int horizontal, int vertical) {
        this.horizontalBorderSpacing = horizontal;
        this.verticalBorderSpacing = vertical;
        this.updateMargins();
    }

    private void updateMargins() {
        TableLayout t = (TableLayout)this.getLayout();
        int hSpace = this.horizontalBorderSpacing;
        int vSpace = this.verticalBorderSpacing;
        if (this.collapseBorder) {
            hSpace = 0;
            vSpace = 0;
        }
        if (!t.hasHorizontalSpanning() && !t.hasVerticalSpanning()) {
            for (int row = 0; row < t.getRows(); ++row) {
                for (int col = 0; col < t.getColumns(); ++col) {
                    Component cmp = null;
                    try {
                        cmp = t.getComponentAt(row, col);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (cmp == null) continue;
                    int leftMargin = col == 0 ? hSpace : 0;
                    int topMargin = row == 0 ? vSpace : 0;
                    cmp.getUnselectedStyle().setMargin(topMargin, vSpace, leftMargin, hSpace);
                    cmp.getSelectedStyle().setMargin(topMargin, vSpace, leftMargin, hSpace);
                }
            }
        }
        this.repaint();
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
        this.repaint();
    }

    public int getCellColumn(Component cell) {
        Integer i = (Integer)cell.getClientProperty("column");
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int getCellRow(Component cell) {
        Integer i = (Integer)cell.getClientProperty("row");
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int getCellAlignment() {
        return this.cellAlignment;
    }

    public void setCellAlignment(int cellAlignment) {
        this.cellAlignment = cellAlignment;
        this.repaint();
    }

    public boolean isIncludeHeader() {
        return this.includeHeader;
    }

    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
        this.updateModel();
    }

    protected TableLayout.Constraint createCellConstraint(Object value, int row, int column) {
        if (this.includeHeader) {
            ++row;
        }
        TableLayout t = (TableLayout)this.getLayout();
        return t.createConstraint(row, column);
    }

    public String[] getPropertyNames() {
        return new String[]{"data", "header"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{array$$Ljava$lang$String == null ? (array$$Ljava$lang$String = Table.class$("[[Ljava.lang.String;")) : array$$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Table.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("data")) {
            return ((DefaultTableModel)this.model).data;
        }
        if (name.equals("header")) {
            return ((DefaultTableModel)this.model).columnNames;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("data")) {
            this.setModel(new DefaultTableModel(((DefaultTableModel)this.model).columnNames, (String[][])value));
            return null;
        }
        if (name.equals("header")) {
            this.setModel(new DefaultTableModel((String[])value, ((DefaultTableModel)this.model).data));
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Listener
    implements DataChangedListener,
    ActionListener {
        Listener() {
        }

        public final void dataChanged(int row, int column) {
            Object value = Table.this.model.getValueAt(row, column);
            boolean e = Table.this.model.isCellEditable(row, column);
            Component cell = Table.this.createCellImpl(value, row, column, e);
            TableLayout t = (TableLayout)Table.this.getLayout();
            TableLayout.Constraint con = Table.this.createCellConstraint(value, row, column);
            if (Table.this.includeHeader) {
                ++row;
            }
            Component c = t.getComponentAt(row, column);
            Table.this.removeComponent(c);
            c.setVisible(false);
            Table.this.addComponent(con, cell);
            Table.this.layoutContainer();
            cell.requestFocus();
            Table.this.revalidate();
        }

        public void actionPerformed(ActionEvent evt) {
            TextArea t = (TextArea)evt.getSource();
            int row = Table.this.getCellRow(t);
            int column = Table.this.getCellColumn(t);
            Table.this.getModel().setValueAt(row, column, t.getText());
        }
    }
}

