/*
 * Decompiled with CFR 0.152.
 */
class Chameleon
extends EnemyObject {
    public int COLLISION_WIDTH = 2880;
    public int COLLISION_HEIGHT = 1408;
    public int velocity = 128;
    public int limitLeftX = this.posX;
    public int limitRightX = this.posX + this.mWidth;
    public static Animation chameleonAnimation;
    public int state;
    public int alert_state;
    public int ALERT_RANGE = 5760;
    public int attack_cnt;
    public int collision_offset_x = 1280;

    public static void releaseAllResource() {
        chameleonAnimation = null;
    }

    protected Chameleon(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (chameleonAnimation == null) {
            chameleonAnimation = new Animation("/animation/chameleon");
        }
        this.drawer = chameleonAnimation.getDrawer(0, true, 0);
        this.attack_cnt = 0;
        this.collision_offset_x = 0;
    }

    public boolean IsFacePlayer() {
        return this.posX > GameObject.player.getFootPositionX() && this.velocity < 0 || this.posX < GameObject.player.getFootPositionX() && this.velocity > 0;
    }

    public void logic() {
        if (this.dead) {
            return;
        }
        this.alert_state = this.checkPlayerInEnemyAlertRange(this.posX >> 6, this.posY >> 6, this.ALERT_RANGE >> 6, this.limitLeftX >> 6, this.limitRightX >> 6, this.COLLISION_WIDTH >> 6);
        int n = this.posX;
        int n2 = this.posY;
        switch (this.state) {
            case 0: {
                if (this.velocity > 0) {
                    this.posX += this.velocity;
                    this.drawer.setActionId(0);
                    this.drawer.setTrans(2);
                    this.drawer.setLoop(true);
                    if (this.posX >= this.limitRightX) {
                        this.posX = this.limitRightX;
                        this.velocity = -this.velocity;
                        this.drawer.setActionId(1);
                        this.drawer.setTrans(2);
                        this.drawer.setLoop(false);
                        this.state = 1;
                    }
                } else {
                    this.posX += this.velocity;
                    this.drawer.setActionId(0);
                    this.drawer.setTrans(0);
                    this.drawer.setLoop(true);
                    if (this.posX <= this.limitLeftX) {
                        this.posX = this.limitLeftX;
                        this.velocity = -this.velocity;
                        this.drawer.setActionId(1);
                        this.drawer.setTrans(0);
                        this.drawer.setLoop(false);
                        this.state = 1;
                    }
                }
                if (this.attack_cnt < 10) {
                    ++this.attack_cnt;
                }
                if (this.alert_state == 0 && this.attack_cnt == 10 && this.IsFacePlayer()) {
                    this.state = 2;
                    if (this.posX < GameObject.player.getCheckPositionX()) {
                        this.drawer.setActionId(2);
                        this.drawer.setTrans(2);
                        this.drawer.setLoop(false);
                    } else {
                        this.drawer.setActionId(2);
                        this.drawer.setTrans(0);
                        this.drawer.setLoop(false);
                    }
                    this.attack_cnt = 0;
                }
                this.posY = this.getGroundY(this.posX, this.posY);
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 1: {
                if (this.drawer.checkEnd()) {
                    this.state = 0;
                }
                this.attack_cnt = 0;
                this.posY = this.getGroundY(this.posX, this.posY);
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 2: {
                if (this.drawer.getCurrentFrame() == 3) {
                    this.collision_offset_x = this.posX < GameObject.player.getCheckPositionX() ? 640 : -640;
                    this.COLLISION_WIDTH = 3840;
                    this.refreshCollisionRect(this.posX, this.posY);
                } else {
                    this.COLLISION_WIDTH = 2880;
                    this.collision_offset_x = 0;
                    this.refreshCollisionRect(this.posX, this.posY);
                }
                if (this.drawer.checkEnd()) {
                    this.state = 0;
                    this.collision_offset_x = 0;
                    this.COLLISION_WIDTH = 2880;
                }
                this.posY = this.getGroundY(this.posX, this.posY);
                this.refreshCollisionRect(this.posX, this.posY);
                this.checkWithPlayer(n, n2, this.posX, this.posY);
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.dead) {
            return;
        }
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - (this.COLLISION_WIDTH >> 1) + this.collision_offset_x, n2 - this.COLLISION_HEIGHT, this.COLLISION_WIDTH, this.COLLISION_HEIGHT);
    }
}

