/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GlobalResource {
    public static Animation statusAnimation;
    public static int seConfig;
    public static int soundConfig;
    public static int difficultyConfig;
    public static int timeLimit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSystemConfig() {
        ByteArrayInputStream byteArrayInputStream = Record.loadRecordStream("SONIC_SYSTEM_RECORD");
        try {
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            soundConfig = dataInputStream.readByte();
            difficultyConfig = dataInputStream.readByte();
            timeLimit = dataInputStream.readByte();
            seConfig = dataInputStream.readByte();
        }
        catch (Exception exception) {
            GlobalResource.saveSystemConfig();
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSystemConfig() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(soundConfig);
            dataOutputStream.writeByte(difficultyConfig);
            dataOutputStream.writeByte(timeLimit);
            dataOutputStream.write(seConfig);
            Record.saveRecordStream("SONIC_SYSTEM_RECORD", byteArrayOutputStream);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean isEasyMode() {
        return difficultyConfig == 0;
    }

    public static boolean timeIsLimit() {
        return timeLimit == 0;
    }

    static {
        seConfig = 1;
        soundConfig = 10;
        difficultyConfig = 1;
        timeLimit = 0;
    }
}

