/*
 * Decompiled with CFR 0.152.
 */
class Lizard
extends EnemyObject {
    public int velocity = 150;
    public int limitLeftX;
    public int limitRightX;
    public static Animation lizardAnimation;
    public int state;
    public boolean IsFired;
    public int enemyid;
    public int fire_start_speed = 1200;

    public static void releaseAllResource() {
        lizardAnimation = null;
    }

    protected Lizard(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.mWidth = 4096;
        this.limitLeftX = this.posX;
        this.limitRightX = this.posX + this.mWidth;
        this.posX += this.mWidth >> 1;
        if (lizardAnimation == null) {
            lizardAnimation = new Animation("/animation/lizard");
        }
        this.drawer = lizardAnimation.getDrawer(0, true, 0);
        this.IsFired = false;
        this.enemyid = n;
    }

    public void logic() {
        if (this.dead) {
            return;
        }
        int n = this.posX;
        int n2 = this.posY;
        int n3 = 0;
        switch (this.state) {
            case 0: {
                n3 = (this.limitLeftX + (this.mWidth >> 1)) / 150;
                if (this.velocity > 0) {
                    this.posX += this.velocity;
                    this.drawer.setActionId(0);
                    this.drawer.setTrans(2);
                    this.drawer.setLoop(true);
                    if (this.posX >= this.limitRightX) {
                        this.posX = this.limitRightX;
                        this.velocity = -this.velocity;
                        this.IsFired = false;
                    }
                    if (this.posX / 150 == n3 && !this.IsFired) {
                        this.state = 1;
                        this.drawer.setActionId(1);
                        this.drawer.setTrans(2);
                        this.drawer.setLoop(false);
                        this.IsFired = true;
                    }
                } else {
                    this.posX += this.velocity;
                    this.drawer.setActionId(0);
                    this.drawer.setTrans(0);
                    this.drawer.setLoop(true);
                    if (this.posX <= this.limitLeftX) {
                        this.posX = this.limitLeftX;
                        this.velocity = -this.velocity;
                        this.IsFired = false;
                    }
                    if (this.posX / 150 == n3 && !this.IsFired) {
                        this.state = 1;
                        this.drawer.setActionId(1);
                        this.drawer.setTrans(0);
                        this.drawer.setLoop(false);
                        this.IsFired = true;
                    }
                }
                this.posY = this.getGroundY(this.posX, this.posY);
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 1: {
                if (this.drawer.checkEnd()) {
                    BulletObject.addBullet(this.enemyid, this.posX, this.posY - 1024, 0, -this.fire_start_speed);
                    this.state = 0;
                    if (this.velocity > 0) {
                        this.drawer.setActionId(0);
                        this.drawer.setTrans(2);
                    } else {
                        this.drawer.setActionId(0);
                        this.drawer.setTrans(0);
                    }
                }
                this.posY = this.getGroundY(this.posX, this.posY);
                this.checkWithPlayer(n, n2, this.posX, this.posY);
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.dead) {
            return;
        }
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 864, n2 - 2048, 1728, 2048);
    }
}

