/*
 * Decompiled with CFR 0.152.
 */
public class MapObject
extends GameObject {
    public GameObject object;
    public MapBehavior collisionBehavior;
    public int footX;
    public int footY;
    public int velX;
    public int velY;
    public int totalVelocity;
    public int state;
    public int moveDegree;
    public int moveDistanceX;
    public int moveDistanceY;
    public int centerOffsetX;
    public int centerOffsetY;
    public int RIGHT_WALK_COLLISION_CHECK_OFFSET_X;
    public int LEFT_WALK_COLLISION_CHECK_OFFSET_X;
    public int RIGHT_WALK_COLLISION_CHECK_OFFSET_Y;
    public int LEFT_WALK_COLLISION_CHECK_OFFSET_Y;
    public int crashCount;
    public static CollisionBlock groundBlock = new CollisionBlock();
    public static CollisionBlock skyBlock = new CollisionBlock();
    public boolean collisionChkBreak;
    public static CollisionBlock tmpCurrentBlock = new CollisionBlock();
    public static CollisionBlock tmpBeforeBlock = new CollisionBlock();

    public MapObject(GameObject gameObject, int n) {
        this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y = this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y = -512;
        this.crashCount = 1;
        this.object = gameObject;
        this.currentLayer = n;
    }

    public MapObject(int n, int n2, int n3, int n4, GameObject gameObject, int n5) {
        this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y = this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y = -512;
        this.crashCount = 1;
        this.setPosition(n, n2, n3, n4, gameObject);
        this.currentLayer = n5;
    }

    public void setPosition(int n, int n2, int n3, int n4, GameObject gameObject) {
        this.state = 1;
        this.posX = n;
        this.posY = n2;
        this.velX = n3;
        this.velY = n4;
        this.object = gameObject;
        this.object.refreshCollisionRect(this.posX, this.posY);
        CollisionRect collisionRect = this.object.getCollisionRect();
        this.footX = collisionRect.x0 + collisionRect.x1 >> 1;
        this.footY = collisionRect.y1;
        this.centerOffsetX = this.footX - this.posX;
        this.centerOffsetY = this.footY - this.posY;
        this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X = collisionRect.getWidth() >> 1;
        this.LEFT_WALK_COLLISION_CHECK_OFFSET_X = -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X;
    }

    public void setCrashCount(int n) {
        this.crashCount = n;
    }

    public void logic() {
        switch (this.state) {
            case 0: {
                if (this.totalVelocity == 0) break;
                this.totalVelocity += GameObject.GRAVITY * MyAPI.dSin(this.moveDegree) / 100;
                break;
            }
            case 1: {
                this.velY += GameObject.GRAVITY;
            }
        }
        this.checkWithMap();
    }

    public int getPosX() {
        return this.footX - this.centerOffsetX;
    }

    public int getPosY() {
        return this.footY - this.centerOffsetY;
    }

    public void checkWithMap() {
        switch (this.state) {
            case 0: {
                this.moveDistanceX = this.totalVelocity * MyAPI.dCos(this.moveDegree) / 100;
                this.moveDistanceY = this.totalVelocity * MyAPI.dSin(this.moveDegree) / 100;
                break;
            }
            case 1: {
                this.moveDistanceX = this.velX;
                this.moveDistanceY = this.velY;
            }
        }
        while (this.moveDistanceX != 0 || this.moveDistanceY != 0) {
            switch (this.state) {
                case 0: {
                    this.checkInGround();
                    break;
                }
                case 1: {
                    this.checkInSky();
                }
            }
        }
    }

    public void checkInGround() {
        block38: {
            int n;
            int n2 = this.getQuaParam(this.footX, 512);
            int n3 = this.getQuaParam(this.footY, 512);
            CollisionMap.getCollisionInfoWithBlock(this.footX / 512, this.footY / 512, this.currentLayer, groundBlock);
            int n4 = n = groundBlock.getDegreeNearby(this.moveDegree);
            int n5 = this.footX;
            int n6 = this.footY;
            boolean bl = false;
            int n7 = this.totalVelocity;
            do {
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                boolean bl2;
                n5 = this.footX;
                n6 = this.footY;
                n = groundBlock.getDegreeNearby(n4);
                int n13 = Math.abs(n4 - n);
                if (n13 > 180) {
                    n13 = 360 - n13;
                }
                if (n13 >= 40) {
                    this.velX = this.totalVelocity * MyAPI.dCos(n4) / 100;
                    this.velY = this.totalVelocity * MyAPI.dSin(n4) / 100;
                    this.state = 1;
                    this.moveDegree = 0;
                    break block38;
                }
                n4 = n;
                boolean bl3 = bl2 = !(n > 45 && n <= 135 || n > 225 && n <= 315);
                if (bl2) {
                    n12 = groundBlock.getReverseY(this.footX >> 6, groundBlock.getDegreeNearby(this.moveDegree));
                    if (this.moveDistanceX == 0) {
                        bl = true;
                    } else {
                        if (this.moveDistanceX > 0) {
                            if (this.footX + this.moveDistanceX >> 6 >= this.getBlockLeftSide(n2 + 1, n3) >> 6) {
                                this.footX = this.getBlockLeftSide(++n2, n3);
                            } else {
                                this.footX += this.moveDistanceX;
                                bl = true;
                            }
                        } else if (this.footX + this.moveDistanceX >> 6 <= this.getBlockRightSide(n2 - 1, n3) >> 6) {
                            this.footX = this.getBlockRightSide(--n2, n3);
                        } else {
                            this.footX += this.moveDistanceX;
                            bl = true;
                        }
                        if (this.moveDistanceX > 0) {
                            n11 = this.rightSideMultiPointCollisionChk(this.footX, this.footY, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, -512, this.moveDegree, -1);
                            if (n11 >= 0) {
                                this.calDivideVelocity(n4);
                                this.velX = 0;
                                this.calTotalVelocity(n4);
                                this.footX = n11;
                                this.moveDistanceX = 0;
                                n2 = this.getQuaParam(this.footX, 512);
                                --this.crashCount;
                            }
                        } else if (this.moveDistanceX < 0 && (n11 = this.leftSideMultiPointCollisionChk(this.footX, this.footY, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, -512, this.moveDegree, -1)) >= 0) {
                            this.calDivideVelocity(n4);
                            this.velX = 0;
                            this.calTotalVelocity(n4);
                            this.footX = n11;
                            this.moveDistanceX = 0;
                            n2 = this.getQuaParam(this.footX, 512);
                            --this.crashCount;
                        }
                    }
                    CollisionMap.getCollisionInfoWithBlock(n2, n3, this.currentLayer, groundBlock);
                    n11 = groundBlock.getCollisionY(this.footX >> 6);
                    n10 = n3;
                    n9 = 0;
                    n8 = 0;
                    while (n11 == 0) {
                        if (n12 != 0) {
                            ++n10;
                        } else {
                            --n10;
                            n9 = 1;
                        }
                        CollisionMap.getCollisionInfoWithBlock(n2, n10, this.currentLayer, groundBlock);
                        n11 = groundBlock.getCollisionY(this.footX >> 6);
                        if (++n8 <= 3) continue;
                    }
                    n8 = 0;
                    while (n11 == -1) {
                        if (n12 != 0) {
                            --n10;
                        } else {
                            if (n9 != 0 && groundBlock.getDegreeNearby(this.moveDegree) != 0) {
                                n11 = 8;
                                break;
                            }
                            ++n10;
                        }
                        CollisionMap.getCollisionInfoWithBlock(n2, n10, this.currentLayer, groundBlock);
                        n11 = groundBlock.getCollisionY(this.footX >> 6);
                        if (++n8 <= 1) continue;
                    }
                    if (n11 == -1) {
                        n10 = n12 != 0 ? ++n10 : --n10;
                        CollisionMap.getCollisionInfoWithBlock(n2, n10, this.currentLayer, groundBlock);
                        n11 = groundBlock.getCollisionY(this.footX >> 6);
                        int n14 = this.footX - n5;
                        int n15 = this.footY - n6;
                        int n16 = this.totalVelocity;
                        this.velX = n16 * MyAPI.dCos(this.moveDegree) / 100;
                        this.velY = n16 * MyAPI.dSin(this.moveDegree) / 100;
                        this.moveDistanceX -= n14;
                        this.moveDistanceY -= n15;
                        this.state = 1;
                        break block38;
                    }
                    this.footY = this.getBlockUpSide(n2, n10) + (n11 << 6);
                    n3 = n10;
                } else {
                    n12 = groundBlock.getReverseX(this.footY >> 6, groundBlock.getDegreeNearby(this.moveDegree));
                    if (this.moveDistanceY == 0) {
                        bl = true;
                    } else if (this.moveDistanceY > 0) {
                        if (this.footY + this.moveDistanceY >> 6 >= this.getBlockUpSide(n2, n3 + 1) >> 6) {
                            this.footY = this.getBlockUpSide(n2, ++n3);
                        } else {
                            this.footY += this.moveDistanceY;
                            bl = true;
                        }
                    } else if (this.footY + this.moveDistanceY >> 6 <= this.getBlockDownSide(n2, n3 - 1) >> 6) {
                        this.footY = this.getBlockDownSide(n2, --n3);
                    } else {
                        this.footY += this.moveDistanceY;
                        bl = true;
                    }
                    CollisionMap.getCollisionInfoWithBlock(n2, n3, this.currentLayer, groundBlock);
                    n11 = groundBlock.getCollisionX(this.footY >> 6);
                    n10 = n2;
                    n8 = 0;
                    while (n11 == 0) {
                        n10 = n12 != 0 ? ++n10 : --n10;
                        CollisionMap.getCollisionInfoWithBlock(n10, n3, this.currentLayer, groundBlock);
                        n11 = groundBlock.getCollisionX(this.footY >> 6);
                        if (++n8 <= 3) continue;
                    }
                    n8 = 0;
                    while (n11 == -1) {
                        n10 = n12 != 0 ? --n10 : ++n10;
                        CollisionMap.getCollisionInfoWithBlock(n10, n3, this.currentLayer, groundBlock);
                        n11 = groundBlock.getCollisionX(this.footY >> 6);
                        if (++n8 <= 1) continue;
                    }
                    if (n11 == -1) {
                        n10 = n12 != 0 ? ++n10 : --n10;
                        CollisionMap.getCollisionInfoWithBlock(n10, n3, this.currentLayer, groundBlock);
                        n11 = groundBlock.getCollisionX(this.footY >> 6);
                        n9 = this.footX - n5;
                        int n17 = this.footY - n6;
                        int n18 = this.totalVelocity;
                        this.velX = n18 * MyAPI.dCos(this.moveDegree) / 100;
                        this.velY = n18 * MyAPI.dSin(this.moveDegree) / 100;
                        this.moveDistanceX -= n9;
                        this.moveDistanceY -= n17;
                        this.state = 1;
                        break block38;
                    }
                    if (n11 == 0 && n12 != 0 && groundBlock.getActualX(this.footY >> 6) == 8) {
                        n11 = 7;
                    }
                    this.footX = this.getBlockLeftSide(n10, n3) + (n11 << 6);
                    n2 = n10;
                }
                n12 = this.footX - n5;
                n11 = this.footY - n6;
                this.moveDistanceX -= n12;
                this.moveDistanceY -= n11;
                this.moveDistanceX = this.moveDistanceX >> 6 << 6;
                this.moveDistanceY = this.moveDistanceY >> 6 << 6;
                n5 = this.footX;
                n6 = this.footY;
                n2 = this.getQuaParam(this.footX, 512);
                n3 = this.getQuaParam(this.footY, 512);
                this.moveDegree = groundBlock.getDegreeNearby(n4);
                n10 = n7;
                n7 = (this.moveDistanceX * MyAPI.dCos(this.moveDegree) + this.moveDistanceY * MyAPI.dSin(this.moveDegree)) / 100;
                if (n7 * n10 < 0) {
                    n7 = -n7;
                }
                this.moveDistanceX = n7 * MyAPI.dCos(this.moveDegree) / 100;
                this.moveDistanceY = n7 * MyAPI.dSin(this.moveDegree) / 100;
                if (!bl) continue;
                this.moveDistanceX = 0;
                this.moveDistanceY = 0;
            } while (!bl);
            this.moveDegree = groundBlock.getDegreeNearby(n4);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkInSky() {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        block46: {
            block45: {
                n9 = 0;
                n8 = this.moveDistanceX;
                n7 = this.moveDistanceY;
                n6 = (Math.abs(n8) + 512 - 1) / 512;
                bl = n6 > (n5 = (Math.abs(n7) + 512 - 1) / 512);
                n4 = this.footX;
                n3 = this.footY;
                n2 = this.footX;
                n = this.footY;
                this.collisionChkBreak = false;
                if (n7 > 0) break block45;
                if (n7 >= 0) {
                    if (!this.collisionLogicBody(n8, n7, true)) return;
                    this.moveDistanceX = 0;
                    this.velX = 0;
                    return;
                }
                break block46;
            }
            int n10 = 0;
            while (n10 <= (bl ? n6 : n5)) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                block49: {
                    block47: {
                        block48: {
                            if (!bl) break block47;
                            n16 = n2 + (n8 >= 0 ? 1 : -1) * 512 * n10;
                            n15 = (n * n6 + n7 * n10) / n6;
                            if (n8 <= 0) break block48;
                            if (n16 > n2 + n8) {
                                n16 = n2 + n8;
                                n15 = n + n7;
                            }
                            break block49;
                        }
                        if (n8 < 0) {
                            if (n16 < n2 + n8) {
                                n16 = n2 + n8;
                                n15 = n + n7;
                            }
                            break block49;
                        } else {
                            n16 = n2;
                        }
                        break block49;
                    }
                    n15 = n + (n7 >= 0 ? 1 : -1) * 512 * n10;
                    n16 = (n2 * n5 + n8 * n10) / n5;
                    if (n15 > n + n7) {
                        n16 = n2 + n8;
                        n15 = n + n7;
                    }
                }
                if (this.collisionBehavior == null || this.collisionBehavior.hasSideCollision()) {
                    if (n8 > 0) {
                        n14 = this.getNewPointY(n15, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n13 = this.getNewPointX(n16, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n12 = this.rightSideCollisionChk(n13, n14);
                        if (n12 >= 0) {
                            n13 = n12;
                            n16 = this.footX = this.getNewPointX(n13, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                            n2 = this.footX;
                            this.moveDistanceX = 0;
                            n8 = 0;
                            this.velX = 0;
                            bl = false;
                            this.collisionChkBreak = true;
                            --this.crashCount;
                        }
                    } else if (n8 < 0) {
                        n14 = this.getNewPointY(n15, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n13 = this.getNewPointX(n16, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n12 = this.leftSideCollisionChk(n13, n14);
                        if (n12 >= 0) {
                            n13 = n12;
                            n16 = this.footX = this.getNewPointX(n13, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                            n2 = this.footX;
                            this.moveDistanceX = 0;
                            n8 = 0;
                            this.velX = 0;
                            bl = false;
                            this.collisionChkBreak = true;
                            --this.crashCount;
                        }
                    }
                }
                if ((n14 = this.downSideCollisionChk(n16, n15)) >= 0) {
                    this.state = 0;
                    n15 = this.footY = n14;
                    this.footX = n16;
                    this.collisionChkBreak = false;
                    n4 = n16;
                    n3 = n15;
                    n13 = n2 + n8 - n16;
                    n12 = n + n7 - n15;
                    if (n13 < 0) {
                        n13 = 0;
                    }
                    if (n12 < 0) {
                        n12 = 0;
                    }
                    CollisionMap.getCollisionInfoWithBlock(n16 / 512, n15 / 512, this.currentLayer, skyBlock);
                    this.moveDegree = skyBlock.getDegreeNearby(n9);
                    n11 = (n13 * MyAPI.dCos(this.moveDegree) + n12 * MyAPI.dSin(this.moveDegree)) / 100;
                    this.moveDistanceX = n11 * MyAPI.dCos(this.moveDegree) / 100;
                    this.moveDistanceY = n11 * MyAPI.dSin(this.moveDegree) / 100;
                    this.state = 0;
                    this.calTotalVelocity();
                    --this.crashCount;
                    if (this.collisionBehavior == null) return;
                    this.collisionBehavior.doWhileTouchGround(this.velX, this.velY);
                    return;
                }
                if (this.collisionBehavior == null || this.collisionBehavior.hasSideCollision()) {
                    if (n8 > 0) {
                        n13 = this.getNewPointY(n15, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n12 = this.getNewPointX(n16, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n11 = this.rightSideCollisionChk(n12, n13);
                        if (n11 >= 0) {
                            n12 = n11;
                            n16 = this.footX = this.getNewPointX(n12, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                            n2 = this.footX;
                            this.moveDistanceX = 0;
                            n8 = 0;
                            this.velX = 0;
                            bl = false;
                            this.collisionChkBreak = true;
                            --this.crashCount;
                        }
                    } else if (n8 < 0) {
                        n13 = this.getNewPointY(n15, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n12 = this.getNewPointX(n16, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n11 = this.leftSideCollisionChk(n12, n13);
                        if (n11 >= 0) {
                            n12 = n11;
                            n16 = this.footX = this.getNewPointX(n12, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                            n2 = this.footX;
                            this.moveDistanceX = 0;
                            n8 = 0;
                            this.velX = 0;
                            bl = false;
                            this.collisionChkBreak = true;
                            --this.crashCount;
                        }
                    }
                }
                this.footX = n16;
                this.footY = n15;
                this.moveDistanceX = n8 - (this.footX - n2);
                this.moveDistanceY = n7 - (this.footY - n);
                n4 = n16;
                n3 = n15;
                if (this.collisionChkBreak) {
                    this.collisionChkBreak = false;
                    return;
                }
                ++n10;
            }
            return;
        }
        int n17 = 0;
        while (n17 <= (bl ? n6 : n5)) {
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            block51: {
                block50: {
                    if (!bl) break block50;
                    n22 = n2 + (n8 >= 0 ? 1 : -1) * 512 * n17;
                    n21 = (n * n6 + n7 * n17) / n6;
                    if (n8 > 0) {
                        if (n22 > n2 + n8) {
                            n22 = n2 + n8;
                            n21 = n + n7;
                        }
                        break block51;
                    } else if (n8 < 0 && n22 < n2 + n8) {
                        n22 = n2 + n8;
                        n21 = n + n7;
                    }
                    break block51;
                }
                n21 = n + (n7 >= 0 ? 1 : -1) * 512 * n17;
                n22 = (n2 * n5 + n8 * n17) / n5;
                if (n21 < n + n7) {
                    n22 = n2 + n8;
                    n21 = n + n7;
                }
            }
            if (this.collisionBehavior == null || this.collisionBehavior.hasSideCollision()) {
                if (n8 > 0) {
                    n20 = this.getNewPointY(n21, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                    n19 = this.getNewPointX(n22, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                    n18 = this.rightSideCollisionChk(n19, n20);
                    if (n18 >= 0) {
                        n19 = n18;
                        n22 = this.footX = this.getNewPointX(n19, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n2 = this.footX;
                        this.moveDistanceX = 0;
                        n8 = 0;
                        this.velX = 0;
                        bl = false;
                        this.collisionChkBreak = true;
                        --this.crashCount;
                    }
                } else if (n8 < 0) {
                    n20 = this.getNewPointY(n21, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                    n19 = this.getNewPointX(n22, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                    n18 = this.leftSideCollisionChk(n19, n20);
                    if (n18 >= 0) {
                        n19 = n18;
                        n22 = this.footX = this.getNewPointX(n19, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n2 = this.footX;
                        this.moveDistanceX = 0;
                        n8 = 0;
                        this.velX = 0;
                        bl = false;
                        this.collisionChkBreak = true;
                        --this.crashCount;
                    }
                }
            }
            n20 = this.object.getCollisionRect().getHeight();
            CollisionMap.getCollisionInfoWithBlock(n22 / 512, (n21 -= n20) / 512, this.currentLayer, skyBlock);
            n19 = skyBlock.getCollisionY(n22 >> 6);
            if (n19 >= 0) {
                if (n19 == 0) {
                    n19 = 8;
                }
                if (n21 <= (n18 = n21 / 512 * 512 + (n19 << 6)) && !MapObject.skyBlock.attr && (this.collisionBehavior == null || this.collisionBehavior.hasTopCollision())) {
                    this.velY = 0;
                    this.moveDistanceY = 0;
                    n21 = n18;
                    this.footY = n18 + n20;
                    this.footX = n22;
                    this.moveDistanceX = n8 - (this.footX - n2);
                    n4 = n22;
                    n3 = n21;
                    --this.crashCount;
                    return;
                }
            }
            n21 += n20;
            if (this.collisionBehavior == null || this.collisionBehavior.hasSideCollision()) {
                int n23;
                int n24;
                if (n8 > 0) {
                    n18 = this.getNewPointY(n21, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                    n24 = this.getNewPointX(n22, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                    n23 = this.rightSideCollisionChk(n24, n18);
                    if (n23 >= 0) {
                        n24 = n23;
                        n22 = this.footX = this.getNewPointX(n24, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n2 = this.footX;
                        this.moveDistanceX = 0;
                        n8 = 0;
                        this.velX = 0;
                        bl = false;
                        this.collisionChkBreak = true;
                        --this.crashCount;
                    }
                } else if (n8 < 0) {
                    n18 = this.getNewPointY(n21, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                    n24 = this.getNewPointX(n22, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                    n23 = this.leftSideCollisionChk(n24, n18);
                    if (n23 >= 0) {
                        n24 = n23;
                        n22 = this.footX = this.getNewPointX(n24, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n9);
                        n2 = this.footX;
                        this.moveDistanceX = 0;
                        n8 = 0;
                        this.velX = 0;
                        bl = false;
                        this.collisionChkBreak = true;
                        --this.crashCount;
                    }
                }
            }
            this.footX = n22;
            this.footY = n21;
            this.moveDistanceX = n8 - (this.footX - n2);
            this.moveDistanceY = n7 - (this.footY - n);
            n4 = n22;
            n3 = n21;
            if (this.collisionChkBreak) {
                this.collisionChkBreak = false;
                return;
            }
            ++n17;
        }
    }

    public boolean collisionLogicBody(int n, int n2, boolean bl) {
        block6: {
            int n3;
            int n4;
            int n5;
            block7: {
                int n6;
                n5 = 0;
                if (!bl) break block6;
                n4 = (Math.abs(n) + 512 - 1) / 512;
                if (n <= 0) break block7;
                int n7 = this.getNewPointY(this.footY, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, 0);
                int n8 = n6 = this.getNewPointX(this.footX, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, 0);
                int n9 = n7;
                int n10 = n6;
                int n11 = n7;
                for (int i = 0; i <= n4; ++i) {
                    int n12;
                    int n13 = n6 + 512 * i;
                    int n14 = (n7 * n4 + n2 * i) / n4;
                    if (n13 > n10 + n) {
                        n13 = n10 + n;
                        n14 = n11 + n2;
                    }
                    if ((n12 = this.rightSideCollisionChk(n13, n14)) >= 0) {
                        n6 = n12;
                        this.moveDistanceX = 0;
                        this.footX = this.getNewPointX(n6, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n5);
                        return true;
                    }
                    this.footX = this.getNewPointX(n13, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n5);
                    this.footY = this.getNewPointY(n14, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_X, -this.RIGHT_WALK_COLLISION_CHECK_OFFSET_Y, n5);
                    this.moveDistanceX = n - (n13 - n10);
                    this.moveDistanceY = n2 - (n14 - n11);
                    n8 = n13;
                    n9 = n14;
                }
                break block6;
            }
            if (n >= 0) break block6;
            int n15 = this.getNewPointY(this.footY, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n5);
            int n16 = n3 = this.getNewPointX(this.footX, this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n5);
            int n17 = n15;
            int n18 = n3;
            int n19 = n15;
            for (int i = 0; i <= n4; ++i) {
                int n20;
                int n21 = n3 - 512 * i;
                int n22 = (n15 * n4 + n2 * i) / n4;
                if (n21 < n18 + n) {
                    n21 = n18 + n;
                    n22 = n19 + n2;
                }
                if ((n20 = this.leftSideCollisionChk(n21, n22)) >= 0) {
                    n3 = n20;
                    this.moveDistanceX = 0;
                    this.footX = this.getNewPointX(n3, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n5);
                    return true;
                }
                this.footX = this.getNewPointX(n21, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n5);
                this.footY = this.getNewPointY(n22, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_X, -this.LEFT_WALK_COLLISION_CHECK_OFFSET_Y, n5);
                this.moveDistanceX = n - (n21 - n18);
                this.moveDistanceY = n2 - (n22 - n19);
                n16 = n21;
                n17 = n22;
            }
        }
        return false;
    }

    public int getQuaParam(int n, int n2) {
        if (n > 0) {
            return n / n2;
        }
        return (n - (n2 - 1)) / n2;
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
    }

    public void draw(MFGraphics mFGraphics) {
    }

    public void refreshCollisionRect(int n, int n2) {
    }

    public int rightSideMultiPointCollisionChk(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < Math.abs(n6); ++i) {
            int n7 = this.getNewPointY(n2, n3, n4 + i * (8 * n6 / Math.abs(n6) << 6), n5);
            int n8 = this.getNewPointX(n, n3, n4 + i * (8 * n6 / Math.abs(n6) << 6), n5);
            int n9 = this.rightSideCollisionChk(n8, n7);
            if (n9 < 0) continue;
            return this.getNewPointX(n9, -n3, -(n4 + i * (8 * n6 / Math.abs(n6) << 6)), n5);
        }
        return -1;
    }

    public int leftSideMultiPointCollisionChk(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < Math.abs(n6); ++i) {
            int n7 = this.getNewPointY(n2, n3, n4 + i * (8 * n6 / Math.abs(n6) << 6), n5);
            int n8 = this.getNewPointX(n, n3, n4 + i * (8 * n6 / Math.abs(n6) << 6), n5);
            int n9 = this.leftSideCollisionChk(n8, n7);
            if (n9 < 0) continue;
            return this.getNewPointX(n9, -n3, -(n4 + i * (8 * n6 / Math.abs(n6) << 6)), n5);
        }
        return -1;
    }

    public int getNewPointX(int n, int n2, int n3, int n4) {
        int n5 = n + n2;
        return n5;
    }

    public int getNewPointY(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        return n5;
    }

    public int rightSideCollisionChk(int n, int n2) {
        int n3;
        int n4 = 0;
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512) - 1, this.getQuaParam(n2, 512), this.currentLayer, tmpBeforeBlock);
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n2, 512), this.currentLayer, tmpCurrentBlock);
        int n5 = tmpBeforeBlock.getCollisionX(n2 >> 6);
        int n6 = tmpCurrentBlock.getCollisionX(n2 >> 6);
        if (n5 < 0 && n6 >= 0) {
            n3 = Math.abs(this.moveDegree - tmpCurrentBlock.getDegreeNearby(this.moveDegree));
            if (n3 > 180) {
                n3 = 360 - n3;
            }
            int n7 = 0;
            int n8 = tmpBeforeBlock.getCollisionY(7);
            int n9 = tmpCurrentBlock.getCollisionY(0);
            n7 = Math.abs(n8 - n9);
            if ((n3 >= 45 || this.moveDegree == 0 && (n8 < 0 || n7 >= 4)) && n >= (n4 = this.getBlockLeftSide(this.getQuaParam(n, 512), this.getQuaParam(n2, 512)) + (n6 << 6) - 64)) {
                return n4;
            }
        }
        if (tmpBeforeBlock.getActualX(n2 >> 6) == 8 && tmpCurrentBlock.getActualX(n2 >> 6) != 8) {
            return -1;
        }
        if (n6 == 0 && n5 >= 0) {
            n3 = Math.abs(this.moveDegree - tmpBeforeBlock.getDegreeNearby(this.moveDegree));
            if (n3 > 180) {
                n3 = 360 - n3;
            }
            if (n3 >= 45 && n >= (n4 = this.getBlockLeftSide(this.getQuaParam(n, 512) - 1, this.getQuaParam(n2, 512)) + (n5 << 6) - 64)) {
                return n4;
            }
        }
        return -1;
    }

    public int leftSideCollisionChk(int n, int n2) {
        int n3;
        int n4 = 0;
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512) + 1, this.getQuaParam(n2, 512), this.currentLayer, tmpBeforeBlock);
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n2, 512), this.currentLayer, tmpCurrentBlock);
        int n5 = tmpBeforeBlock.getCollisionX(n2 >> 6);
        int n6 = tmpCurrentBlock.getCollisionX(n2 >> 6);
        if (n5 < 0 && n6 >= 0) {
            n3 = Math.abs(this.moveDegree - tmpCurrentBlock.getDegreeNearby(this.moveDegree));
            if (n3 > 180) {
                n3 = 360 - n3;
            }
            int n7 = 0;
            int n8 = tmpBeforeBlock.getCollisionY(0);
            int n9 = tmpCurrentBlock.getCollisionY(7);
            n7 = Math.abs(n8 - n9);
            if (n3 >= 45 || this.moveDegree == 0 && (n8 < 0 || n7 >= 4)) {
                if (n6 == 0) {
                    n6 = 7;
                }
                if (n <= (n4 = this.getBlockLeftSide(this.getQuaParam(n, 512), this.getQuaParam(n2, 512)) + (n6 << 6) + 64)) {
                    return n4;
                }
            }
        }
        if (tmpBeforeBlock.getActualX(n2 >> 6) == 8 && tmpCurrentBlock.getActualX(n2 >> 6) != 8) {
            return -1;
        }
        if (n6 == 0 && n5 >= 0) {
            n3 = Math.abs(this.moveDegree - tmpBeforeBlock.getDegreeNearby(this.moveDegree));
            if (n3 > 180) {
                n3 = 360 - n3;
            }
            if (n3 >= 45) {
                if (n5 == 0) {
                    n5 = 7;
                }
                if (n <= (n4 = this.getBlockLeftSide(this.getQuaParam(n, 512) + 1, this.getQuaParam(n2, 512)) + (n5 << 6) + 64)) {
                    return n4;
                }
            }
        }
        return -1;
    }

    public int downSideCollisionChk(int n, int n2) {
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n2, 512), this.currentLayer, tmpCurrentBlock);
        int n3 = tmpCurrentBlock.getCollisionY(n >> 6);
        if (n3 >= 0 && !tmpCurrentBlock.getReverseY(n >> 6, tmpCurrentBlock.getDegreeNearby(this.moveDegree))) {
            int n4 = this.getBlockUpSide(this.getQuaParam(n, 512), this.getQuaParam(n2, 512)) + (n3 << 6);
            int n5 = this.getQuaParam(n2, 512);
            if (n2 >= n4) {
                while (n3 >= 0) {
                    n4 = this.getBlockUpSide(this.getQuaParam(n, 512), n5) + (n3 << 6);
                    CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), --n5, this.currentLayer, tmpCurrentBlock);
                    n3 = tmpCurrentBlock.getCollisionY(n >> 6);
                }
                CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n4, 512), this.currentLayer, tmpCurrentBlock);
                int n6 = Math.abs(this.moveDegree - tmpCurrentBlock.getDegreeNearby(this.moveDegree));
                if (n6 > 180) {
                    n6 = 360 - n6;
                }
                return n4;
            }
        }
        return -1;
    }

    public void calDivideVelocity(int n) {
        this.velX = this.totalVelocity * MyAPI.dCos(n) / 100;
        this.velY = this.totalVelocity * MyAPI.dSin(n) / 100;
    }

    public void calTotalVelocity() {
        this.calTotalVelocity(this.moveDegree);
    }

    public void calTotalVelocity(int n) {
        this.totalVelocity = (this.velX * MyAPI.dCos(n) + this.velY * MyAPI.dSin(n)) / 100;
    }

    public boolean chkCrash() {
        return this.crashCount <= 0;
    }

    public void setBehavior(MapBehavior mapBehavior) {
        this.collisionBehavior = mapBehavior;
    }

    public void doJump(int n, int n2) {
        if (this.state == 0) {
            this.state = 1;
            this.velX = n;
            this.velY = n2;
            this.moveDistanceX = 0;
            this.moveDistanceY = 0;
        }
    }

    public void doStop() {
        this.totalVelocity = 0;
        this.velX = 0;
        this.velY = 0;
        this.moveDistanceX = 0;
        this.moveDistanceY = 0;
        this.collisionChkBreak = true;
    }

    public void close() {
    }
}

