/*
 * Decompiled with CFR 0.152.
 */
class Marker
extends GimmickObject {
    public static Animation markerAnimation;
    public AnimationDrawer drawer;

    public Marker(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.used = false;
        if (markerAnimation == null) {
            markerAnimation = new Animation("/animation/se_marker");
        }
        this.drawer = markerAnimation.getDrawer(0, true, 0);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.used) {
            return;
        }
        this.used = true;
        this.drawer.setActionId(1);
        this.drawer.setLoop(false);
        if (!GameState.PreGame) {
            GameObject.soundInstance.playSe(2);
        }
        if (GameObject.stageModeState == 0) {
            StageManager.saveCheckPoint(this.posX, this.posY);
        }
        playerObject.currentMarkId = this.iLeft;
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, this.drawer, this.posX, this.posY);
        if (this.drawer.checkEnd()) {
            this.drawer.setActionId(2);
            this.drawer.setLoop(true);
        }
    }

    public void logic() {
        if (this.used) {
            return;
        }
        if (GameObject.player.currentMarkId > this.iLeft) {
            this.used = true;
            this.drawer.setActionId(2);
            this.drawer.setLoop(true);
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 320, n2 - 3200, 640, 3200);
    }

    public void close() {
        this.drawer = null;
    }

    public int getPaintLayer() {
        return 0;
    }

    public static void releaseAllResource() {
        markerAnimation = null;
    }
}

