/*
 * Decompiled with CFR 0.152.
 */
class Mole
extends EnemyObject {
    public static int COLLISION_WIDTH = 1536;
    public static int COLLISION_HEIGHT = 1600;
    public static Animation moleAnimation;
    public int state;
    public int wait_cnt;
    public int wait_cnt_max = 16;

    public static void releaseAllResource() {
        moleAnimation = null;
    }

    protected Mole(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.posX -= this.iLeft * 8;
        this.posY -= this.iTop * 8;
        this.refreshCollisionRect(this.posX, this.posY);
        if (moleAnimation == null) {
            moleAnimation = new Animation("/animation/mole");
        }
        this.drawer = moleAnimation.getDrawer(0, true, 0);
        this.wait_cnt = 0;
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.dead) {
            return;
        }
        if (playerObject == GameObject.player) {
            if (GameObject.player.isAttackingEnemy()) {
                if (this.state == 1) {
                    this.beAttack();
                    SoundSystem.getInstance().playSe(2, false);
                }
            } else if (this.state == 1) {
                GameObject.player.beHurt();
            }
        }
    }

    public void logic() {
        if (this.dead) {
            this.drawer.setActionId(0);
            return;
        }
        int n = this.posX;
        int n2 = this.posY;
        switch (this.state) {
            case 0: {
                if (this.wait_cnt < this.wait_cnt_max) {
                    ++this.wait_cnt;
                } else if (this.posX < GameObject.player.getCheckPositionX()) {
                    this.drawer.setActionId(1);
                    this.drawer.setTrans(2);
                    this.drawer.setLoop(false);
                    this.state = 1;
                } else {
                    this.drawer.setActionId(1);
                    this.drawer.setTrans(0);
                    this.drawer.setLoop(false);
                    this.state = 1;
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 1: {
                if (this.drawer.checkEnd()) {
                    this.drawer.setActionId(0);
                    this.drawer.setLoop(true);
                    this.state = 0;
                    this.wait_cnt = 0;
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - (COLLISION_WIDTH >> 1), n2 - COLLISION_HEIGHT, COLLISION_WIDTH, COLLISION_HEIGHT);
    }
}

