/*
 * Decompiled with CFR 0.152.
 */
class SpringIsland
extends GimmickObject {
    public static final int SPRING_POWER = Spring.SPRING_POWER[0];
    public static Animation animation;
    public AnimationDrawer drawer;
    public boolean isH;
    public MoveCalculator moveCal;
    public int debugCollisionHeight = 0;

    protected SpringIsland(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (animation == null) {
            animation = new Animation("/animation/spring_island");
        }
        this.drawer = animation.getDrawer(0, false, 0);
        boolean bl = false;
        if (this.mWidth >= this.mHeight) {
            this.isH = true;
            bl = this.iLeft != 0;
        } else {
            this.isH = false;
            bl = this.iTop != 0;
        }
        if (this.posX == 69632 && this.posY == 35328) {
            this.debugCollisionHeight = 3200;
        }
        this.moveCal = new MoveCalculator(this.isH ? this.posX : this.posY, this.isH ? this.mWidth : this.mHeight, bl);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 768, n2 + 1856 - 2688, 1536, this.debugCollisionHeight == 0 ? 2688 : this.debugCollisionHeight);
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, this.drawer);
        if (this.drawer.checkEnd() && this.drawer.getActionId() == 1) {
            this.drawer.setActionId(0);
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        playerObject.beStop(0, n, this);
        if (n == 1) {
            playerObject.beSpring(SPRING_POWER, n);
            GameObject.soundInstance.playSe(2);
        }
    }

    public void logic() {
        int n = this.posX;
        int n2 = this.posY;
        if (this.isH) {
            this.posX = this.moveCal.getPosition();
        } else {
            this.posY = this.moveCal.getPosition();
        }
        this.checkWithPlayer(n, n2, this.posX, this.posY);
    }

    public void close() {
        this.drawer = null;
    }

    public static void releaseAllResource() {
        animation = null;
    }
}

