/*
 * Decompiled with CFR 0.152.
 */
class SpringPlatform
extends GimmickObject {
    public static MFImage image;
    public int velY;
    public int centerY;

    protected SpringPlatform(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (image == null) {
            try {
                image = MFImage.createImage("/gimmick/spring_platform.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.centerY = this.posY;
        this.velY = 0;
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, image, 3);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 1024, n2 - 1152, 2048, 2304);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        switch (n) {
            case 1: {
                if (this.firstTouch) {
                    this.velY += playerObject.getVelY();
                }
                playerObject.beStop(0, n, this);
                break;
            }
            case 4: {
                if (playerObject.getVelY() <= 0 || playerObject.getCollisionRect().y1 >= this.collisionRect.y1) break;
                playerObject.beStop(0, 1, this);
            }
        }
        if (GameObject.player.isFootOnObject(this)) {
            GameObject.player.setSqueezeEnable(false);
        }
    }

    public void logic() {
        int n = (this.centerY - this.posY) * 150 / 3840;
        int n2 = this.posX;
        int n3 = this.posY;
        this.velY += n;
        if (this.velY > 0) {
            this.velY -= 10;
        } else if (this.velY < 0) {
            this.velY += 10;
        }
        this.posY += this.velY;
        if (this.posY > this.centerY + 3840) {
            this.posY = this.centerY + 3840;
            this.velY = 0;
        }
        if (this.posY < this.centerY - 3840) {
            this.posY = this.centerY - 3840;
            this.velY = 0;
        }
        this.checkWithPlayer(n2, n3, this.posX, this.posY);
        if (!GameObject.player.isFootOnObject(this)) {
            GameObject.player.setSqueezeEnable(true);
        }
    }

    public static void releaseAllResource() {
        image = null;
    }

    public boolean collisionChkWithObject(PlayerObject playerObject) {
        CollisionRect collisionRect = playerObject.getCollisionRect();
        CollisionRect collisionRect2 = this.getCollisionRect();
        GameObject.rectV.setRect(collisionRect.x0 + 192, collisionRect.y0, collisionRect.getWidth() - 384, collisionRect.getHeight());
        return collisionRect2.collisionChk(GameObject.rectV);
    }

    public int getPaintLayer() {
        return 0;
    }
}

