/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StageManager
implements SonicDef {
    public static int stageId = 0;
    public static int preStageId = -1;
    public static final String[] STAGE_NAME_LOW_FOUR = new String[]{"1_1", "1_2", "2_1", "2_2"};
    public static final String[] STAGE_NAME_LOW_SIX = new String[]{"1_1", "1_2", "2_1", "2_2", "5_1", "5_2"};
    public static final String[] STAGE_NAME_LOW = STAGE_NAME_LOW_SIX;
    public static final String[] STAGE_NAME_HIGH = new String[]{"1_1", "1_2", "2_1", "2_2", "5_1", "5_2", "3_1", "3_2"};
    public static final String[] STAGE_NAME = STAGE_NAME_HIGH;
    public static final int[][] PLAYER_START = new int[][]{{96, 448}, {96, 672}, {96, 146}, {96, 1600}, {96, 832}, {96, 928}, {96, 160}, {96, 640}};
    public static final int[] MUSIC_ID = new int[]{0, 0, 1, 1, 3, 3, 2, 2};
    public static final int[] FAST_MUSIC_ID = new int[]{11, 11, 12, 12, 14, 14, 13, 13};
    public static final int[] ZOME_ID = new int[]{0, 0, 1, 1, 4, 4, 2, 2};
    public static final int[] STAGE_NAME_ID = new int[]{86, 87, 88, 89};
    public static final int STAGE_NUM = STAGE_NAME.length;
    public static int loadStep = 0;
    public static int stagePassCount;
    public static boolean stagePassFlag;
    public static int stageRestartCount;
    public static boolean stageRestartFlag;
    public static int stageGameoverCount;
    public static boolean stageGameoverFlag;
    public static int stageTimeoverCount;
    public static boolean stageTimeoverFlag;
    public static boolean IsCalculateScore;
    public static int[] highScore;
    public static int openedStageId;
    public static int[] timeModeScore;
    public static int drawNewScore;
    public static int[] rankingOffsetX;
    public static int movingRow;
    public static int movingCount;
    public static final int HIGH_SCORE_Y_TMP;
    public static final int HIGH_SCORE_Y;
    public static String[] RANK_STR_FOR_EN;
    public static int checkPointX;
    public static int checkPointY;
    public static boolean checkPointEnable;
    public static int checkPointTime;
    public static int normalStageId;
    public static boolean isRacing;

    public static boolean loadStageStep() {
        boolean bl = true;
        switch (loadStep) {
            case 0: {
                SoundSystem.getInstance().stopBgm(true);
                MapManager.closeMap();
                CollisionMap.closeMap();
                Key.touchkeygameboardClose();
                break;
            }
            case 1: {
                bl = GameObject.closeObjectStep(preStageId == stageId);
                break;
            }
            case 2: {
                PlayerObject.initStageParam();
                bl = MapManager.loadMapStep(stageId, STAGE_NAME[stageId]);
                break;
            }
            case 3: {
                bl = CollisionMap.loadCollisionInfoStep(STAGE_NAME[stageId]);
                break;
            }
            case 4: {
                BackGroundManager.init(stageId);
                break;
            }
            case 5: {
                GameObject.initObject(MapManager.getPixelWidth(), MapManager.getPixelHeight(), preStageId == stageId);
                preStageId = stageId;
                if (stageRestartFlag && checkPointEnable) {
                    GameObject.setPlayerPosition(checkPointX, checkPointY);
                    PlayerObject.timeCount = checkPointTime;
                } else {
                    GameObject.setPlayerPosition(PLAYER_START[stageId][0], PLAYER_START[stageId][1]);
                }
                checkPointEnable = false;
                break;
            }
            case 6: {
                bl = GameObject.loadObjectStep("/map/" + STAGE_NAME[stageId] + ".gi", 0);
                break;
            }
            case 7: {
                bl = GameObject.loadObjectStep("/map/" + STAGE_NAME[stageId] + ".ri", 1);
                break;
            }
            case 8: {
                bl = GameObject.loadObjectStep("/map/" + STAGE_NAME[stageId] + ".en", 2);
                break;
            }
            case 9: {
                bl = GameObject.loadObjectStep("/map/" + STAGE_NAME[stageId] + ".it", 3);
                Key.clear();
                stagePassFlag = false;
                stageRestartFlag = false;
                stageGameoverFlag = false;
                stageTimeoverFlag = false;
                break;
            }
            case 10: {
                SmallAnimal.animalInit();
                MapManager.focusQuickLocation();
                break;
            }
            case 11: {
                bl = false;
                Key.clear();
                GameObject.logicObjects();
                if (GameObject.player.getAnimationId() != 0) break;
                bl = true;
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                SoundSystem.getInstance().playBgm(StageManager.getBgmId(), true);
                loadStep = 0;
                return true;
            }
        }
        if (bl) {
            ++loadStep;
        }
        return false;
    }

    public static int getBgmId() {
        return MUSIC_ID[stageId];
    }

    public static int getFastBgmId() {
        return FAST_MUSIC_ID[stageId];
    }

    public static void draw(MFGraphics mFGraphics) {
        mFGraphics.setColor(0xFFFFFF);
        MyAPI.fillRect(mFGraphics, 0, 0, Def.SCREEN_WIDTH, Def.SCREEN_HEIGHT);
        for (int i = 0; i < STAGE_NAME.length; ++i) {
            mFGraphics.setColor(0);
            if (i == stageId) {
                mFGraphics.setColor(0xFF0000);
            }
            MyAPI.drawString(mFGraphics, "stage" + STAGE_NAME[i], Def.SCREEN_WIDTH >> 1, 20 + 20 * i, 17);
        }
    }

    public static int getCurrentZoneId() {
        return ZOME_ID[stageId] + 1;
    }

    public static void setStagePass() {
        if (!stagePassFlag) {
            stagePassFlag = true;
            stagePassCount = 0;
        }
    }

    public static void setStageRestart() {
        if (!stageRestartFlag) {
            stageRestartFlag = true;
            stageRestartCount = 10;
        }
    }

    public static void setStageGameover() {
        if (!stageGameoverFlag) {
            stageGameoverFlag = true;
            stageGameoverCount = 10;
        }
    }

    public static void stageLogic() {
        if (stagePassFlag && stagePassCount > 0) {
            --stagePassCount;
        }
        if (stageRestartFlag && stageRestartCount > 0) {
            --stageRestartCount;
        }
        if (stageGameoverFlag && stageGameoverCount > 0) {
            --stageGameoverCount;
        }
        if (stageTimeoverFlag && stageTimeoverCount > 0) {
            --stageTimeoverCount;
        }
    }

    public static boolean isStagePassTimePause() {
        return stagePassFlag;
    }

    public static boolean isStagePass() {
        return stagePassFlag && stagePassCount == 0;
    }

    public static boolean isStageRestart() {
        return stageRestartFlag && stageRestartCount == 0;
    }

    public static boolean isStageGameover() {
        return stageGameoverFlag && stageGameoverCount == 0;
    }

    public static boolean isStageTimeover() {
        return stageTimeoverFlag && stageTimeoverCount == 0;
    }

    public static void setStageID(int n) {
        stageId = n;
    }

    public static int getStageID() {
        return stageId;
    }

    public static void addStageID() {
        ++stageId;
    }

    public static boolean IsStageEnd() {
        return stageId == STAGE_NAME.length;
    }

    public static int getTimeModeScore() {
        return StageManager.getTimeModeScore(stageId);
    }

    public static void setTimeModeScore(int n) {
        StageManager.timeModeScore[StageManager.stageId] = n;
    }

    public static int getTimeModeScore(int n) {
        return timeModeScore[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadStageRecord() {
        ByteArrayInputStream byteArrayInputStream = Record.loadRecordStream("SONIC_STAGE_RECORD");
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            stageId = dataInputStream.readByte();
            PlayerObject.setScore(dataInputStream.readInt());
            openedStageId = dataInputStream.readByte();
            if (openedStageId >= STAGE_NUM) {
                openedStageId = STAGE_NUM - 1;
            }
            for (n = 0; n < 5; ++n) {
                StageManager.highScore[n] = dataInputStream.readInt();
            }
            for (n = 0; n < STAGE_NUM; ++n) {
                StageManager.timeModeScore[n] = dataInputStream.readInt();
            }
            PlayerObject.lifeNum = dataInputStream.readByte();
            normalStageId = dataInputStream.readByte();
            if (normalStageId != stageId) {
                stageId = normalStageId;
            }
        }
        catch (Exception exception) {
            stageId = 0;
            normalStageId = 0;
            PlayerObject.setScore(0);
            openedStageId = 0;
            StageManager.highScore[0] = 12345;
            StageManager.highScore[1] = 2345;
            StageManager.highScore[2] = 345;
            StageManager.highScore[3] = 45;
            StageManager.highScore[4] = 5;
            PlayerObject.resetGameParam();
            for (int i = 0; i < STAGE_NUM; ++i) {
                StageManager.timeModeScore[i] = 599999;
            }
            StageManager.saveStageRecord();
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStageRecord() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n;
            dataOutputStream.writeByte(stageId);
            dataOutputStream.writeInt(PlayerObject.getScore());
            if (openedStageId < stageId) {
                openedStageId = stageId;
            }
            if (openedStageId >= STAGE_NUM) {
                openedStageId = STAGE_NUM - 1;
            }
            dataOutputStream.writeByte(openedStageId);
            for (n = 0; n < 5; ++n) {
                dataOutputStream.writeInt(highScore[n]);
            }
            for (n = 0; n < STAGE_NUM; ++n) {
                dataOutputStream.writeInt(timeModeScore[n]);
            }
            dataOutputStream.writeByte(PlayerObject.lifeNum);
            if (!isRacing && normalStageId != stageId) {
                normalStageId = stageId;
            }
            dataOutputStream.writeByte(normalStageId);
            Record.saveRecordStream("SONIC_STAGE_RECORD", byteArrayOutputStream);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void addNewNormalScore(int n) {
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < 5; ++i) {
            if (!bl) {
                if (n <= highScore[i]) continue;
                bl = true;
                n2 = highScore[i];
                StageManager.highScore[i] = n;
                drawNewScore = i;
                continue;
            }
            int n3 = highScore[i];
            StageManager.highScore[i] = n2;
            n2 = n3;
        }
        if (bl) {
            // empty if block
        }
    }

    public static void normalHighScoreInit() {
        movingRow = 0;
        movingCount = 0;
        for (int i = 0; i < rankingOffsetX.length; ++i) {
            StageManager.rankingOffsetX[i] = Def.SCREEN_WIDTH;
        }
    }

    public static void drawNormalHighScore(MFGraphics mFGraphics) {
        int n;
        String string = State.allStrings[48];
        for (n = 0; n < 4; ++n) {
            int n2 = string.indexOf(" ");
            StageManager.RANK_STR_FOR_EN[n] = string.substring(0, n2);
            string = string.substring(n2 + 1, string.length());
        }
        StageManager.RANK_STR_FOR_EN[4] = string;
        string = null;
        for (n = 0; n < 5; ++n) {
            if (drawNewScore == n && System.currentTimeMillis() / 300L % 2L == 0L) {
                MyAPI.setBmfColor(1);
                State.drawMenuFontByString(mFGraphics, RANK_STR_FOR_EN[n], (Def.SCREEN_WIDTH >> 1) - 45 + rankingOffsetX[n] + -8, HIGH_SCORE_Y + SonicDef.MENU_SPACE * n + 30, 17);
                PlayerObject.drawNum(mFGraphics, highScore[n], (Def.SCREEN_WIDTH >> 1) + 20 + 48 + rankingOffsetX[n] + -8, HIGH_SCORE_Y + SonicDef.MENU_SPACE * n + 30, 2, 4);
                continue;
            }
            State.drawMenuFontByString(mFGraphics, RANK_STR_FOR_EN[n], (Def.SCREEN_WIDTH >> 1) - 45 + rankingOffsetX[n] + -8, HIGH_SCORE_Y + SonicDef.MENU_SPACE * n + 30, 17);
            PlayerObject.drawNum(mFGraphics, highScore[n], (Def.SCREEN_WIDTH >> 1) + 20 + 48 + rankingOffsetX[n] + -8, HIGH_SCORE_Y + SonicDef.MENU_SPACE * n + 30, 2, 0);
        }
        if (movingRow < rankingOffsetX.length && movingCount % 2 == 0) {
            ++movingRow;
        }
        ++movingCount;
        for (n = 0; n < movingRow; ++n) {
            StageManager.rankingOffsetX[n] = MyAPI.calNextPosition(rankingOffsetX[n], 0, 1, 3);
        }
    }

    public static void drawHighScoreEnd() {
        drawNewScore = -1;
    }

    public static int getOpenedStageId() {
        return openedStageId;
    }

    public static void saveCheckPoint(int n, int n2) {
        checkPointX = n >> 6;
        checkPointY = n2 >> 6;
        checkPointEnable = true;
        checkPointTime = PlayerObject.timeCount;
    }

    public static void resetStageId() {
        if (openedStageId < stageId) {
            openedStageId = stageId;
        }
        stageId = 0;
        normalStageId = 0;
        StageManager.saveStageRecord();
    }

    public static void resetGameRecord() {
        StageManager.highScore[0] = 12345;
        StageManager.highScore[1] = 2345;
        StageManager.highScore[2] = 345;
        StageManager.highScore[3] = 45;
        StageManager.highScore[4] = 5;
        for (int i = 0; i < STAGE_NUM; ++i) {
            StageManager.timeModeScore[i] = 599999;
        }
        openedStageId = 0;
        stageId = 0;
        normalStageId = 0;
        StageManager.saveStageRecord();
    }

    public static void doWhileEnterRace() {
        if (!isRacing) {
            normalStageId = stageId;
            isRacing = true;
        }
    }

    public static void doWhileLeaveRace() {
        if (isRacing) {
            stageId = normalStageId;
            isRacing = false;
        }
    }

    public static int getStageNameID(int n) {
        return STAGE_NAME_ID[n / 2];
    }

    static {
        highScore = new int[5];
        openedStageId = 0;
        timeModeScore = new int[STAGE_NUM];
        drawNewScore = -1;
        rankingOffsetX = new int[5];
        movingRow = 0;
        movingCount = 0;
        HIGH_SCORE_Y_TMP = Def.SCREEN_HEIGHT - SonicDef.MENU_SPACE * 5 >> 1;
        HIGH_SCORE_Y = 40 + Def.FONT_H_HALF;
        RANK_STR_FOR_EN = new String[5];
        isRacing = false;
    }
}

