/*
 * Decompiled with CFR 0.152.
 */
class StoneBall
extends GimmickObject {
    public static Animation animation;
    public AnimationDrawer drawer;
    public boolean noBall;
    public int originalX;
    public int originalY;
    public MapObject mapObj;
    public int waitCount;
    public byte state;

    protected StoneBall(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (animation == null) {
            animation = new Animation("/animation/stone_ball");
        }
        this.drawer = animation.getDrawer(0, true, 0);
        this.noBall = true;
        this.originalX = this.posX;
        this.originalY = this.posY;
        this.mapObj = new MapObject(this.posX + 2048, this.posY, 0, 0, this, this.iLeft);
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.state != 0) {
            this.drawInMap(mFGraphics, this.drawer);
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 896, n2 - 1792, 1792, 1792);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.state != 0) {
            playerObject.beHurt();
        }
    }

    public void logic() {
        int n = this.posX;
        int n2 = this.posY;
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        switch (this.state) {
            case 0: {
                this.posX = this.originalX;
                this.posY = this.originalY;
                this.transportTo(this.posX, this.posY);
                if (this.waitCount != 0) break;
                this.state = 1;
                break;
            }
            case 1: {
                this.posX += 300;
                if (this.posX > this.originalX + 2048) {
                    this.state = (byte)2;
                    this.mapObj.setPosition(this.posX, this.posY, 300, 0, this);
                    this.mapObj.setCrashCount(2);
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 2: {
                this.mapObj.logic();
                this.checkWithPlayer(this.posX, this.posY, this.mapObj.getPosX(), this.mapObj.getPosY());
                this.posX = this.mapObj.getPosX();
                this.posY = this.mapObj.getPosY();
                if (!this.mapObj.chkCrash()) break;
                this.state = 0;
                this.waitCount = 20;
                Effect.showEffect(GameObject.rockBreakAnimation, 0, this.posX >> 6, this.posY >> 6, 0);
            }
        }
    }

    public void close() {
        this.drawer = null;
    }

    public static void releaseAllResource() {
        animation = null;
    }
}

