/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public class Animation {
    public static final int TRANS_OFFSET = MyAPI.ZOOM_OUT_MOVE == 3 ? MyAPI.zoomOut(1) : 1;
    public int m_CurAni = 0;
    public int m_OldAni = 0;
    public int m_nActions;
    public Action[] m_Actions;
    public int m_nFrames;
    public Frame[] m_Frames;
    public ImageInfo[] imageInfo;
    protected String fileName = null;
    public static int[] imageIdArray = new int[10];

    public Animation() {
    }

    public Animation(String string) {
        this.fileName = string;
        this.SetClipImg(string + ".png");
        this.LoadAnimation(string + ".dat");
    }

    public Animation(MFImage mFImage, String string) {
        this.fileName = string;
        this.imageInfo = new ImageInfo[1];
        this.imageInfo[0] = new ImageInfo(mFImage);
        this.LoadAnimation(string + ".dat");
    }

    public void SetCurAni(int n) {
        if (n >= this.m_nActions) {
            n = 0;
        }
        this.m_CurAni = n;
        if (this.m_OldAni != this.m_CurAni) {
            this.m_OldAni = this.m_CurAni;
            this.m_Actions[this.m_CurAni].JumpFrame((byte)0);
            this.m_Actions[this.m_CurAni].SetPause(false);
        }
    }

    public void SetCurFrame(byte by) {
        this.m_Actions[this.m_CurAni].SetFrame(by);
    }

    public void SetLoop(boolean bl) {
        this.m_Actions[this.m_CurAni].SetLoop(bl);
    }

    public void SetClipImg(String string) {
        try {
            this.imageInfo = new ImageInfo[1];
            this.imageInfo[0] = new ImageInfo(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void LoadAnimation(String string) {
        InputStream inputStream = MFDevice.getResourceAsStream(string);
        this.LoadAnimation(inputStream);
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void LoadAnimation(InputStream inputStream) {
        if (inputStream != null) {
            try {
                int n;
                this.imageInfo[0].loadInfo(inputStream);
                this.m_nFrames = (byte)inputStream.read();
                if (this.m_nFrames < 0) {
                    this.m_nFrames += 256;
                }
                this.m_Frames = new Frame[this.m_nFrames];
                for (n = 0; n < this.m_nFrames; ++n) {
                    this.m_Frames[n] = new Frame(this);
                    this.m_Frames[n].LoadFrame(inputStream);
                    this.m_Frames[n].SetClips(this.imageInfo[0].m_Clips);
                }
                this.m_nActions = (byte)inputStream.read();
                if (this.m_nActions < 0) {
                    this.m_nActions += 256;
                }
                this.m_Actions = new Action[this.m_nActions];
                for (n = 0; n < this.m_nActions; ++n) {
                    this.m_Actions[n] = new Action(this);
                    this.m_Actions[n].LoadAction(inputStream);
                    this.m_Actions[n].SetFrames(this.m_Frames);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                int n;
                this.m_nFrames = 1;
                this.m_Frames = new Frame[this.m_nFrames];
                for (n = 0; n < this.m_nFrames; ++n) {
                    this.m_Frames[n] = new Frame(this);
                    this.m_Frames[n].LoadFrame(inputStream);
                    this.m_Frames[n].SetClips(this.imageInfo[0].m_Clips);
                }
                this.m_nActions = 1;
                this.m_Actions = new Action[this.m_nActions];
                for (n = 0; n < this.m_nActions; ++n) {
                    this.m_Actions[n] = new Action(this);
                    this.m_Actions[n].LoadAction();
                    this.m_Actions[n].SetFrames(this.m_Frames);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void DrawAni(MFGraphics mFGraphics, short s, byte by, int n, int n2, short s2) {
        this.m_Actions[s].Draw(mFGraphics, by, n, n2, s2);
    }

    public AnimationDrawer getDrawer(int n, boolean bl, int n2) {
        return new AnimationDrawer(this, n, bl, n2);
    }

    public AnimationDrawer getDrawer() {
        return new AnimationDrawer(this);
    }

    public int getFrameNum(int n) {
        return this.m_Actions[n].getFrameNum();
    }

    public boolean isTimeOver(int n) {
        return this.m_Actions[this.m_CurAni].isTimeOver(n);
    }

    public int getWidthWithFrameId(int n, int n2) {
        return this.m_Frames[this.m_Actions[n].m_FrameInfo[n2][0]].getWidth();
    }

    public int getHeightWithFrameId(int n, int n2) {
        return this.m_Frames[this.m_Actions[n].m_FrameInfo[n2][0]].getHeight();
    }

    static class ImageInfo {
        public short m_nClips;
        public short[][] m_Clips;
        protected MFImage img_clip;

        public ImageInfo() {
        }

        public ImageInfo(MFImage mFImage) {
            this.img_clip = mFImage;
        }

        public ImageInfo(String string) {
            this.img_clip = MFImage.createImage(string);
        }

        public void loadInfo(InputStream inputStream) throws IOException {
            if (inputStream == null) {
                this.m_nClips = 1;
                this.m_Clips = new short[this.m_nClips][4];
                for (int i = 0; i < this.m_nClips; ++i) {
                    this.m_Clips[i][0] = 0;
                    this.m_Clips[i][1] = 0;
                    this.m_Clips[i][2] = (short)(this.img_clip.getWidth() & 0xFFFF);
                    this.m_Clips[i][3] = (short)(this.img_clip.getHeight() & 0xFFFF);
                }
                return;
            }
            this.m_nClips = (byte)inputStream.read();
            if (this.m_nClips < 0) {
                this.m_nClips = (short)(this.m_nClips + 256);
            }
            this.m_Clips = new short[this.m_nClips][4];
            for (int i = 0; i < this.m_nClips; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.m_Clips[i][j] = MyAPI.ZOOM_OUT_MOVE == 3 ? (short)MyAPI.zoomOut(Const.ReadShort(inputStream)) : Const.ReadShort(inputStream);
                }
            }
        }

        public MFImage getImage() {
            return this.img_clip;
        }

        public short[][] getClips() {
            return this.m_Clips;
        }
    }

    class Action {
        protected Animation m_Ani;
        public short m_nFrames;
        public byte m_CurFrame;
        public byte m_OldFrame;
        public short m_Timer;
        public byte[][] m_FrameInfo;
        public boolean m_bLoop;
        public boolean m_bPause;

        public Action(Animation animation2) {
            this.m_Ani = animation2;
            this.m_Timer = 0;
            this.m_CurFrame = 0;
            this.m_OldFrame = 0;
            this.m_bLoop = true;
        }

        public void SetLoop(boolean bl) {
            this.m_bLoop = bl;
        }

        public void JumpFrame(byte by) {
            if (by < this.m_nFrames) {
                this.m_Timer = 0;
                this.m_CurFrame = by;
            }
        }

        public void LoadAction(InputStream inputStream) {
            try {
                this.m_nFrames = (byte)inputStream.read();
                if (this.m_nFrames == 0) {
                    // empty if block
                }
                this.m_FrameInfo = new byte[this.m_nFrames][2];
                for (int i = 0; i < this.m_nFrames; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        this.m_FrameInfo[i][j] = (byte)inputStream.read();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void LoadAction() {
            this.m_nFrames = 1;
            this.m_FrameInfo = new byte[this.m_nFrames][2];
            for (int i = 0; i < this.m_nFrames; ++i) {
                this.m_FrameInfo[i][0] = 0;
                this.m_FrameInfo[i][1] = 100;
            }
        }

        public void SetFrames(Frame[] frameArray) {
            Animation.this.m_Frames = frameArray;
        }

        public void SetPause(boolean bl) {
            this.m_bPause = bl;
        }

        public void Draw(MFGraphics mFGraphics, byte by, int n, int n2, short s) {
            if (by < this.m_nFrames) {
                this.m_CurFrame = by;
                int n3 = this.m_FrameInfo[by][0];
                if (n3 < 0) {
                    n3 += 256;
                }
                Animation.this.m_Frames[n3].Draw(mFGraphics, n, n2, s);
            }
        }

        public void SetFrame(byte by) {
            if (by < this.m_nFrames) {
                this.m_CurFrame = by;
            }
        }

        public int getFrameNum() {
            return this.m_nFrames;
        }

        public boolean isTimeOver(int n) {
            if (this.m_nFrames == 0) {
                return true;
            }
            return n >= this.m_FrameInfo[this.m_CurFrame][1];
        }
    }

    public class Frame {
        public Animation m_Ani;
        public byte[] rect1;
        public byte[] rect2;
        public byte[] tmp_rect1;
        public byte[] tmp_rect2;
        public byte m_nClips;
        public short[][] m_ClipInfo;
        public short frameWidth;
        public short frameHeight;

        public Frame(Animation animation2) {
            this.m_Ani = animation2;
            this.rect1 = new byte[4];
            this.rect2 = new byte[4];
            this.tmp_rect1 = new byte[4];
            this.tmp_rect2 = new byte[4];
            this.frameWidth = (short)-1;
            this.frameHeight = (short)-1;
        }

        public void LoadFrame(InputStream inputStream) {
            if (inputStream != null) {
                try {
                    inputStream.read(this.rect1, 0, 4);
                    inputStream.read(this.rect2, 0, 4);
                    this.m_nClips = (byte)inputStream.read();
                    this.m_ClipInfo = new short[this.m_nClips][5];
                    for (int i = 0; i < this.m_nClips; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            this.m_ClipInfo[i][j] = (byte)inputStream.read();
                            if (j <= 1 || this.m_ClipInfo[i][j] >= 0) continue;
                            short[] sArray = this.m_ClipInfo[i];
                            int n = j;
                            sArray[n] = (short)(sArray[n] + 256);
                        }
                        this.m_ClipInfo[i][4] = 0;
                        if (MyAPI.ZOOM_OUT_MOVE == 3) {
                            this.m_ClipInfo[i][0] = (short)MyAPI.zoomOut(this.m_ClipInfo[i][0]);
                            this.m_ClipInfo[i][1] = (short)MyAPI.zoomOut(this.m_ClipInfo[i][1]);
                            continue;
                        }
                        this.m_ClipInfo[i][0] = this.m_ClipInfo[i][0];
                        this.m_ClipInfo[i][1] = this.m_ClipInfo[i][1];
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.m_nClips = 1;
                this.m_ClipInfo = new short[1][4];
                this.m_ClipInfo[0][0] = 0;
                this.m_ClipInfo[0][1] = 0;
                this.m_ClipInfo[0][2] = 0;
                this.m_ClipInfo[0][3] = 0;
                this.m_ClipInfo[0][4] = 0;
            }
        }

        public int getWidth() {
            short s;
            if (this.m_nClips <= 0) {
                return 0;
            }
            int s2 = Integer.MAX_VALUE;
            int n = Integer.MIN_VALUE;
            for (int i = 0; i < this.m_nClips; ++i) {
                if (this.m_ClipInfo[i][0] < s) {
                    s = this.m_ClipInfo[i][0];
                }
                short[][] sArray = Animation.this.imageInfo[this.m_ClipInfo[i][4]].getClips();
                short s3 = (short)(this.m_ClipInfo[i][3] << 8);
                int n2 = 2;
                if ((s3 & 0x1000) != 0) {
                    n2 = 3;
                }
                if (sArray[this.m_ClipInfo[i][2]][n2] + this.m_ClipInfo[i][0] <= n) continue;
                n = sArray[this.m_ClipInfo[i][2]][n2] + this.m_ClipInfo[i][0];
            }
            this.frameWidth = (short)Math.abs(n - s);
            return this.frameWidth;
        }

        public int getHeight() {
            short s;
            if (this.m_nClips <= 0) {
                return 0;
            }
            int s2 = Integer.MAX_VALUE;
            int n = Integer.MIN_VALUE;
            for (int i = 0; i < this.m_nClips; ++i) {
                if (this.m_ClipInfo[i][1] < s) {
                    s = this.m_ClipInfo[i][1];
                }
                short[][] sArray = Animation.this.imageInfo[this.m_ClipInfo[i][4]].getClips();
                short s3 = (short)(this.m_ClipInfo[i][3] << 8);
                int n2 = 3;
                if ((s3 & 0x1000) != 0) {
                    n2 = 2;
                }
                if (sArray[this.m_ClipInfo[i][2]][n2] + this.m_ClipInfo[i][1] <= n) continue;
                n = sArray[this.m_ClipInfo[i][2]][n2] + this.m_ClipInfo[i][1];
            }
            this.frameHeight = (short)Math.abs(n - s);
            return this.frameHeight;
        }

        public void SetClips(short[][] sArray) {
        }

        public void Draw(MFGraphics mFGraphics, int n, int n2, short n3) {
            boolean bl = false;
            if (this.m_nClips == 0) {
                return;
            }
            short s = 0;
            bl = true;
            for (int i = 0; i < this.m_nClips; ++i) {
                short[][] sArray = Animation.this.imageInfo[this.m_ClipInfo[i][4]].getClips();
                int n4 = n3;
                s = (short)(this.m_ClipInfo[i][3] << 8);
                short s2 = this.m_ClipInfo[i][0];
                short s3 = this.m_ClipInfo[i][1];
                if ((n3 & 0x2000) != 0) {
                    s2 = (s & 0x1000) != 0 ? (short)(-(s2 + sArray[this.m_ClipInfo[i][2]][3])) : (short)(-(s2 + sArray[this.m_ClipInfo[i][2]][2]));
                }
                if ((n3 & 0x4000) != 0) {
                    s3 = (s & 0x1000) != 0 ? (short)(-(s3 + sArray[this.m_ClipInfo[i][2]][2])) : (short)(-(s3 + sArray[this.m_ClipInfo[i][2]][3]));
                }
                if ((n3 & 0x1000) != 0) {
                    s2 = this.m_ClipInfo[i][1];
                    s3 = (short)(-this.m_ClipInfo[i][0] - sArray[this.m_ClipInfo[i][2]][2]);
                    if ((n3 & 0x2000) != 0 && (n3 & 0x4000) != 0) {
                        s2 = (s & 0x1000) == 0 ? (short)(-this.m_ClipInfo[i][1] - sArray[this.m_ClipInfo[i][2]][3]) : (short)(-this.m_ClipInfo[i][1] - sArray[this.m_ClipInfo[i][2]][2]);
                        s3 = this.m_ClipInfo[i][0];
                    } else if ((n3 & 0x2000) != 0) {
                        s2 = (short)(-this.m_ClipInfo[i][1] - sArray[this.m_ClipInfo[i][2]][3]);
                    } else if ((n3 & 0x4000) != 0) {
                        s3 = this.m_ClipInfo[i][0];
                    }
                    if ((s & 0x1000) != 0 && (s & 0x4000) != 0 && (n3 & 0x4000) == 0) {
                        s3 = (short)(s3 - sArray[this.m_ClipInfo[i][2]][2]);
                        if ((n3 & 0x2000) != 0) {
                            s2 = (short)(s2 + sArray[this.m_ClipInfo[i][2]][2]);
                        }
                    }
                }
                if ((s & 0x1000) != 0 && (s & 0x6000) == 0) {
                    if ((n3 & 0x1000) != 0) {
                        s2 = (n3 & 0x2000) != 0 ? (short)(s2 + TRANS_OFFSET) : (short)(s2 - TRANS_OFFSET);
                    } else {
                        s3 = (n3 & 0x4000) != 0 ? (short)(s3 + TRANS_OFFSET) : (short)(s3 - TRANS_OFFSET);
                    }
                }
                if ((s & 0x1000) != 0 && (n3 & 0x1000) != 0) {
                    if ((s & 0x6000) == 0) {
                        s = (short)(s ^ 0x1000);
                        n4 ^= 0x1000;
                        s = (short)(s ^ 0x6000);
                    } else if ((n3 & 0x4000) == 0) {
                        s3 = (short)(s3 - TRANS_OFFSET);
                        if ((n3 & 0x2000) != 0) {
                            s2 = (short)(s2 + TRANS_OFFSET);
                        }
                    }
                }
                int n5 = (s & 0x2000) != 0 ? TRANS_OFFSET : -TRANS_OFFSET;
                if ((s & 0x2000) != 0 ^ (s & 0x4000) != 0) {
                    if ((n3 & 0x1000) != 0) {
                        s = (short)(s ^ 0x6000);
                        s3 = (n3 & 0x4000) != 0 ? (short)(s3 - n5) : (short)(s3 + n5);
                    } else {
                        s2 = (n3 & 0x2000) != 0 ? (short)(s2 + n5) : (short)(s2 - n5);
                    }
                }
                s = (short)(s ^ n4);
                Const.DrawImage(mFGraphics, s2 + n, s3 + n2, Animation.this.imageInfo[this.m_ClipInfo[i][4]].getImage(), sArray[this.m_ClipInfo[i][2]][0], sArray[this.m_ClipInfo[i][2]][1], sArray[this.m_ClipInfo[i][2]][2], sArray[this.m_ClipInfo[i][2]][3], s);
            }
        }
    }
}

