/*
 * Decompiled with CFR 0.152.
 */
class Arm
extends GimmickObject {
    public byte state;
    public int posYOriginal;
    public int posXOriginal;
    public static MFImage armImage;
    public static MFImage barImage;
    public static MFImage baseImage;
    public int count;

    protected Arm(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.posYOriginal = this.posY;
        this.posXOriginal = this.posX;
        this.posY = this.posYOriginal + 3328;
        this.state = 0;
        if (armImage == null) {
            try {
                armImage = MFImage.createImage("/gimmick/arm.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (barImage == null) {
            try {
                barImage = MFImage.createImage("/gimmick/arm_bar.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (baseImage == null) {
            try {
                baseImage = MFImage.createImage("/gimmick/part_1_2.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        switch (this.state) {
            case 0: {
                this.state = 1;
                GameObject.player.setOutOfControl(this);
                GameObject.player.doWalkPoseInAir();
            }
        }
    }

    public void logic() {
        if (this.count > 0) {
            --this.count;
        }
        switch (this.state) {
            case 1: {
                this.posY -= 300;
                if (this.posY > this.posYOriginal) break;
                this.posY = this.posYOriginal;
                this.state = (byte)2;
                break;
            }
            case 2: {
                this.posX += 300;
                if (this.posX < this.posXOriginal + this.mWidth) break;
                this.posX = this.posXOriginal + this.mWidth;
                GameObject.player.outOfControl = false;
                GameObject.player.collisionState = 1;
                GameObject.player.velY = 0;
                GameObject.player.doWalkPoseInAir();
                this.count = 16;
                this.state = (byte)5;
                break;
            }
            case 5: {
                if (this.count != 0) break;
                this.state = (byte)3;
                break;
            }
            case 3: {
                this.posX -= 300;
                if (this.posX > this.posXOriginal) break;
                this.posX = this.posXOriginal;
                this.state = (byte)4;
                break;
            }
            case 4: {
                this.posY += 300;
                if (this.posY < this.posYOriginal + 3328) break;
                this.posY = this.posYOriginal + 3328;
                this.state = 0;
            }
        }
        this.refreshCollisionRect(this.posX, this.posY);
        if (GameObject.player.outOfControl && GameObject.player.outOfControlObject == this) {
            int n = GameObject.player.getFootPositionX();
            int n2 = GameObject.player.getFootPositionY();
            GameObject.player.doPullMotion(this.posX, this.posY + 2304);
            GameObject.player.checkWithObject(n, n2, GameObject.player.getFootPositionX(), GameObject.player.getFootPositionY());
        }
    }

    public void draw(MFGraphics mFGraphics) {
        int n;
        this.drawInMap(mFGraphics, baseImage, 0, 0, 8, 8, 0, 17);
        for (n = 0; n < this.posY - this.posYOriginal - 1536; n += 1536) {
            this.drawInMap(mFGraphics, barImage, this.posX, this.posYOriginal + n, 17);
        }
        this.drawInMap(mFGraphics, barImage, 0, 0, 6, this.posY - this.posYOriginal - n >> 6, 0, this.posX, this.posYOriginal + n, 17);
        this.drawInMap(mFGraphics, armImage, 0, this.catching() ? 0 : 31, 36, this.catching() ? 31 : 36, 0, 17);
        this.drawCollisionRect(mFGraphics);
    }

    public boolean catching() {
        return this.state == 1 || this.state == 2;
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 1024, n2 + 2304 - 1024, 2048, 1024);
    }

    public void close() {
    }

    public static void releaseAllResource() {
    }
}

