/*
 * Decompiled with CFR 0.152.
 */
class Clown
extends EnemyObject {
    public int velocity = 192;
    public int limitLeftX = this.posX;
    public int limitRightX = this.posX + this.mWidth;
    public static Animation clownAnimation;
    public boolean touching;

    public static void releaseAllResource() {
        clownAnimation = null;
    }

    protected Clown(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (clownAnimation == null) {
            clownAnimation = new Animation("/animation/clown");
        }
        this.drawer = clownAnimation.getDrawer(0, true, 0);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.dead) {
            return;
        }
        if (playerObject == GameObject.player && !this.touching) {
            if (GameObject.player.isAttackingEnemy()) {
                if (GameObject.player.isOnGound()) {
                    this.PlayerHurtBall(playerObject, n);
                } else {
                    GameObject.player.doAttackPose(this, n);
                    this.beAttack();
                    SoundSystem.getInstance().playSe(2, false);
                }
            } else {
                GameObject.player.beHurt();
            }
            this.touching = true;
        }
    }

    public void doWhileNoCollision() {
        this.touching = false;
    }

    public void PlayerHurtBall(PlayerObject playerObject, int n) {
        int n2 = -GameObject.player.getVelX();
        if (this.velocity > 0) {
            if (GameObject.player.getVelX() < 0) {
                this.velocity = -this.velocity;
                this.drawer.setActionId(0);
                this.drawer.setTrans(2);
            }
        } else if (GameObject.player.getVelX() > 0) {
            this.velocity = -this.velocity;
            this.drawer.setActionId(0);
            this.drawer.setTrans(0);
        }
        int n3 = GameObject.player.getAnimationId();
        switch (n) {
            case 3: {
                playerObject.beStop(this.collisionRect.x0, n, this);
                break;
            }
            case 2: {
                playerObject.beStop(this.collisionRect.x1, n, this);
                break;
            }
            case 0: {
                playerObject.beStop(this.collisionRect.y1, n, this);
                break;
            }
            case 1: 
            case 4: {
                playerObject.beStop(this.collisionRect.y0, n, this);
            }
        }
        GameObject.player.setVelX(n2);
        GameObject.player.setAnimationId(n3);
    }

    public void logic() {
        if (this.dead) {
            return;
        }
        int n = this.posX;
        int n2 = this.posY;
        if (this.velocity > 0) {
            this.posX += this.velocity;
            this.drawer.setActionId(0);
            this.drawer.setTrans(2);
            if (this.posX >= this.limitRightX) {
                this.posX = this.limitRightX;
                this.velocity = -this.velocity;
            }
        } else {
            this.posX += this.velocity;
            this.drawer.setActionId(0);
            this.drawer.setTrans(0);
            if (this.posX <= this.limitLeftX) {
                this.posX = this.limitLeftX;
                this.velocity = -this.velocity;
            }
        }
        this.posY = this.getGroundY(this.posX, this.posY);
        this.checkWithPlayer(n, n2, this.posX, this.posY);
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.dead) {
            return;
        }
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 896, n2 - 3072, 1792, 3072);
    }
}

