/*
 * Decompiled with CFR 0.152.
 */
class FreeFallBar
extends GimmickObject {
    public FreeFallSystem system;
    public static MFImage barImage;

    protected FreeFallBar(FreeFallSystem freeFallSystem, int n, int n2) {
        super(0, n, n2, 0, 0, 0, 0);
        this.system = freeFallSystem;
        if (barImage == null) {
            try {
                barImage = MFImage.createImage("/gimmick/freefall_bar.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void barLogic() {
        Coordinate coordinate = this.system.getBarPosition();
        this.posX = coordinate.x;
        this.posY = coordinate.y;
        this.refreshCollisionRect(this.posX, this.posY);
        if (this.system.moving) {
            GameObject.player.setFootPositionY(this.posY - 640);
            GameObject.player.setFootPositionX(this.posX);
        }
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.system.moving) {
            if (GameObject.player.getAnimationId() == 22) {
                GameObject.player.drawSonic(mFGraphics);
                this.drawInMap(mFGraphics, barImage, 33);
            } else if (GameObject.player.getAnimationId() == 23) {
                this.drawInMap(mFGraphics, barImage, 33);
                GameObject.player.drawSonic(mFGraphics);
            } else {
                GameObject.player.setAnimationId(23);
            }
        } else {
            this.drawInMap(mFGraphics, barImage, 33);
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (!this.used && !this.system.moving) {
            this.used = true;
            this.system.moving = true;
            GameObject.player.changeVisible(false);
            GameObject.player.setOutOfControl(this);
            switch (n) {
                case 2: {
                    GameObject.player.setAnimationId(23);
                    break;
                }
                case 3: {
                    GameObject.player.setAnimationId(22);
                }
            }
            GameObject.player.cancelFootObject();
            GameObject.player.collisionChkBreak = true;
            GameObject.player.collisionState = 1;
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 512, n2 - 2560, 1024, 2560);
    }

    public void close() {
        this.system = null;
    }

    public static void releaseAllResource() {
        barImage = null;
    }

    public int getPaintLayer() {
        return 0;
    }
}

