/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public final class MFPlayer
implements PlayerListener {
    public static final String[] SOUND_EXT = new String[]{".mid", ".wav", ".mp3", ".amr"};
    public static final int[] SOUND_TYPE = new int[]{0, 1, 2, 3};
    public static final String[] SOUND_TYPE_CONTENT = new String[]{"audio/midi", "audio/x-wav", "audio/mpeg", "audio/amr"};
    public static final String[] STATE_NAME = new String[]{"UNREALIZED", "REALIZED", "PREFETCHED", "STARTED", "CLOSED"};
    protected String soundUrl;
    protected int soundPriority;
    public int soundVolume;
    public int deviceVolume;
    public int soundType;
    public boolean soundLoop;
    public boolean deviceUnavaliable;
    public int soundState;
    public long soundStartTime;
    public long duration;
    public Object player;
    public VolumeControl vc;
    public InputStream soundIs;

    public void playerUpdate(Player player, String string, Object object) {
        if (string.equals("deviceUnavailable")) {
            if (this.soundLoop) {
                this.deviceUnavaliable = true;
            }
            if (this.soundState == 3) {
                this.stop();
            }
            return;
        }
        if (string.equals("deviceAvailable")) {
            if (this.soundLoop && this.deviceUnavaliable) {
                if (this.soundState == 2) {
                    this.start();
                }
                this.deviceUnavaliable = false;
            }
            return;
        }
        if (string.equals("endOfMedia")) {
            if (!this.soundLoop) {
                this.soundState = 2;
            }
            return;
        }
    }

    public static MFPlayer createMFPlayer(String string) {
        int n = -1;
        String string2 = string.substring(string.lastIndexOf(46));
        for (int i = 0; i < SOUND_EXT.length; ++i) {
            if (!string2.equals(SOUND_EXT[i])) continue;
            n = SOUND_TYPE[i];
            break;
        }
        if (n != -1) {
            return new MFPlayer(string, n);
        }
        MFPlayer.mediaError(string, "create ", " type not support ");
        return null;
    }

    public MFPlayer(String string, int n) {
        this.soundUrl = string;
        this.soundType = n;
        this.soundLoop = false;
        this.soundState = 0;
        this.deviceUnavaliable = false;
        this.soundVolume = 100;
        this.deviceVolume = 100;
        this.duration = 0L;
    }

    public void setLoop(boolean bl) {
        this.soundLoop = bl;
    }

    public boolean isLoop() {
        return this.soundLoop;
    }

    public void setVolume(int n) {
        this.soundVolume = MFUtility.getValueInRange(n, 0, 100);
        this.deviceVolume = this.soundVolume * 100 / 100 + 0;
        if (this.vc != null) {
            this.vc.setLevel(this.deviceVolume);
        }
    }

    public int getState() {
        return this.soundState;
    }

    public void realize() {
        switch (this.soundState) {
            case 0: 
            case 4: {
                try {
                    Player player = null;
                    this.soundIs = MFDevice.getResourceAsStream(this.soundUrl);
                    player = Manager.createPlayer((InputStream)this.soundIs, (String)SOUND_TYPE_CONTENT[this.soundType]);
                    this.player = player;
                    ((Player)this.player).realize();
                    this.duration = ((Player)this.player).getDuration();
                    ((Player)this.player).addPlayerListener((PlayerListener)this);
                    this.soundState = 1;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                MFPlayer.mediaError(this.soundUrl, "realize", STATE_NAME[this.soundState]);
            }
        }
    }

    public void prefetch() {
        switch (this.soundState) {
            case 1: {
                try {
                    ((Player)this.player).prefetch();
                    this.vc = (VolumeControl)((Player)this.player).getControl("VolumeControl");
                    this.vc.setLevel(this.deviceVolume);
                    this.soundState = 2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                MFPlayer.mediaError(this.soundUrl, "prefetch", STATE_NAME[this.soundState]);
            }
        }
    }

    public void start() {
        switch (this.soundState) {
            case 2: {
                try {
                    ((Player)this.player).setLoopCount(this.soundLoop ? -1 : 1);
                    ((Player)this.player).start();
                    this.soundStartTime = System.currentTimeMillis();
                    this.soundState = 3;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                MFPlayer.mediaError(this.soundUrl, "start", STATE_NAME[this.soundState]);
            }
        }
    }

    public void stop() {
        switch (this.soundState) {
            case 3: {
                try {
                    ((Player)this.player).stop();
                    this.soundState = 2;
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            case 2: {
                break;
            }
            case 0: 
            case 1: 
            case 4: {
                MFPlayer.mediaError(this.soundUrl, "stop", STATE_NAME[this.soundState]);
            }
        }
    }

    public void deallocate() {
        switch (this.soundState) {
            case 3: {
                this.stop();
            }
            case 2: {
                try {
                    ((Player)this.player).deallocate();
                    this.vc = null;
                    this.soundState = 1;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 0: 
            case 1: 
            case 4: {
                MFPlayer.mediaError(this.soundUrl, "deallocate", STATE_NAME[this.soundState]);
            }
        }
    }

    public void close() {
        switch (this.soundState) {
            case 3: {
                this.stop();
            }
            case 2: {
                this.deallocate();
            }
            case 0: 
            case 1: {
                if (this.player != null) {
                    ((Player)this.player).removePlayerListener((PlayerListener)this);
                    ((Player)this.player).close();
                    if (this.soundIs != null) {
                        try {
                            this.soundIs.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.soundIs = null;
                    }
                    this.vc = null;
                }
                this.player = null;
                this.soundState = 4;
            }
        }
    }

    protected void tick() {
    }

    public static void mediaError(String string, String string2, String string3) {
    }
}

