/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public final class MFSound {
    static Vector soundVector;
    public static int soundVolume;
    public static boolean bgmFlag;
    public static boolean seFlag;
    public static MFPlayer lastBgm;
    public static MFPlayer bgm;
    public static MFPlayer nextBgm;
    public static MFPlayer nextSe;
    public static Vector seVector;
    public static boolean deviceInterrupt;
    public static boolean bgmStarted;
    public static boolean bgmPlaying;

    protected static void init() {
        bgmFlag = true;
        deviceInterrupt = false;
        soundVector = new Vector();
        seFlag = true;
        seVector = new Vector();
        soundVolume = 100;
    }

    protected static void tick() {
        MFPlayer mFPlayer;
        int n;
        for (n = 0; n < soundVector.size(); ++n) {
            mFPlayer = (MFPlayer)soundVector.elementAt(n);
            mFPlayer.tick();
        }
        if (bgmFlag) {
            if (deviceInterrupt) {
                MFSound.stopBgm();
            }
            if (nextBgm != null) {
                if (bgm != null && !MFSound.nextBgm.soundUrl.equals(MFSound.bgm.soundUrl)) {
                    bgm.stop();
                    bgm.deallocate();
                    bgm.close();
                }
                bgm = nextBgm;
                nextBgm = null;
                bgmStarted = false;
            }
            if (bgm != null && (bgm.isLoop() || !bgmStarted)) {
                bgmStarted = MFSound.updateSound(bgm);
            }
            if (bgm != null && !bgm.isLoop() && bgmStarted && bgm.getState() != 3) {
                bgmPlaying = false;
                bgmStarted = false;
                bgm.deallocate();
                bgm.close();
                bgm = null;
            }
        }
        if (nextSe != null) {
            for (n = 0; n < seVector.size(); ++n) {
                mFPlayer = (MFPlayer)seVector.elementAt(n);
                if (mFPlayer.soundPriority >= MFSound.nextSe.soundPriority) continue;
                seVector.insertElementAt(nextSe, n);
                nextSe = null;
                break;
            }
            if (nextSe != null) {
                seVector.addElement(nextSe);
                nextSe = null;
            }
        }
        if (seFlag) {
            MFPlayer mFPlayer2;
            if (seVector.size() > 0 && MFSound.updateSound(mFPlayer2 = (MFPlayer)seVector.elementAt(0))) {
                seVector.removeElementAt(0);
            }
        } else {
            seVector.removeAllElements();
        }
    }

    protected static void deviceInterrupt() {
        if (!deviceInterrupt) {
            MFSound.stopBgm();
            deviceInterrupt = true;
        }
    }

    protected static void deviceResume() {
        deviceInterrupt = false;
    }

    public static void setVolume(int n) {
        soundVolume = MFUtility.getValueInRange(n, 0, 100);
        for (int i = 0; i < soundVector.size(); ++i) {
            MFPlayer mFPlayer = (MFPlayer)soundVector.elementAt(i);
            mFPlayer.setVolume(soundVolume);
        }
    }

    public static int getVolume() {
        return soundVolume;
    }

    public static void setBgmFlag(boolean bl) {
        bgmFlag = bl;
        if (!bgmFlag) {
            MFSound.stopBgm();
        }
    }

    public static void setSeFlag(boolean bl) {
        seFlag = bl;
        if (!seFlag) {
            seVector.removeAllElements();
        }
    }

    public static void preloadSound(String string) {
        MFPlayer mFPlayer = MFSound.createMFPlayer(string);
        mFPlayer.realize();
        mFPlayer.prefetch();
    }

    public static void playBgm(String string, boolean bl) {
        nextBgm = null;
        for (int i = 0; i < soundVector.size(); ++i) {
            MFPlayer mFPlayer = (MFPlayer)soundVector.elementAt(i);
            if (!mFPlayer.soundUrl.equals(string)) continue;
            nextBgm = mFPlayer;
            break;
        }
        if (nextBgm == null) {
            nextBgm = MFSound.createMFPlayer(string);
        }
        nextBgm.setLoop(bl);
        bgmPlaying = true;
        lastBgm = nextBgm;
    }

    public static void stopBgm() {
        if (bgm != null) {
            bgm.stop();
            bgm.deallocate();
            bgm.close();
        }
        bgmPlaying = false;
        bgmStarted = false;
        bgm = null;
        nextBgm = null;
    }

    public static final boolean isBgmPlaying() {
        return bgmPlaying;
    }

    public static final void playSe(String string, int n) {
        MFPlayer mFPlayer = null;
        for (int i = 0; i < soundVector.size(); ++i) {
            MFPlayer mFPlayer2 = (MFPlayer)soundVector.elementAt(i);
            if (!mFPlayer2.soundUrl.equals(string)) continue;
            if (!seVector.contains(mFPlayer2)) {
                mFPlayer = mFPlayer2;
                break;
            }
            return;
        }
        if (mFPlayer == null) {
            mFPlayer = MFSound.createMFPlayer(string);
        }
        mFPlayer.soundPriority = n;
        if (nextSe == null || MFSound.nextSe.soundPriority < n) {
            nextSe = mFPlayer;
        }
    }

    public static void releaseAllSound() {
        for (int i = 0; i < soundVector.size(); ++i) {
            MFPlayer mFPlayer = (MFPlayer)soundVector.elementAt(i);
            mFPlayer.close();
        }
        seVector.removeAllElements();
        nextSe = null;
        nextBgm = null;
        bgm = null;
    }

    public static boolean updateSound(MFPlayer mFPlayer) {
        switch (mFPlayer.getState()) {
            case 0: 
            case 4: {
                mFPlayer.realize();
                break;
            }
            case 1: {
                mFPlayer.prefetch();
                break;
            }
            case 2: {
                mFPlayer.setVolume(soundVolume);
                mFPlayer.start();
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static MFPlayer createMFPlayer(String string) {
        MFPlayer mFPlayer = MFPlayer.createMFPlayer(string);
        soundVector.addElement(mFPlayer);
        return mFPlayer;
    }
}

